/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.tfs.command;

import java.util.ArrayList;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.AbstractBranchCommand;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.tfs.command.TfsCommand;
import org.apache.maven.scm.provider.tfs.command.consumer.ErrorStreamConsumer;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public class TfsBranchCommand
extends AbstractBranchCommand {
    protected ScmResult executeBranchCommand(ScmProviderRepository r, ScmFileSet f, String branch, String message) throws ScmException {
        ErrorStreamConsumer err;
        CommandLineUtils.StringStreamConsumer out;
        TfsCommand command = this.createCommand(r, f, branch);
        int status2 = command.execute(out = new CommandLineUtils.StringStreamConsumer(), err = new ErrorStreamConsumer());
        if (status2 != 0 || err.hasBeenFed()) {
            return new BranchScmResult(command.getCommandString(), "Error code for TFS branch command - " + status2, err.getOutput(), false);
        }
        return new BranchScmResult(command.getCommandString(), new ArrayList<ScmFile>(0));
    }

    public TfsCommand createCommand(ScmProviderRepository r, ScmFileSet f, String branch) {
        TfsCommand command = new TfsCommand("branch", r, f, this.getLogger());
        command.addArgument(f.getBasedir().getAbsolutePath());
        command.addArgument("-checkin");
        command.addArgument(branch);
        return command;
    }
}

