/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.unedit;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.perforce.command.AbstractPerforceConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceUnEditConsumer
extends AbstractPerforceConsumer
implements StreamConsumer {
    private static final String PATTERN = "^([^#]+)#\\d+ - (.*)";
    private static final int STATE_NORMAL = 1;
    private static final int STATE_ERROR = 2;
    private int currentState = 1;
    private List<ScmFile> edits = new ArrayList<ScmFile>();
    private RE revisionRegexp;

    public PerforceUnEditConsumer() {
        try {
            this.revisionRegexp = new RE(PATTERN);
        }
        catch (RESyntaxException ignored) {
            ignored.printStackTrace();
        }
    }

    public List<ScmFile> getEdits() {
        return this.edits;
    }

    @Override
    public void consumeLine(String line) {
        if (this.currentState != 2 && this.revisionRegexp.match(line)) {
            this.edits.add(new ScmFile(this.revisionRegexp.getParen(1), ScmFileStatus.UNKNOWN));
            return;
        }
        this.error(line);
    }

    private void error(String line) {
        this.currentState = 2;
        this.output.println(line);
    }

    public boolean isSuccess() {
        return this.currentState == 1;
    }
}

