/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.tag;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.PerforceInfoCommand;
import org.apache.maven.scm.provider.perforce.command.tag.PerforceTagConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceTagCommand
extends AbstractTagCommand
implements PerforceCommand {
    private String actualRepoLocation = null;
    private static final String NEWLINE = "\r\n";

    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet files, String tag2, String message) throws ScmException {
        return this.executeTagCommand(repo, files, tag2, new ScmTagParameters(message));
    }

    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet files, String tag2, ScmTagParameters scmTagParameters) throws ScmException {
        PerforceScmProviderRepository prepo = (PerforceScmProviderRepository)repo;
        this.actualRepoLocation = PerforceScmProvider.getRepoPath(this.getLogger(), prepo, files.getBasedir());
        PerforceTagConsumer consumer = new PerforceTagConsumer();
        this.createLabel(repo, files, tag2, consumer, false);
        if (consumer.isSuccess()) {
            this.syncLabel(repo, files, tag2, consumer);
        }
        if (consumer.isSuccess() && this.shouldLock()) {
            consumer = new PerforceTagConsumer();
            this.createLabel(repo, files, tag2, consumer, true);
        }
        if (consumer.isSuccess()) {
            return new TagScmResult("p4 label -i", consumer.getTagged());
        }
        return new TagScmResult("p4 label -i", "Tag failed", consumer.getOutput(), false);
    }

    private boolean shouldLock() {
        return Boolean.valueOf(System.getProperty("maven.scm.locktag", "true"));
    }

    private void syncLabel(ScmProviderRepository repo, ScmFileSet files, String tag2, PerforceTagConsumer consumer) {
        block4: {
            Commandline cl = PerforceTagCommand.createLabelsyncCommandLine((PerforceScmProviderRepository)repo, files.getBasedir(), files, tag2);
            try {
                CommandLineUtils.StringStreamConsumer err;
                int exitCode;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(PerforceScmProvider.clean("Executing: " + cl.toString()));
                }
                if ((exitCode = CommandLineUtils.executeCommandLine(cl, consumer, err = new CommandLineUtils.StringStreamConsumer())) != 0) {
                    String cmdLine = CommandLineUtils.toString(cl.getCommandline());
                    StringBuilder msg = new StringBuilder("Exit code: " + exitCode + " - " + err.getOutput());
                    msg.append('\n');
                    msg.append("Command line was:" + cmdLine);
                    throw new CommandLineException(msg.toString());
                }
            }
            catch (CommandLineException e) {
                if (!this.getLogger().isErrorEnabled()) break block4;
                this.getLogger().error("CommandLineException " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createLabel(ScmProviderRepository repo, ScmFileSet files, String tag2, PerforceTagConsumer consumer, boolean lock) {
        block15: {
            Commandline cl = PerforceTagCommand.createLabelCommandLine((PerforceScmProviderRepository)repo, files.getBasedir());
            DataOutputStream dos = null;
            InputStreamReader isReader = null;
            InputStreamReader isReaderErr = null;
            try {
                String line;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(PerforceScmProvider.clean("Executing: " + cl.toString()));
                }
                Process proc = cl.execute();
                OutputStream out = proc.getOutputStream();
                dos = new DataOutputStream(out);
                String label = this.createLabelSpecification((PerforceScmProviderRepository)repo, tag2, lock);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("LabelSpec: \r\n" + label);
                }
                dos.write(label.getBytes());
                dos.close();
                out.close();
                isReader = new InputStreamReader(proc.getInputStream());
                isReaderErr = new InputStreamReader(proc.getErrorStream());
                BufferedReader stdout = new BufferedReader(isReader);
                BufferedReader stderr = new BufferedReader(isReaderErr);
                while ((line = stdout.readLine()) != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Consuming stdout: " + line);
                    }
                    consumer.consumeLine(line);
                }
                while ((line = stderr.readLine()) != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Consuming stderr: " + line);
                    }
                    consumer.consumeLine(line);
                }
                stderr.close();
                stdout.close();
                IOUtil.close(dos);
            }
            catch (CommandLineException e) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("CommandLineException " + e.getMessage(), e);
                }
                break block15;
            }
            catch (IOException e2) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("IOException " + e2.getMessage(), e2);
                }
                break block15;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtil.close(dos);
                IOUtil.close(isReader);
                IOUtil.close(isReaderErr);
            }
            IOUtil.close(isReader);
            IOUtil.close(isReaderErr);
        }
    }

    public static Commandline createLabelCommandLine(PerforceScmProviderRepository repo, File workingDirectory) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArg().setValue("label");
        command.createArg().setValue("-i");
        return command;
    }

    public static Commandline createLabelsyncCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmFileSet files, String tag2) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArg().setValue("labelsync");
        command.createArg().setValue("-l");
        command.createArg().setValue(tag2);
        List<File> fs = files.getFileList();
        for (File file : fs) {
            command.createArg().setValue(file.getPath());
        }
        return command;
    }

    public String createLabelSpecification(PerforceScmProviderRepository repo, String tag2, boolean lock) {
        StringBuilder buf = new StringBuilder();
        buf.append("Label: ").append(tag2).append(NEWLINE);
        buf.append("View: ").append(PerforceScmProvider.getCanonicalRepoPath(this.actualRepoLocation)).append(NEWLINE);
        String username = repo.getUser();
        if (username == null) {
            username = PerforceInfoCommand.getInfo(this.getLogger(), repo).getEntry("User name");
        }
        buf.append("Owner: ").append(username).append(NEWLINE);
        buf.append("Options: ").append(lock ? "" : "un").append("locked").append(NEWLINE);
        return buf.toString();
    }
}

