/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.command.diff;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.bazaar.command.BazaarConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarDiffConsumer
extends BazaarConsumer {
    private static final String MODIFIED_FILE_TOKEN = "=== modified file ";
    private static final String ADDED_FILE_TOKEN = "=== added file ";
    private static final String DELETED_FILE_TOKEN = "=== deleted file ";
    private static final String NO_NEWLINE_TOKEN = "\\ No newline at end of file";
    private static final String FROM_FILE_TOKEN = "---";
    private static final String TO_FILE_TOKEN = "+++";
    private static final String ADDED_LINE_TOKEN = "+";
    private static final String REMOVED_LINE_TOKEN = "-";
    private static final String UNCHANGED_LINE_TOKEN = " ";
    private static final String RANGE_TOKEN = "@@";
    private ScmLogger logger;
    private File workingDirectory;
    private String currentFile;
    private StringBuilder currentDifference;
    private List<ScmFile> changedFiles = new ArrayList<ScmFile>();
    private Map<String, CharSequence> differences = new HashMap<String, CharSequence>();
    private StringBuilder patch = new StringBuilder();

    public BazaarDiffConsumer(ScmLogger logger, File workingDirectory) {
        super(logger);
        this.logger = logger;
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void doConsume(ScmFileStatus status2, String line) {
        String tmpLine = new String(line);
        this.patch.append(line).append("\n");
        if (line.startsWith(MODIFIED_FILE_TOKEN)) {
            tmpLine = line.substring(MODIFIED_FILE_TOKEN.length());
            tmpLine = tmpLine.trim();
            status2 = ScmFileStatus.MODIFIED;
            this.addChangedFile(status2, line, tmpLine);
        } else if (line.startsWith(ADDED_FILE_TOKEN)) {
            tmpLine = line.substring(ADDED_FILE_TOKEN.length());
            tmpLine = tmpLine.trim();
            status2 = ScmFileStatus.ADDED;
            this.addChangedFile(status2, line, tmpLine);
        } else if (line.startsWith(DELETED_FILE_TOKEN)) {
            tmpLine = line.substring(DELETED_FILE_TOKEN.length());
            tmpLine = tmpLine.trim();
            status2 = ScmFileStatus.DELETED;
            this.addChangedFile(status2, line, tmpLine);
        } else if (!line.startsWith(TO_FILE_TOKEN) && !line.startsWith(FROM_FILE_TOKEN) && (line.startsWith(ADDED_LINE_TOKEN) || line.startsWith(REMOVED_LINE_TOKEN) || line.startsWith(UNCHANGED_LINE_TOKEN) || line.startsWith(RANGE_TOKEN) || line.startsWith(NO_NEWLINE_TOKEN))) {
            this.currentDifference.append(line).append("\n");
        }
    }

    private void addChangedFile(ScmFileStatus status2, String line, String tmpLine) {
        int index;
        boolean ok = this.addChangedFile(status2, tmpLine = tmpLine.substring(1, tmpLine.length() - 1));
        if (!ok && (index = tmpLine.indexOf(47)) > -1) {
            tmpLine = tmpLine.substring(index + 1);
            ok = this.addChangedFile(status2, tmpLine);
        }
        if (!ok && this.logger.isWarnEnabled()) {
            this.logger.warn("Could not figure out of line: " + line);
        }
    }

    private boolean addChangedFile(ScmFileStatus status2, String tmpLine) {
        File tmpFile = new File(this.workingDirectory, tmpLine);
        if (status2.equals(ScmFileStatus.DELETED)) {
            return true;
        }
        if (tmpFile.isFile()) {
            this.currentFile = tmpLine;
            this.currentDifference = new StringBuilder();
            this.differences.put(this.currentFile, this.currentDifference);
            this.changedFiles.add(new ScmFile(tmpLine, status2));
            return true;
        }
        return false;
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }

    public Map<String, CharSequence> getDifferences() {
        return this.differences;
    }

    public String getPatch() {
        return this.patch.toString();
    }
}

