/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.client.cli;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.util.StringUtils;

public class MavenScmCli {
    private Embedder plexus = new Embedder();
    private ScmManager scmManager;

    public MavenScmCli() throws Exception {
        this.plexus.start();
        this.scmManager = (ScmManager)this.plexus.lookup(ScmManager.ROLE);
    }

    public void stop() {
        try {
            this.plexus.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        void var5_12;
        MavenScmCli cli;
        try {
            cli = new MavenScmCli();
        }
        catch (Exception ex) {
            System.err.println("Error while starting Maven Scm.");
            ex.printStackTrace(System.err);
            return;
        }
        if (args.length != 3) {
            System.err.println("Usage: maven-scm-client <command> <working directory> <scm url> [<scmVersion> [<scmVersionType>]]");
            System.err.println("scmVersion is a branch name/tag name/revision number.");
            System.err.println("scmVersionType can be 'branch', 'tag', 'revision'. The default value is 'revision'.");
            return;
        }
        String command = args[0];
        File workingDirectory = new File(args[1]).getAbsoluteFile();
        String scmUrl = args[2];
        Object var5_6 = null;
        if (args.length > 3) {
            String version = args[3];
            if (args.length > 4) {
                String type = args[4];
                if ("tag".equals(type)) {
                    ScmTag scmTag = new ScmTag(version);
                } else if ("branch".equals(type)) {
                    ScmBranch scmBranch = new ScmBranch(version);
                } else {
                    if (!"revision".equals(type)) throw new IllegalArgumentException("'" + type + "' version type isn't known.");
                    ScmRevision scmRevision = new ScmRevision(version);
                }
            } else {
                ScmRevision scmRevision = new ScmRevision(args[3]);
            }
        }
        cli.execute(scmUrl, command, workingDirectory, (ScmVersion)var5_12);
        cli.stop();
    }

    public void execute(String scmUrl, String command, File workingDirectory, ScmVersion version) {
        ScmRepository repository;
        try {
            repository = this.scmManager.makeScmRepository(scmUrl);
        }
        catch (NoSuchScmProviderException ex) {
            System.err.println("Could not find a provider.");
            return;
        }
        catch (ScmRepositoryException ex) {
            System.err.println("Error while connecting to the repository");
            ex.printStackTrace(System.err);
            return;
        }
        try {
            if (command.equals("checkout")) {
                this.checkOut(repository, workingDirectory, version);
            } else if (command.equals("checkin")) {
                this.checkIn(repository, workingDirectory, version);
            } else if (command.equals("update")) {
                this.update(repository, workingDirectory, version);
            } else {
                System.err.println("Unknown SCM command '" + command + "'.");
            }
        }
        catch (ScmException ex) {
            System.err.println("Error while executing the SCM command.");
            ex.printStackTrace(System.err);
            return;
        }
    }

    private void checkOut(ScmRepository scmRepository, File workingDirectory, ScmVersion version) throws ScmException {
        if (workingDirectory.exists()) {
            System.err.println("The working directory already exist: '" + workingDirectory.getAbsolutePath() + "'.");
            return;
        }
        if (!workingDirectory.mkdirs()) {
            System.err.println("Error while making the working directory: '" + workingDirectory.getAbsolutePath() + "'.");
            return;
        }
        CheckOutScmResult result = this.scmManager.checkOut(scmRepository, new ScmFileSet(workingDirectory), version);
        if (!result.isSuccess()) {
            this.showError(result);
            return;
        }
        List<ScmFile> checkedOutFiles = result.getCheckedOutFiles();
        System.out.println("Checked out these files: ");
        for (ScmFile file : checkedOutFiles) {
            System.out.println(" " + file.getPath());
        }
    }

    private void checkIn(ScmRepository scmRepository, File workingDirectory, ScmVersion version) throws ScmException {
        if (!workingDirectory.exists()) {
            System.err.println("The working directory doesn't exist: '" + workingDirectory.getAbsolutePath() + "'.");
            return;
        }
        String message = "";
        CheckInScmResult result = this.scmManager.checkIn(scmRepository, new ScmFileSet(workingDirectory), version, message);
        if (!result.isSuccess()) {
            this.showError(result);
            return;
        }
        List<ScmFile> checkedInFiles = result.getCheckedInFiles();
        System.out.println("Checked in these files: ");
        for (ScmFile file : checkedInFiles) {
            System.out.println(" " + file.getPath());
        }
    }

    private void update(ScmRepository scmRepository, File workingDirectory, ScmVersion version) throws ScmException {
        if (!workingDirectory.exists()) {
            System.err.println("The working directory doesn't exist: '" + workingDirectory.getAbsolutePath() + "'.");
            return;
        }
        UpdateScmResult result = this.scmManager.update(scmRepository, new ScmFileSet(workingDirectory), version);
        if (!result.isSuccess()) {
            this.showError(result);
            return;
        }
        List<ScmFile> updatedFiles = result.getUpdatedFiles();
        System.out.println("Updated these files: ");
        for (ScmFile file : updatedFiles) {
            System.out.println(" " + file.getPath());
        }
    }

    private void showError(ScmResult result) {
        System.err.println("There was a error while executing the SCM command.");
        String providerMessage = result.getProviderMessage();
        if (!StringUtils.isEmpty(providerMessage)) {
            System.err.println("Error message from the provider: " + providerMessage);
        } else {
            System.err.println("The provider didn't give a error message.");
        }
        String output = result.getCommandOutput();
        if (!StringUtils.isEmpty(output)) {
            System.err.println("Command output:");
            System.err.println(output);
        }
    }
}

