/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers;

import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.registry.extensions.handlers.PolicyUriHandler;
import org.wso2.carbon.governance.registry.extensions.handlers.SchemaUriHandler;
import org.wso2.carbon.governance.registry.extensions.handlers.WsdlUriHandler;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class UriMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(UriMediaTypeHandler.class);

    public void put(RequestContext requestContext) throws GovernanceException {
        Registry registry = requestContext.getRegistry();
        Resource resource = requestContext.getResource();
        String resourcePath = requestContext.getResourcePath().getPath();
        String fileUri = null;
        String type = null;
        try {
            String newContent = resource.getContent() instanceof String ? (String)resource.getContent() : RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
            if (registry.resourceExists(resourcePath)) {
                return;
            }
            OMElement docElement = AXIOMUtil.stringToOM((String)newContent);
            SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
            simpleNamespaceContext.addNamespace("pre", docElement.getNamespace().getNamespaceURI());
            AXIOMXPath expression = new AXIOMXPath("//pre:overview");
            expression.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
            List overview = expression.selectNodes((Object)docElement);
            Iterator elements = ((OMElement)overview.get(0)).getChildElements();
            while (elements.hasNext()) {
                OMElement element = (OMElement)elements.next();
                String localName = element.getLocalName();
                if ("uri".equals(localName)) {
                    fileUri = element.getText();
                    continue;
                }
                if (!"type".equals(localName)) continue;
                type = element.getText();
            }
        }
        catch (Exception e) {
            String msg = "Failed to parse content of URI ";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, (Throwable)e);
        }
        try {
            if ("WSDL".equals(type)) {
                WsdlUriHandler wsdlUriHandler = new WsdlUriHandler();
                wsdlUriHandler.importResource(requestContext, fileUri);
            } else if ("XSD".equals(type)) {
                SchemaUriHandler schemaUriHandler = new SchemaUriHandler();
                schemaUriHandler.importResource(requestContext, fileUri);
            } else if ("Policy".equals(type)) {
                PolicyUriHandler policyUriHandler = new PolicyUriHandler();
                policyUriHandler.importResource(requestContext, fileUri);
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to add " + type + " URI";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, (Throwable)e);
        }
    }
}

