/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.wso2.carbon.governance.api.common.GovernanceArtifactManager;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class JCRHandler
extends Handler {
    private String key = null;

    public void setKey(String key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            UserRegistry registry = (UserRegistry)GovernanceUtils.getGovernanceSystemRegistry((Registry)requestContext.getSystemRegistry());
            Resource resource = requestContext.getResource();
            String tempKey = this.key;
            if (tempKey == null) {
                GovernanceUtils.loadGovernanceArtifacts((UserRegistry)registry);
                List governanceArtifactConfigurations = GovernanceUtils.findGovernanceArtifactConfigurations((Registry)registry);
                for (GovernanceArtifactConfiguration configuration : governanceArtifactConfigurations) {
                    if (!configuration.getMediaType().equals(resource.getMediaType())) continue;
                    tempKey = configuration.getKey();
                    break;
                }
            }
            GenericArtifactManager manager = new GenericArtifactManager((Registry)registry, tempKey);
            Object content = resource.getContent();
            try {
                String contentString = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
                Resource oldResource = requestContext.getOldResource();
                String oldContentString = "";
                if (oldResource != null) {
                    Object oldContent = oldResource.getContent();
                    oldContentString = oldContent instanceof String ? (String)oldContent : RegistryUtils.decodeBytes((byte[])((byte[])oldContent));
                }
                if (oldResource == null || !contentString.equals(oldContentString)) {
                    String[] attributeKeys;
                    OMElement contentElement = AXIOMUtil.stringToOM((String)contentString);
                    GenericArtifact genericArtifact = manager.newGovernanceArtifact(contentElement);
                    for (String key : attributeKeys = genericArtifact.getAttributeKeys()) {
                        resource.setProperty(key, Arrays.asList(genericArtifact.getAttributes(key)));
                    }
                } else {
                    Properties properties = resource.getProperties();
                    GenericArtifact genericArtifact = manager.newGovernanceArtifact(new QName("Dummy"));
                    for (Object key : properties.keySet()) {
                        String keyString = (String)key;
                        if (!keyString.contains("_") || RegistryUtils.isHiddenProperty((String)keyString)) continue;
                        List propertyValues = resource.getPropertyValues(keyString);
                        if (propertyValues.size() > 1) {
                            genericArtifact.setAttributes(keyString, propertyValues.toArray(new String[propertyValues.size()]));
                            continue;
                        }
                        genericArtifact.setAttribute(keyString, (String)propertyValues.get(0));
                    }
                    new GovernanceArtifactManager(null, null, null, null, "metadata", "http://www.wso2.org/governance/metadata", null, null){

                        protected void setContent(GovernanceArtifact artifact, Resource resource) throws GovernanceException {
                            super.setContent(artifact, resource);
                        }
                    }.setContent((GovernanceArtifact)genericArtifact, resource);
                }
            }
            catch (XMLStreamException e) {
                throw new RegistryException("Unable to parse content", (Throwable)e);
            }
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }
}

