/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors.apistore;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ApiStoreExecutor
implements Execution {
    Log log = LogFactory.getLog(ApiStoreExecutor.class);
    private final String API_ARTIFACT_KEY = "api";
    private final String DEFAULT_TIER = "CREATED";
    private final String DEFAULT_URI_TEMPLATE = "GET:/*";
    public static final String API_OVERVIEW_NAME = "overview_name";
    public static final String API_OVERVIEW_VERSION = "overview_version";
    public static final String API_OVERVIEW_CONTEXT = "overview_context";
    public static final String API_OVERVIEW_ENDPOINT_URL = "overview_endpointURL";
    public static final String API_OVERVIEW_WSDL = "overview_WSDL";
    public static final String API_OVERVIEW_PROVIDER = "overview_provider";
    public static final String API_OVERVIEW_TIER = "overview_tier";
    public static final String API_OVERVIEW_URI_TEMPLATES = "uriTemplates_entry";

    @Override
    public void init(Map parameterMap) {
    }

    @Override
    public boolean execute(RequestContext context, String currentState, String targetState) {
        Resource resource = context.getResource();
        try {
            String artifactString = RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
            String user = CarbonContext.getCurrentContext().getUsername();
            OMElement xmlContent = AXIOMUtil.stringToOM((String)artifactString);
            String serviceName = CommonUtil.getServiceName((OMElement)xmlContent);
            GenericArtifactManager artifactManager = new GenericArtifactManager((Registry)RegistryCoreServiceComponent.getRegistryService().getGovernanceUserRegistry(user), "api");
            GenericArtifact genericArtifact = artifactManager.newGovernanceArtifact(new QName(serviceName));
            ServiceManager serviceManager = new ServiceManager((Registry)RegistryCoreServiceComponent.getRegistryService().getGovernanceUserRegistry(user));
            Service service = serviceManager.getService(context.getResource().getUUID());
            genericArtifact.setAttribute(API_OVERVIEW_NAME, serviceName);
            genericArtifact.setAttribute(API_OVERVIEW_CONTEXT, serviceName);
            genericArtifact.setAttribute(API_OVERVIEW_VERSION, service.getAttribute(API_OVERVIEW_VERSION));
            if (service.getAttachedWsdls().length > 0) {
                String url = service.getAttachedWsdls()[0].getUrl();
                genericArtifact.setAttribute(API_OVERVIEW_WSDL, url);
            }
            if (service.getAttachedEndpoints().length > 0) {
                genericArtifact.setAttribute(API_OVERVIEW_ENDPOINT_URL, service.getAttachedEndpoints()[0].getUrl());
            }
            genericArtifact.setAttribute(API_OVERVIEW_PROVIDER, CarbonContext.getCurrentContext().getUsername());
            genericArtifact.setAttribute(API_OVERVIEW_TIER, "CREATED");
            genericArtifact.setAttribute(API_OVERVIEW_URI_TEMPLATES, "GET:/*");
            artifactManager.addGenericArtifact(genericArtifact);
        }
        catch (RegistryException e) {
            this.log.error((Object)"Failed to publish service to API store ", (Throwable)e);
            return false;
        }
        catch (XMLStreamException e) {
            this.log.error((Object)"Failed to convert service to xml content");
            return false;
        }
        return true;
    }
}

