/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.util.URLProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.extensions.beans.ServiceDocumentsBean;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;
import org.wso2.carbon.user.core.service.RealmService;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static Random generator = new Random();
    private static InheritableThreadLocal<Map<String, String>> artifactIndexMap = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return null;
        }
    };
    private static InheritableThreadLocal<Map<String, String>> symbolicLinkMap = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return null;
        }
    };
    private static InheritableThreadLocal<Set<String>> importedArtifacts = new InheritableThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new ConcurrentSkipListSet<String>();
        }
    };
    private static ThreadLocal<Boolean> updateInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> deleteInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> restoringInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> addingAssociationInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static String getUniqueNameforNamespace(String commonSchemaLocation, String targetNamespace1) {
        String targetNamespace = targetNamespace1.replaceAll("\\s+$", "");
        targetNamespace = targetNamespace.replace("://", "/");
        targetNamespace = targetNamespace.replace(".", "/");
        targetNamespace = targetNamespace.replace("#", "/");
        while (targetNamespace.indexOf("//") > 0) {
            targetNamespace = targetNamespace.replace("//", "/");
        }
        String resourcePath = commonSchemaLocation.endsWith("/") ? commonSchemaLocation + targetNamespace : commonSchemaLocation + "/" + targetNamespace;
        if (!targetNamespace.endsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        return resourcePath;
    }

    public static String derivePathFragmentFromNamespace(String namespace) {
        String packageName;
        if (namespace == null || (packageName = URLProcessor.makePackageName((String)namespace)) == null) {
            return "//";
        }
        String pathFragment = "/" + packageName.replace(".", "/");
        if (pathFragment.endsWith("/")) {
            return pathFragment;
        }
        return pathFragment + "/";
    }

    public static String getServiceName(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Name")) != null) {
            return overview.getFirstChildWithName(new QName("Name")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")).getText();
        }
        return "";
    }

    public static void setServiceName(OMElement element, String serviceName) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Name")) != null) {
            overview.getFirstChildWithName(new QName("Name")).setText(serviceName);
            return;
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")) != null) {
            overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")).setText(serviceName);
        }
    }

    public static String getServiceNamespace(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Namespace")) != null) {
            return overview.getFirstChildWithName(new QName("Namespace")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")).getText();
        }
        return "";
    }

    public static String computeServicePathWithVersion(String path, String version) throws RegistryException {
        String temp = version;
        String suffix = "-SNAPSHOT";
        if (temp.endsWith(suffix)) {
            temp = temp.substring(0, temp.length() - suffix.length());
        }
        if (!temp.matches("^\\d+[.]\\d+[.]\\d+(-[a-zA-Z0-9]+)?$")) {
            String msg = "The specified service version " + version + " is invalid. " + "The requested path to store the service: " + path + ".";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        return path + "/" + version + "/" + "service";
    }

    public static String computeProcessPathWithVersion(String path, String version) throws RegistryException {
        if (!version.matches("^\\d+[.]\\d+[.]\\d+(-[a-zA-Z0-9]+)?$")) {
            String msg = "The specified process version " + version + " is invalid. " + "The requested path to store the process: " + path + ".";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        return path + "/" + version.replace(".", "/") + "/" + "process";
    }

    public static String computeSLAPathWithVersion(String path, String version) throws RegistryException {
        if (!version.matches("^\\d+[.]\\d+[.]\\d+(-[a-zA-Z0-9]+)?$")) {
            String msg = "The specified sla version " + version + " is invalid. " + "The requested path to store the sla: " + path + ".";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        return path + "/" + version.replace(".", "/") + "/" + "sla";
    }

    public static void setServiceNamespace(OMElement element, String namespace) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Namespace")) != null) {
            overview.getFirstChildWithName(new QName("Namespace")).setText(namespace);
            return;
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")) != null) {
            overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")).setText(namespace);
        }
    }

    public static OMElement[] getEndpointEntries(OMElement element) {
        OMElement endPoints = element.getFirstChildWithName(new QName("endpoints"));
        if (endPoints != null) {
            Iterator it = endPoints.getChildrenWithLocalName("entry");
            ArrayList<OMElement> endpointList = new ArrayList<OMElement>();
            while (it.hasNext()) {
                endpointList.add((OMElement)it.next());
            }
            return endpointList.toArray(new OMElement[endpointList.size()]);
        }
        endPoints = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "endpoints"));
        if (endPoints != null) {
            Iterator it = endPoints.getChildrenWithName(new QName("http://www.wso2.org/governance/metadata", "entry"));
            ArrayList<OMElement> endpointList = new ArrayList<OMElement>();
            while (it.hasNext()) {
                endpointList.add((OMElement)it.next());
            }
            return endpointList.toArray(new OMElement[endpointList.size()]);
        }
        return null;
    }

    public static void setEndpointEntries(OMElement element, OMElement[] endPointsList) {
        ArrayList<String> addedEndpoints = new ArrayList<String>();
        OMElement endPoints = element.getFirstChildWithName(new QName("endpoints"));
        if (endPointsList != null) {
            if (endPoints != null) {
                Iterator it = endPoints.getChildElements();
                while (it.hasNext()) {
                    OMElement omElement = (OMElement)it.next();
                    addedEndpoints.add(omElement.getText());
                }
                for (OMElement endPoint : endPointsList) {
                    if (addedEndpoints.contains(endPoint.getText())) continue;
                    endPoints.addChild((OMNode)endPoint);
                    addedEndpoints.add(endPoint.getText());
                }
                return;
            }
            endPoints = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "endpoints"));
            if (endPoints != null) {
                addedEndpoints.clear();
                Iterator it = endPoints.getChildElements();
                while (it.hasNext()) {
                    OMElement omElement = (OMElement)it.next();
                    addedEndpoints.add(omElement.getText());
                }
                for (OMElement endPoint : endPointsList) {
                    if (addedEndpoints.contains(endPoint.getText())) continue;
                    endPoints.addChild((OMNode)endPoint);
                    addedEndpoints.add(endPoint.getText());
                }
            }
        }
    }

    public static void setServiceVersion(OMElement element, String version) {
        OMElement omElement;
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null) {
            if (overview.getFirstChildWithName(new QName("Version")) != null) {
                overview.getFirstChildWithName(new QName("Version")).setText(version);
                return;
            }
            omElement = OMAbstractFactory.getOMFactory().createOMElement(new QName("Version"));
            omElement.setText(version);
            overview.addChild((OMNode)omElement);
        }
        if ((overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"))) != null) {
            if (overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "version")) != null) {
                overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "version")).setText(version);
            } else {
                omElement = OMAbstractFactory.getOMFactory().createOMElement(new QName("http://www.wso2.org/governance/metadata", "version"));
                omElement.setText(version);
                overview.addChild((OMNode)omElement);
            }
        }
    }

    public static void setWSDLURL(OMElement element, String namespace) {
        OMElement overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "interface"));
        if (overview == null) {
            OMElement interfaceElement = OMAbstractFactory.getOMFactory().createOMElement(new QName("http://www.wso2.org/governance/metadata", "interface"));
            OMElement wsdlURLElement = OMAbstractFactory.getOMFactory().createOMElement(new QName("http://www.wso2.org/governance/metadata", "wsdlURL"));
            wsdlURLElement.setText(namespace);
            interfaceElement.addChild((OMNode)wsdlURLElement);
            element.addChild((OMNode)interfaceElement);
            return;
        }
        if (overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "wsdlURL")) != null) {
            overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "wsdlURL")).setText(namespace);
        }
    }

    public static String getWSDLURL(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Interface"));
        if (overview != null && overview.getFirstChildWithName(new QName("WSDL-URL")) != null) {
            return overview.getFirstChildWithName(new QName("WSDL-URL")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "interface"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "wsdlURL")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "wsdlURL")).getText();
        }
        return "";
    }

    public static String getWorkflowURL(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "definition"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "bpelURL")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "bpelURL")).getText();
        }
        return "";
    }

    public static ArrayList<ServiceDocumentsBean> getDocLinks(OMElement element) {
        ArrayList<ServiceDocumentsBean> documents = new ArrayList<ServiceDocumentsBean>();
        OMElement docLinks = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "docLinks"));
        if (docLinks != null) {
            for (int itemNo = 0; itemNo <= 3; ++itemNo) {
                ServiceDocumentsBean document = new ServiceDocumentsBean();
                String appender = itemNo == 0 ? "" : "" + itemNo + "";
                String description = "documentComment" + appender;
                String url = "url" + appender;
                String type = "documentType" + appender;
                if (docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", url)) != null) {
                    String documentUrl = docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", url)).getText();
                    document.setDocumentUrl(documentUrl);
                }
                if (document.getDocumentUrl() == null || document.getDocumentUrl().isEmpty()) break;
                documents.add(document);
                if (docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", description)) != null) {
                    String documentDesc = docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", description)).getText();
                    document.setDocumentDescription(documentDesc);
                }
                if (docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", type)) == null) continue;
                String documentType = docLinks.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", type)).getText();
                document.setDocumentType(documentType);
            }
        }
        return documents;
    }

    public static String getServiceDescription(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "description")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "description")).getText();
        }
        return null;
    }

    public static boolean isArtifactIndexMapExisting() {
        return artifactIndexMap.get() != null;
    }

    public static void createArtifactIndexMap() {
        artifactIndexMap.set(new ConcurrentHashMap());
    }

    public static void addToArtifactIndexMap(String key, String value) {
        ((Map)artifactIndexMap.get()).put(key, value);
    }

    public static Map<String, String> getAndRemoveArtifactIndexMap() {
        Map output = (Map)artifactIndexMap.get();
        artifactIndexMap.set(null);
        return output;
    }

    public static boolean isSymbolicLinkMapExisting() {
        return symbolicLinkMap.get() != null;
    }

    public static void createSymbolicLinkMap() {
        symbolicLinkMap.set(new ConcurrentHashMap());
    }

    public static void addToSymbolicLinkMap(String key, String value) {
        ((Map)symbolicLinkMap.get()).put(key, value);
    }

    public static Map<String, String> getAndRemoveSymbolicLinkMap() {
        Map output = (Map)symbolicLinkMap.get();
        symbolicLinkMap.set(null);
        return output;
    }

    public static synchronized void loadImportedArtifactMap() {
        importedArtifacts.get();
    }

    public static synchronized void clearImportedArtifactMap() {
        importedArtifacts.remove();
    }

    public static synchronized void addImportedArtifact(String path) {
        ((Set)importedArtifacts.get()).add(path);
    }

    public static synchronized boolean isImportedArtifactExisting(String path) {
        return ((Set)importedArtifacts.get()).contains(path);
    }

    public static boolean isUpdateLockAvailable() {
        return updateInProgress.get() == false;
    }

    public static void acquireUpdateLock() {
        updateInProgress.set(true);
    }

    public static void releaseUpdateLock() {
        updateInProgress.set(false);
    }

    public static boolean isDeleteLockAvailable() {
        return deleteInProgress.get() == false;
    }

    public static void acquireDeleteLock() {
        deleteInProgress.set(true);
    }

    public static void releaseDeleteLock() {
        deleteInProgress.set(false);
    }

    public static boolean isRestoringLockAvailable() {
        return restoringInProgress.get() == false;
    }

    public static void acquireRestoringLock() {
        restoringInProgress.set(true);
    }

    public static void releaseRestoringLock() {
        restoringInProgress.set(false);
    }

    public static boolean isAddingAssociationLockAvailable() {
        return addingAssociationInProgress.get() == false;
    }

    public static void acquireAddingAssociationLock() {
        addingAssociationInProgress.set(true);
    }

    public static void releaseAddingAssociationLock() {
        addingAssociationInProgress.set(false);
    }

    public static String getEndpointPathFromUrl(String url) {
        String urlToPath = EndpointUtils.deriveEndpointFromUrl(url);
        return EndpointUtils.getEndpointLocation() + urlToPath;
    }

    public static Registry getUnchrootedSystemRegistry(RequestContext requestContext) throws RegistryException {
        Registry registry = requestContext.getRegistry();
        RealmService realmService = registry.getRegistryContext().getRealmService();
        String systemUser = "wso2.system.user";
        return new UserRegistry(systemUser, CurrentSession.getTenantId(), registry, realmService, null);
    }

    public static String getConsumerType(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Type")) != null) {
            return overview.getFirstChildWithName(new QName("Type")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "type")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "type")).getText();
        }
        return "";
    }

    public static String getPeopleGroup(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Group")) != null) {
            return overview.getFirstChildWithName(new QName("Group")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "group")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "group")).getText();
        }
        return "";
    }

    public static String getPeopleType(OMElement element) {
        OMElement overview = element.getFirstChildWithName(new QName("Overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("Type")) != null) {
            return overview.getFirstChildWithName(new QName("Type")).getText();
        }
        overview = element.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null && overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "type")) != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "type")).getText();
        }
        return "";
    }

    public static Association[] getDependenciesRecursively(Registry registry, String resourcePath) throws RegistryException {
        return CommonUtil.getDependenciesRecursively(registry, resourcePath, new ArrayList<String>());
    }

    private static Association[] getDependenciesRecursively(Registry registry, String resourcePath, List<String> traversedDependencyPaths) throws RegistryException {
        ArrayList<Association> dependencies = new ArrayList<Association>();
        if (!traversedDependencyPaths.contains(resourcePath)) {
            traversedDependencyPaths.add(resourcePath);
            List<Association> tempDependencies = Arrays.asList(registry.getAssociations(resourcePath, "depends"));
            for (Association association : tempDependencies) {
                if (traversedDependencyPaths.contains(association.getDestinationPath())) continue;
                dependencies.add(association);
                List<Association> childDependencies = Arrays.asList(CommonUtil.getDependenciesRecursively(registry, association.getDestinationPath(), traversedDependencyPaths));
                if (childDependencies.isEmpty()) continue;
                dependencies.addAll(childDependencies);
            }
        }
        return dependencies.toArray(new Association[dependencies.size()]);
    }
}

