/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.jmx;

import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.extensions.jmx.Activities;
import org.wso2.carbon.registry.extensions.jmx.PropertiesMBean;
import org.wso2.carbon.registry.extensions.jmx.Utils;

public class Properties
implements PropertiesMBean {
    private static final Log log = LogFactory.getLog(Activities.class);
    private Registry registry;

    public Properties(Registry registry) {
        this.registry = registry;
    }

    public String[] getProperties(String path) {
        LinkedList<String> output = new LinkedList<String>();
        try {
            java.util.Properties properties = this.registry.get(path).getProperties();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                output.add(e.getKey() + ":" + e.getValue());
            }
        }
        catch (RegistryException e) {
            String msg = "Unable to fetch all properties.";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(Utils.buildMessageForRuntimeException((Exception)((Object)e), msg));
        }
        return output.toArray(new String[output.size()]);
    }

    public String getProperty(String path, String key) {
        try {
            return this.registry.get(path).getProperty(key);
        }
        catch (RegistryException e) {
            String msg = "Unable to fetch property value.";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(Utils.buildMessageForRuntimeException((Exception)((Object)e), msg));
        }
    }

    public void setProperty(String path, String key, String value) {
        try {
            Resource resource = this.registry.get(path);
            resource.setProperty(key, value);
            this.registry.put(path, resource);
        }
        catch (RegistryException e) {
            String msg = "Unable to set property value.";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(Utils.buildMessageForRuntimeException((Exception)((Object)e), msg));
        }
    }

    public void removeProperty(String path, String key) {
        try {
            Resource resource = this.registry.get(path);
            resource.removeProperty(key);
            this.registry.put(path, resource);
        }
        catch (RegistryException e) {
            String msg = "Unable to remove property.";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(Utils.buildMessageForRuntimeException((Exception)((Object)e), msg));
        }
    }
}

