/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsdl.validation.internal.IValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.ValidationInfoImpl;
import org.eclipse.wst.wsdl.validation.internal.exception.ValidateWSDLException;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ClassloaderWSDL11ValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ValidatorRegistry;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11BasicValidator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidationInfoImpl;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorController;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDLDocument;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.http.HTTPValidator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.mime.MIMEValidator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.soap.SOAPValidator;
import org.eclipse.wst.wsdl.validation.internal.xml.LineNumberDOMParser;
import org.eclipse.wst.wsi.internal.WSITestToolsPlugin;
import org.eclipse.wst.wsi.internal.WSITestToolsProperties;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.validator.BaseValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.ProfileValidatorFactoryImpl;
import org.eclipse.wst.wsi.internal.validate.wsdl.WSDLValidator;
import org.w3c.dom.Document;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.extensions.handlers.utils.ExWSDLReaderImpl;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;
import org.xml.sax.SAXException;

public class WSDLUtils {
    public static final String WSDL_VALIDATION_MESSAGE = "WSDL Validation Message ";
    public static final String WSI_VALIDATION_MESSAGE = "WSI Validation Message ";
    public static final String WSDL_STATUS = "WSDL Validation";
    public static final String WSI_STATUS = "WSI Validation";
    public static final String VALID = "Valid";
    public static final String INVALID = "Invalid";
    private static Log log = LogFactory.getLog(WSDLUtils.class);

    public static String[] validateForWSI(String uri) throws RegistryException {
        LinkedList<String> errorMesage = new LinkedList<String>();
        boolean validationFailed = false;
        try {
            IValidationMessage[] messages;
            DocumentBuilder db;
            log.trace((Object)"Initializing WSI Validator");
            if (WSITestToolsPlugin.getPlugin() == null) {
                WSITestToolsPlugin.getInstance();
                WSITestToolsProperties.setEclipseContext((boolean)false);
                BaseValidator[] validators = new BaseValidator[4];
                ProfileValidatorFactoryImpl factory = new ProfileValidatorFactoryImpl();
                validators[0] = factory.newWSDLValidator();
                validators[1] = factory.newUDDIValidator();
                validators[2] = factory.newEnvelopeValidator();
                validators[3] = factory.newMessageValidator();
                WSITestToolsPlugin.getPlugin().setBaseValidators(validators);
            }
            WSDLValidator validator = new WSDLValidator();
            ResourceBundle rb = ResourceBundle.getBundle("validatewsdl");
            MessageGenerator messagegenerator = new MessageGenerator(rb);
            ValidationInfoImpl info = new ValidationInfoImpl(uri, messagegenerator);
            URIResolver uriResolver = new URIResolver();
            info.setURIResolver(uriResolver);
            StandardParserConfiguration configuration = new StandardParserConfiguration();
            LineNumberDOMParser builder = new LineNumberDOMParser((XMLParserConfiguration)configuration);
            builder.parse(uri);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (Exception e) {
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
            }
            log.trace((Object)"Finished initializing WSI Validator");
            Document doc = db.parse(uri);
            log.trace((Object)"Finished parsing document");
            log.trace((Object)"Invoking WSI Validate method on WSDL");
            validator.validate(doc, (IValidationInfo)info);
            log.trace((Object)"Finished invoking WSI Validate method on WSDL");
            if (!validator.isValid()) {
                validationFailed = true;
            }
            if ((messages = info.getValidationMessages()) != null && messages.length > 0) {
                log.trace((Object)("Finished retrieving " + messages.length + " validation messages"));
                for (int i = 0; i < messages.length; ++i) {
                    IValidationMessage message = messages[i];
                    errorMesage.add(message.getMessage());
                }
                log.trace((Object)"Finished building error message list");
            }
        }
        catch (WSIException e) {
            String message = e.getMessage();
            return new String[]{"Exception occurred while building WS-I Validator" + (message != null ? ": " + message : "")};
        }
        catch (ValidateWSDLException e) {
            String message = e.getMessage();
            return new String[]{"Exception occurred while performing WS-I Validation" + (message != null ? ": " + message : "")};
        }
        catch (SAXException e) {
            String message = e.getMessage();
            return new String[]{"Exception occurred while parsing WSDL document" + (message != null ? ": " + message : "")};
        }
        catch (IOException e) {
            String message = e.getMessage();
            return new String[]{"Exception occurred while reading WSDL document from given location" + (message != null ? ": " + message : "")};
        }
        catch (ParserConfigurationException e) {
            String message = e.getMessage();
            return new String[]{"Exception occurred while building parser to parse thr WSDL" + (message != null ? ": " + message : "")};
        }
        catch (RuntimeException e) {
            String message = e.getMessage();
            return new String[]{"Exception occurred while validating WSDL document" + (message != null ? ": " + message : "")};
        }
        if (errorMesage.size() == 0 && validationFailed) {
            return new String[]{"WS-I Validation failed"};
        }
        return errorMesage.toArray(new String[errorMesage.size()]);
    }

    public static WSDLValidationInfo validateWSI(RequestContext requestContext) throws RegistryException {
        try {
            if (requestContext.getSourceURL() != null) {
                return WSDLUtils.validateWSI(requestContext.getSourceURL());
            }
            return null;
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage(), (Throwable)e);
        }
    }

    private static WSDLValidationInfo validateWSI(String uri) throws Exception {
        String[] message = WSDLUtils.validateForWSI(uri);
        WSDLValidationInfo wsdlValidationInfo = new WSDLValidationInfo();
        if (message.length > 0) {
            wsdlValidationInfo.setStatus(INVALID);
        } else {
            wsdlValidationInfo.setStatus(VALID);
        }
        for (int i = 0; i < message.length; ++i) {
            wsdlValidationInfo.addValidationMessage(message[i]);
        }
        return wsdlValidationInfo;
    }

    public static WSDLValidationInfo validateWSDL(RequestContext requestContext) throws RegistryException {
        try {
            if (requestContext.getSourceURL() != null) {
                return WSDLUtils.validaWSDLFromURI(requestContext.getSourceURL());
            }
            return null;
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDLValidationInfo[] validate(RequestContext requestContext, Definition wsdlDefinition) throws Exception {
        Resource resource = requestContext.getResource();
        Object resourceContent = resource.getContent();
        String sourceURL = requestContext.getSourceURL();
        InputStream inputStream = null;
        try {
            DocumentBuilder db;
            if (resourceContent instanceof byte[]) {
                inputStream = new ByteArrayInputStream((byte[])resourceContent);
            } else {
                if (sourceURL != null && sourceURL.toLowerCase().startsWith("file:")) {
                    String msg = "The source URL must not be file in the server's local file system";
                    throw new RegistryException(msg);
                }
                inputStream = new URL(sourceURL).openStream();
            }
            ResourceBundle rb = ResourceBundle.getBundle("validatewsdl");
            MessageGenerator messagegenerator = new MessageGenerator(rb);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (Exception e) {
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
            }
            Document doc = db.parse(inputStream);
            ValidationInfoImpl validateInfo = new ValidationInfoImpl(sourceURL, messagegenerator);
            URIResolver uriResolver = new URIResolver();
            validateInfo.setURIResolver(uriResolver);
            WSDL11ValidationInfoImpl info = new WSDL11ValidationInfoImpl((IValidationInfo)validateInfo);
            info.setElementLocations(new Hashtable());
            WSDL11BasicValidator validator = new WSDL11BasicValidator();
            WSDLUtils.registerExtensionValidators(validator.getClass().getClassLoader());
            ExtendedWSDL11ValidatorController wsdl11ValidatorController = new ExtendedWSDL11ValidatorController();
            WSDLDocument[] wsdlDocs = wsdl11ValidatorController.readWSDLDocument(doc, validateInfo.getFileURI(), messagegenerator, (IWSDL11ValidationInfo)info);
            WSDLDocument document = wsdlDocs[0];
            List schema = document.getSchemas();
            Iterator xsdIter = schema.iterator();
            while (xsdIter.hasNext()) {
                info.addSchema((XSModel)xsdIter.next());
            }
            info.setElementLocations(document.getElementLocations());
            validator.validate((Object)wsdlDefinition, new ArrayList(), (IWSDL11ValidationInfo)info);
            IValidationMessage[] messages = validateInfo.getValidationMessages();
            WSDLValidationInfo wsdlValidationInfo = new WSDLValidationInfo();
            if (messages.length > 0) {
                wsdlValidationInfo.setStatus(INVALID);
            } else {
                wsdlValidationInfo.setStatus(VALID);
            }
            for (IValidationMessage message : messages) {
                String messageString = "[" + message.getLine() + "][" + message.getColumn() + "]" + message.getMessage();
                wsdlValidationInfo.addValidationMessage(messageString);
            }
            if (WSITestToolsPlugin.getPlugin() == null) {
                WSITestToolsPlugin.getInstance();
                WSITestToolsProperties.setEclipseContext((boolean)false);
                BaseValidator[] validators = new BaseValidator[4];
                ProfileValidatorFactoryImpl factory = new ProfileValidatorFactoryImpl();
                validators[0] = factory.newWSDLValidator();
                validators[1] = factory.newUDDIValidator();
                validators[2] = factory.newEnvelopeValidator();
                validators[3] = factory.newMessageValidator();
                WSITestToolsPlugin.getPlugin().setBaseValidators(validators);
            }
            WSDLValidator wsiValidator = new WSDLValidator();
            ValidationInfoImpl validationInfo = new ValidationInfoImpl(sourceURL, messagegenerator);
            validationInfo.setURIResolver(uriResolver);
            WSDLValidationInfo wsiValidationInfo = new WSDLValidationInfo();
            wsiValidator.validate(doc, (IValidationInfo)validationInfo);
            messages = validationInfo.getValidationMessages();
            if (messages.length > 0) {
                wsiValidationInfo.setStatus(INVALID);
            } else {
                wsiValidationInfo.setStatus(VALID);
            }
            for (int i = 0; i < messages.length; ++i) {
                IValidationMessage message = messages[i];
                wsiValidationInfo.addValidationMessage(message.getMessage());
            }
            WSDLValidationInfo[] wSDLValidationInfoArray = new WSDLValidationInfo[]{wsdlValidationInfo, wsiValidationInfo};
            return wSDLValidationInfoArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static void registerExtensionValidators(ClassLoader classLoader) {
        ClassloaderWSDL11ValidatorDelegate delegate1 = new ClassloaderWSDL11ValidatorDelegate(WSDL11BasicValidator.class.getName(), classLoader);
        ValidatorRegistry.getInstance().registerValidator("http://schemas.xmlsoap.org/wsdl/", (WSDL11ValidatorDelegate)delegate1);
        delegate1 = new ClassloaderWSDL11ValidatorDelegate(HTTPValidator.class.getName(), classLoader);
        ValidatorRegistry.getInstance().registerValidator("http://schemas.xmlsoap.org/wsdl/http/", (WSDL11ValidatorDelegate)delegate1);
        delegate1 = new ClassloaderWSDL11ValidatorDelegate(SOAPValidator.class.getName(), classLoader);
        ValidatorRegistry.getInstance().registerValidator("http://schemas.xmlsoap.org/wsdl/soap/", (WSDL11ValidatorDelegate)delegate1);
        delegate1 = new ClassloaderWSDL11ValidatorDelegate(MIMEValidator.class.getName(), classLoader);
        ValidatorRegistry.getInstance().registerValidator("http://schemas.xmlsoap.org/wsdl/mime/", (WSDL11ValidatorDelegate)delegate1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WSDLValidationInfo validaWSDLFromURI(String uri) throws Exception {
        InputStream inputStream = null;
        try {
            DocumentBuilder db;
            inputStream = new URL(uri).openStream();
            ResourceBundle rb = ResourceBundle.getBundle("validatewsdl");
            MessageGenerator messagegenerator = new MessageGenerator(rb);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (Exception e) {
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
            }
            Document doc = db.parse(inputStream);
            ExWSDLReaderImpl reader = new ExWSDLReaderImpl((WSDLReaderImpl)WSDLFactory.newInstance().newWSDLReader());
            reader.setFeature("javax.wsdl.importDocuments", true);
            reader.setFeature("javax.wsdl.verbose", log.isDebugEnabled());
            Definition wsdlDefinition = reader.readWSDL(uri);
            ValidationInfoImpl validateInfo = new ValidationInfoImpl(uri, messagegenerator);
            URIResolver uriResolver = new URIResolver();
            validateInfo.setURIResolver(uriResolver);
            WSDL11ValidationInfoImpl info = new WSDL11ValidationInfoImpl((IValidationInfo)validateInfo);
            info.setElementLocations(new Hashtable());
            WSDL11BasicValidator validator = new WSDL11BasicValidator();
            WSDLUtils.registerExtensionValidators(validator.getClass().getClassLoader());
            ExtendedWSDL11ValidatorController wsdl11ValidatorController = new ExtendedWSDL11ValidatorController();
            WSDLDocument[] wsdlDocs = wsdl11ValidatorController.readWSDLDocument(doc, validateInfo.getFileURI(), messagegenerator, (IWSDL11ValidationInfo)info);
            WSDLDocument document = wsdlDocs[0];
            List schema = document.getSchemas();
            Iterator xsdIter = schema.iterator();
            while (xsdIter.hasNext()) {
                info.addSchema((XSModel)xsdIter.next());
            }
            info.setElementLocations(document.getElementLocations());
            validator.validate((Object)wsdlDefinition, new ArrayList(), (IWSDL11ValidationInfo)info);
            IValidationMessage[] messages = validateInfo.getValidationMessages();
            WSDLValidationInfo wsdlValidationInfo = new WSDLValidationInfo();
            if (messages.length > 0) {
                wsdlValidationInfo.setStatus(INVALID);
            } else {
                wsdlValidationInfo.setStatus(VALID);
            }
            for (IValidationMessage message : messages) {
                String messageString = "[" + message.getLine() + "][" + message.getColumn() + "]" + message.getMessage();
                wsdlValidationInfo.addValidationMessage(messageString);
            }
            WSDLValidationInfo wSDLValidationInfo = wsdlValidationInfo;
            return wSDLValidationInfo;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static class ExtendedWSDL11ValidatorController
    extends WSDL11ValidatorController {
        private ExtendedWSDL11ValidatorController() {
        }

        protected WSDLDocument[] readWSDLDocument(Document domModel, String file, MessageGenerator messagegenerator, IWSDL11ValidationInfo wsdlvalinfo) throws ValidateWSDLException {
            return super.readWSDLDocument(domModel, file, messagegenerator, wsdlvalinfo);
        }
    }
}

