/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import com.ibm.wsdl.extensions.schema.SchemaImportImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaInfo;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.InputSource;

public class SchemaProcessor {
    private Registry registry;
    private Registry systemRegistry;
    private List<String> processedSchemas;
    private List<String> visitedSchemas;
    private Map<String, SchemaInfo> schemas;
    private List<Association> associations;
    private String baseURI = null;
    private WSDLValidationInfo validationInfo;
    private static final String SCHEMA_VALIDATION_MESSAGE = "Schema Validation Message ";
    private static final String SCHEMA_STATUS = "Schema Validation";
    private boolean useOriginalSchema;
    private String resourceName = "";
    private static final Log log = LogFactory.getLog(SchemaProcessor.class);
    private int i;

    public SchemaProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo) {
        this.registry = requestContext.getRegistry();
        try {
            this.systemRegistry = CommonUtil.getUnchrootedSystemRegistry(requestContext);
        }
        catch (RegistryException ignore) {
            this.systemRegistry = null;
        }
        this.i = 0;
        this.schemas = new LinkedHashMap<String, SchemaInfo>();
        this.processedSchemas = new ArrayList<String>();
        this.visitedSchemas = new ArrayList<String>();
        this.associations = new ArrayList<Association>();
        this.validationInfo = validationInfo;
    }

    public SchemaProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo, boolean useOriginalSchema) {
        this(requestContext, validationInfo);
        this.useOriginalSchema = useOriginalSchema;
    }

    public String putSchemaToRegistry(RequestContext requestContext, String resourcePath, String commonLocation, boolean processIncludes) throws RegistryException {
        XmlSchema xmlSchema;
        boolean isDefaultEnvironment = true;
        String currentSchemaLocation = null;
        String currentEnvironment = null;
        String masterVersion = null;
        ArrayList<String> dependeinciesList = new ArrayList<String>();
        this.resourceName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
        XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])requestContext.getResource().getContent());
        InputSource inputSource = new InputSource(byteArrayInputStream);
        String url = "http://this.schema.needs/a/valid/source/url/to/proceed.xsd";
        if (requestContext.getSourceURL() != null) {
            url = requestContext.getSourceURL();
        }
        try {
            xmlSchemaCollection.setBaseUri(url);
            xmlSchema = xmlSchemaCollection.read(inputSource, null);
            xmlSchema.setSourceURI(url);
            this.evaluateSchemasRecursively(xmlSchema, null, false, true);
        }
        catch (RuntimeException re) {
            String msg = "Could not read the XML Schema Definition file. ";
            if (re.getCause() instanceof XmlSchemaException) {
                msg = msg + re.getCause().getMessage();
                log.error((Object)msg, (Throwable)re);
                throw new RegistryException(msg);
            }
            throw new RegistryException(msg, (Throwable)re);
        }
        String path = null;
        if (!resourcePath.equals("/" + this.resourceName) & !resourcePath.contains(commonLocation) & this.registry.resourceExists(resourcePath)) {
            Association[] associations;
            if (currentSchemaLocation == null) {
                currentEnvironment = resourcePath.substring(0, resourcePath.indexOf(CommonUtil.derivePathFragmentFromNamespace(xmlSchema.getTargetNamespace()).replace("//", "/")));
                currentSchemaLocation = currentEnvironment.substring("/_system/governance".length() + 1);
            }
            if (masterVersion == null) {
                String namespaceSegment = CommonUtil.derivePathFragmentFromNamespace(xmlSchema.getTargetNamespace()).replace("//", "/");
                String suffix = resourcePath.substring(resourcePath.indexOf(namespaceSegment) + namespaceSegment.length());
                masterVersion = suffix.substring(0, suffix.indexOf("/"));
            }
            isDefaultEnvironment = false;
            for (Association association : associations = this.registry.getAssociations(resourcePath, "depends")) {
                if (!association.getSourcePath().equals(resourcePath)) continue;
                dependeinciesList.add(association.getDestinationPath());
            }
            dependeinciesList.add(resourcePath);
            String symlinkLocation = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)requestContext.getResource().getProperty("SymlinkPropertyName"));
            Resource metaResource = requestContext.getResource();
            path = this.saveSchemasToRegistry(requestContext, currentEnvironment, symlinkLocation, metaResource, masterVersion, dependeinciesList);
            this.persistAssociations(path);
        } else {
            this.updateSchemaPaths(commonLocation);
            this.updateSchemaInternalsAndAssociations();
            String symlinkLocation = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)requestContext.getResource().getProperty("SymlinkPropertyName"));
            Resource metaResource = requestContext.getResource();
            path = this.saveSchemaToRegistry(requestContext, resourcePath, symlinkLocation, metaResource);
            this.persistAssociations(path);
        }
        return path;
    }

    public String importSchemaToRegistry(RequestContext requestContext, String resourcePath, String commonLocation, boolean processIncludes) throws RegistryException {
        this.resourceName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
        String url = requestContext.getSourceURL();
        XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
        xmlSchemaCollection.setBaseUri(url);
        this.baseURI = url;
        InputSource inputSource = new InputSource(url);
        try {
            XmlSchema xmlSchema = xmlSchemaCollection.read(inputSource, null);
            this.evaluateSchemasRecursively(xmlSchema, null, false, true);
        }
        catch (RuntimeException re) {
            String msg = "Could not read the XML Schema Definition file. ";
            if (re.getCause() instanceof XmlSchemaException) {
                msg = msg + re.getCause().getMessage();
                log.error((Object)msg, (Throwable)re);
                throw new RegistryException(msg);
            }
            throw new RegistryException(msg, (Throwable)re);
        }
        this.updateSchemaPaths(commonLocation);
        this.updateSchemaInternalsAndAssociations();
        String symlinkLocation = requestContext.getResource().getProperty("SymlinkPropertyName");
        Resource metaResource = requestContext.getResource();
        String path = this.saveSchemaToRegistry(requestContext, resourcePath, symlinkLocation, metaResource);
        this.persistAssociations(path);
        return path;
    }

    public void evaluateSchemas(Types types, String wsdlDocumentBaseURI, boolean evaluateImports, ArrayList<String> dependencies) throws RegistryException {
        this.baseURI = wsdlDocumentBaseURI;
        if (types != null) {
            List extensibleElements = types.getExtensibilityElements();
            wsdlDocumentBaseURI = wsdlDocumentBaseURI.substring(0, wsdlDocumentBaseURI.lastIndexOf("/") + 1);
            for (Object extensibleElement : extensibleElements) {
                SchemaImportImpl schemaImport;
                Object extensionObject = extensibleElement;
                if (!(extensionObject instanceof Schema)) continue;
                Schema schema = (Schema)extensionObject;
                if (schema.getImports().size() > 0 && (schemaImport = (SchemaImportImpl)((Vector)schema.getImports().values().toArray()[0]).firstElement()).getReferencedSchema() != null) {
                    CommonUtil.addImportedArtifact(new File(schemaImport.getReferencedSchema().getDocumentBaseURI()).toString());
                }
                XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
                xmlSchemaCollection.setBaseUri(wsdlDocumentBaseURI);
                XmlSchema xmlSchema = xmlSchemaCollection.read(schema.getElement());
                this.evaluateSchemasRecursively(xmlSchema, dependencies, true, false);
            }
        }
    }

    private void evaluateSchemasRecursively(XmlSchema xmlSchema, ArrayList<String> dependencies, boolean isWSDLInlineSchema, boolean isMasterSchema) throws RegistryException {
        XmlSchemaObjectCollection includes = xmlSchema.getIncludes();
        SchemaInfo schemaInfo = new SchemaInfo();
        schemaInfo.setMasterSchema(isMasterSchema);
        this.visitedSchemas.add(xmlSchema.getSourceURI());
        if (includes != null) {
            Iterator iter = includes.getIterator();
            while (iter.hasNext()) {
                XmlSchemaExternal xmlSchemaExternal;
                XmlSchema innerSchema;
                Object externalComponent = iter.next();
                if (!(externalComponent instanceof XmlSchemaExternal) || (innerSchema = (xmlSchemaExternal = (XmlSchemaExternal)externalComponent).getSchema()) == null) continue;
                String sourceURI = innerSchema.getSourceURI();
                if (isWSDLInlineSchema) {
                    dependencies.add(sourceURI);
                } else {
                    schemaInfo.getSchemaDependencies().add(sourceURI);
                }
                if (this.visitedSchemas.contains(sourceURI)) continue;
                this.evaluateSchemasRecursively(innerSchema, null, false, false);
            }
        }
        if (!isWSDLInlineSchema) {
            String sourceURI = xmlSchema.getSourceURI();
            String fileNameToSave = isMasterSchema ? this.extractResourceFromURL(this.resourceName, ".xsd") : this.extractResourceFromURL(sourceURI.substring(sourceURI.lastIndexOf("/") + 1), ".xsd");
            String originalName = fileNameToSave = fileNameToSave.replace("?xsd=", ".");
            while (this.processedSchemas.contains(fileNameToSave)) {
                fileNameToSave = fileNameToSave.substring(0, fileNameToSave.indexOf(".")) + ++this.i + ".xsd";
            }
            if (schemaInfo.isMasterSchema() && !originalName.equals(fileNameToSave)) {
                for (SchemaInfo schema : this.schemas.values()) {
                    if (!schema.getProposedResourceName().equals(originalName)) continue;
                    if (schema.isMasterSchema()) break;
                    schema.setProposedResourceName(fileNameToSave);
                    fileNameToSave = originalName;
                    break;
                }
            }
            this.processedSchemas.add(fileNameToSave);
            schemaInfo.setProposedResourceName(fileNameToSave);
            schemaInfo.setSchema(xmlSchema);
            schemaInfo.setOriginalURL(sourceURI);
            this.schemas.put(this.getAbsoluteSchemaURL(sourceURI), schemaInfo);
        }
    }

    public String getSchemaRegistryPath(String parentRegistryPath, String sourceURL) throws RegistryException {
        SchemaInfo schemaInfo = this.schemas.get(this.getAbsoluteSchemaURL(sourceURL));
        if (schemaInfo != null) {
            return WSDLUtil.computeRelativePathWithVersion(parentRegistryPath, schemaInfo.getProposedRegistryURL(), this.systemRegistry);
        }
        return null;
    }

    public String getSchemaAssociationPath(String sourceURL) {
        SchemaInfo schemaInfo = this.schemas.get(sourceURL);
        if (schemaInfo != null) {
            String proposedRegistryURL = schemaInfo.getProposedRegistryURL();
            return proposedRegistryURL.replaceAll("\\.\\./", "");
        }
        return null;
    }

    private void updateSchemaPaths(String commonSchemaLocation) throws RegistryException {
        if (!this.systemRegistry.resourceExists(commonSchemaLocation)) {
            this.systemRegistry.put(commonSchemaLocation, (Resource)this.systemRegistry.newCollection());
        }
        for (SchemaInfo schemaInfo : this.schemas.values()) {
            XmlSchema schema = schemaInfo.getSchema();
            String targetNamespace = schema.getTargetNamespace();
            if (targetNamespace == null || "".equals(targetNamespace)) {
                targetNamespace = "unqualified";
            }
            String schemaLocation = (commonSchemaLocation + CommonUtil.derivePathFragmentFromNamespace(targetNamespace)).replace("//", "/");
            schemaLocation = schemaLocation + schemaInfo.getProposedResourceName();
            schemaInfo.setProposedRegistryURL(schemaLocation);
        }
    }

    private void updateSchemaPaths(String commonSchemaLocation, String version, List dependencies) throws RegistryException {
        if (!this.systemRegistry.resourceExists(commonSchemaLocation)) {
            this.systemRegistry.put(commonSchemaLocation, (Resource)this.systemRegistry.newCollection());
        }
        block0: for (SchemaInfo schemaInfo : this.schemas.values()) {
            XmlSchema schema = schemaInfo.getSchema();
            String targetNamespace = schema.getTargetNamespace();
            if (targetNamespace == null || "".equals(targetNamespace)) {
                targetNamespace = "unqualified";
            }
            String schemaLocation = (commonSchemaLocation + CommonUtil.derivePathFragmentFromNamespace(targetNamespace)).replace("//", "/");
            String regex = schemaLocation + "[\\d].[\\d].[\\d]" + "/" + schemaInfo.getProposedResourceName();
            for (Object dependency : dependencies) {
                String path = dependency.toString();
                if (!path.matches(regex)) continue;
                schemaLocation = path;
                schemaInfo.setProposedRegistryURL(schemaLocation);
                continue block0;
            }
            schemaLocation = schemaLocation + version + "/" + schemaInfo.getProposedResourceName();
            schemaInfo.setProposedRegistryURL(schemaLocation);
        }
    }

    private void updateSchemaInternalsAndAssociations() throws RegistryException {
        for (SchemaInfo schemaInfo : this.schemas.values()) {
            XmlSchema schema = schemaInfo.getSchema();
            XmlSchemaObjectCollection includes = schema.getIncludes();
            if (includes != null) {
                Iterator iter = includes.getIterator();
                while (iter.hasNext()) {
                    String sourceURI;
                    XmlSchemaExternal xmlSchemaExternal;
                    XmlSchema schema1;
                    Object externalComponent = iter.next();
                    if (!(externalComponent instanceof XmlSchemaExternal) || (schema1 = (xmlSchemaExternal = (XmlSchemaExternal)externalComponent).getSchema()) == null || !this.schemas.containsKey(sourceURI = this.getAbsoluteSchemaURL(schema1.getSourceURI()))) continue;
                    SchemaInfo info = this.schemas.get(sourceURI);
                    String relativeSchemaPath = WSDLUtil.computeRelativePathWithVersion(schemaInfo.getProposedRegistryURL(), info.getProposedRegistryURL(), this.registry);
                    xmlSchemaExternal.setSchemaLocation(relativeSchemaPath);
                }
            }
            for (String associatedTo : schemaInfo.getSchemaDependencies()) {
                SchemaInfo schemaInfoAssociated = this.schemas.get(associatedTo);
                if (schemaInfoAssociated == null) continue;
                this.associations.add(new Association(schemaInfo.getProposedRegistryURL(), schemaInfoAssociated.getProposedRegistryURL(), "depends"));
                this.associations.add(new Association(schemaInfoAssociated.getProposedRegistryURL(), schemaInfo.getProposedRegistryURL(), "usedBy"));
            }
        }
    }

    public String saveSchemasToRegistry(RequestContext requestContext, String commonSchemaLocation, String symlinkLocation, Resource metaResource) throws RegistryException {
        this.updateSchemaPaths(commonSchemaLocation);
        this.updateSchemaInternalsAndAssociations();
        String path = this.saveSchemaToRegistry(requestContext, null, symlinkLocation, metaResource);
        this.persistAssociations(path);
        return path;
    }

    public String saveSchemasToRegistry(RequestContext requestContext, String commonSchemaLocation, String symlinkLocation, Resource metaResource, String version, List dependencies) throws RegistryException {
        this.updateSchemaPaths(commonSchemaLocation, version, dependencies);
        this.updateSchemaInternalsAndAssociations();
        String path = this.saveSchemaToRegistry(requestContext, null, symlinkLocation, metaResource);
        this.persistAssociations(path);
        return path;
    }

    private String saveSchemaToRegistry(RequestContext requestContext, String resourcePath, String symlinkLocation, Resource metaResource) throws RegistryException {
        String path = resourcePath;
        for (SchemaInfo schemaInfo : this.schemas.values()) {
            ResourceImpl xsdResource;
            XmlSchema schema = schemaInfo.getSchema();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            schema.write((OutputStream)byteArrayOutputStream);
            byte[] xsdContent = byteArrayOutputStream.toByteArray();
            String schemaPath = schemaInfo.getProposedRegistryURL();
            if (metaResource != null && this.registry.resourceExists(schemaPath)) {
                xsdResource = this.registry.get(schemaPath);
            } else {
                Properties properties;
                xsdResource = new ResourceImpl();
                if (metaResource != null && (properties = metaResource.getProperties()) != null) {
                    List<String> linkProperties = Arrays.asList("registry.link", "registry.user", "registry.mount", "registry.author", "registry.mountpoint", "registry.targetpoint", "registry.actualpath", "registry.realpath");
                    for (Map.Entry<Object, Object> e : properties.entrySet()) {
                        String key = (String)e.getKey();
                        if (linkProperties.contains(key)) continue;
                        xsdResource.setProperty(key, (List)e.getValue());
                    }
                }
            }
            xsdResource.setMediaType("application/x-xsd+xml");
            if (this.useOriginalSchema) {
                String errMsg;
                try {
                    xsdResource.setContent((Object)CarbonUtils.getBytesFromFile((File)new File(new URI(schemaInfo.getOriginalURL()))));
                }
                catch (CarbonException e) {
                    errMsg = "Trying to store original schema in registry failed while generating the content from original schema.";
                    log.error((Object)errMsg, (Throwable)e);
                    throw new RegistryException(errMsg, (Throwable)e);
                }
                catch (URISyntaxException e) {
                    errMsg = "Trying to store original schema in registry failed due to error occurred in file url:" + schemaInfo.getOriginalURL();
                    log.error((Object)errMsg, (Throwable)e);
                    throw new RegistryException(errMsg, (Throwable)e);
                }
            } else {
                xsdResource.setContent((Object)xsdContent);
            }
            if (metaResource != null) {
                xsdResource.setDescription(metaResource.getDescription());
            }
            String targetNamespace = schema.getTargetNamespace();
            xsdResource.setProperty("targetNamespace", targetNamespace);
            if (schemaInfo.isMasterSchema() && this.validationInfo != null) {
                ArrayList<String> messages = this.validationInfo.getValidationMessages();
                if (messages.size() > 0) {
                    xsdResource.setProperty(SCHEMA_STATUS, "Invalid");
                } else {
                    xsdResource.setProperty(SCHEMA_STATUS, "Valid");
                }
                int i = 1;
                for (String message : messages) {
                    if (message == null) continue;
                    if (message.length() > 1000) {
                        message = message.substring(0, 997) + "...";
                    }
                    xsdResource.setProperty(SCHEMA_VALIDATION_MESSAGE + i, message);
                    ++i;
                }
            }
            if (schemaInfo.isMasterSchema()) {
                xsdResource.setUUID(metaResource.getUUID());
                if (path != null && !schemaPath.equals(path) && this.registry.resourceExists(path)) {
                    Resource oldResource = this.registry.get(path);
                    if (oldResource.getProperty("registry.resource.symlink.path") != null) {
                        this.registry.delete(oldResource.getProperty("registry.resource.symlink.path"));
                    }
                    this.registry.delete(path);
                }
            }
            boolean newSchemaUpload = !this.registry.resourceExists(schemaPath);
            this.saveToRepositorySafely(requestContext, schemaInfo.getOriginalURL(), schemaPath, (Resource)xsdResource);
            if (!(symlinkLocation != null || resourcePath == null || resourcePath.equals("/") || resourcePath.equals(schemaPath) || resourcePath.equals(""))) {
                symlinkLocation = RegistryUtils.getParentPath((String)resourcePath);
            }
            if (schemaInfo.isMasterSchema() && symlinkLocation != null) {
                Resource resource;
                if (this.registry.resourceExists(symlinkLocation) && (resource = this.registry.get(symlinkLocation)) != null) {
                    String isLink = resource.getProperty("registry.link");
                    String mountPoint = resource.getProperty("registry.mountpoint");
                    String targetPoint = resource.getProperty("registry.targetpoint");
                    String actualPath = resource.getProperty("registry.actualpath");
                    if (isLink != null && mountPoint != null && targetPoint != null) {
                        symlinkLocation = actualPath + "/";
                    }
                }
                if (!symlinkLocation.endsWith("/")) {
                    symlinkLocation = symlinkLocation + "/";
                }
                String symlinkPath = symlinkLocation + this.extractResourceFromURL(this.resourceName, ".xsd");
                int j = 0;
                while (true) {
                    String actualPath;
                    if (!this.registry.resourceExists(symlinkPath)) {
                        if (CommonUtil.isSymbolicLinkMapExisting()) {
                            CommonUtil.addToSymbolicLinkMap(symlinkPath, schemaPath);
                            break;
                        }
                        this.systemRegistry.createLink(symlinkPath, schemaPath);
                        break;
                    }
                    if (!newSchemaUpload || this.registry.get(symlinkPath).getProperty("registry.link") != null && schemaPath.equals(actualPath = this.registry.get(symlinkPath).getProperty("registry.actualpath"))) break;
                    symlinkPath = "/" + this.extractResourceFromURL(this.resourceName, "-" + ++j + ".xsd");
                }
            }
            if (!schemaInfo.isMasterSchema()) continue;
            path = schemaPath;
        }
        return path;
    }

    private void persistAssociations(String schemaPath) throws RegistryException {
        for (Association association : this.associations) {
            boolean isAssociationExist = false;
            Association[] existingAssociations = this.registry.getAllAssociations(association.getSourcePath());
            if (existingAssociations != null) {
                for (Association currentAssociation : existingAssociations) {
                    if (!currentAssociation.getDestinationPath().equals(association.getDestinationPath()) || !currentAssociation.getAssociationType().equals(association.getAssociationType())) continue;
                    isAssociationExist = true;
                    break;
                }
            }
            if (isAssociationExist) continue;
            this.registry.addAssociation(association.getSourcePath(), association.getDestinationPath(), association.getAssociationType());
        }
        if (schemaPath != null && this.associations.isEmpty()) {
            Association[] dependencies;
            for (Association dependency : dependencies = this.registry.getAssociations(schemaPath, "depends")) {
                if (!dependency.getSourcePath().equals(schemaPath)) continue;
                this.registry.removeAssociation(dependency.getSourcePath(), dependency.getDestinationPath(), "depends");
                this.registry.removeAssociation(dependency.getDestinationPath(), dependency.getSourcePath(), "usedBy");
            }
        }
    }

    private void saveToRepositorySafely(RequestContext context, String url, String path, Resource resource) throws RegistryException {
        String schemaId = resource.getUUID();
        if (schemaId == null) {
            schemaId = UUID.randomUUID().toString();
            resource.setUUID(schemaId);
        }
        if (!this.registry.resourceExists(path)) {
            this.addSchemaToRegistry(context, path, url, resource, this.registry);
        } else {
            log.debug((Object)"A Resource already exists at given location. Overwriting resource content.");
            this.addSchemaToRegistry(context, path, url, resource, this.registry);
        }
        String relativeArtifactPath = RegistryUtils.getRelativePath((RegistryContext)this.registry.getRegistryContext(), (String)path);
        relativeArtifactPath = RegistryUtils.getRelativePathToOriginal((String)relativeArtifactPath, (String)"/_system/governance");
        ((ResourceImpl)resource).setPath(relativeArtifactPath);
    }

    protected void addSchemaToRegistry(RequestContext context, String path, String url, Resource resource, Registry registry) throws RegistryException {
        registry.put(path, resource);
    }

    private String extractResourceFromURL(String wsdlURL, String suffix) {
        String resourceName = wsdlURL;
        if (wsdlURL.indexOf("?") > 0) {
            resourceName = wsdlURL.substring(0, wsdlURL.indexOf("?")) + suffix;
        } else if (wsdlURL.indexOf(".") > 0) {
            resourceName = wsdlURL.substring(0, wsdlURL.lastIndexOf(".")) + suffix;
        } else if (!wsdlURL.endsWith(suffix)) {
            resourceName = wsdlURL + suffix;
        }
        return resourceName;
    }

    private String getAbsoluteSchemaURL(String schemaLocation) throws RegistryException {
        if (schemaLocation != null && this.baseURI != null) {
            try {
                URI uri = new URI(this.baseURI);
                URI absoluteURI = uri.resolve(schemaLocation);
                return absoluteURI.toString();
            }
            catch (URISyntaxException e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
        }
        return schemaLocation;
    }
}

