/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class EndpointUtils {
    private static final Log log = LogFactory.getLog(EndpointUtils.class);
    private static final String SOAP11_ENDPOINT_EXPR = "/wsdl:definitions/wsdl:service/wsdl:port/soap:address";
    private static final String SOAP12_ENDPOINT_EXPR = "/wsdl:definitions/wsdl:service/wsdl:port/soap12:address";
    private static final String HTTP_ENDPOINT_EXPR = "/wsdl:definitions/wsdl:service/wsdl:port/http:address";
    private static final String SERVICE_ENDPOINT_ENTRY_EXPR = "/s:serviceMetaData/s:endpoints/s:entry";
    private static final String SERVICE_ENDPOINT_EXPR = "/s:serviceMetaData/s:endpoints";
    private static final String SERVICE_ENDPOINTS_ELEMENT = "endpoints";
    private static final String SERVICE_ENDPOINTS_ENTRY_ELEMENT = "entry";
    private static final String LOCATION_ATTR = "location";
    private static final String ENDPOINT_DEFAULT_LOCATION = "/trunk/endpoints/";
    private static String endpointLocation = "/trunk/endpoints/";
    private static String endpointMediaType = "application/vnd.wso2.endpoint";
    private static String[] wsdlPrefixes = new String[]{"wsdl", "http://schemas.xmlsoap.org/wsdl/", "wsdl2", "http://www.w3.org/ns/wsdl", "xsd", "http://www.w3.org/2001/XMLSchema", "soap", "http://schemas.xmlsoap.org/wsdl/soap/", "soap12", "http://schemas.xmlsoap.org/wsdl/soap12/", "http", "http://schemas.xmlsoap.org/wsdl/http/", "s", "http://www.wso2.org/governance/metadata"};

    public static void setEndpointLocation(String endpointLocation) {
        EndpointUtils.endpointLocation = endpointLocation;
    }

    public static String getEndpointLocation() {
        return endpointLocation;
    }

    public static void setEndpointMediaType(String mediaType) {
        endpointMediaType = mediaType;
    }

    public static String getEndpointMediaType() {
        return endpointMediaType;
    }

    public static void saveEndpointsFromWSDL(String wsdlPath, Resource wsdlResource, Registry registry, Registry systemRegistry) throws RegistryException {
        List<OMElement> httpElements;
        List<OMElement> soap12Elements;
        List<OMElement> soap11Elements;
        OMElement wsdlElement;
        byte[] wsdlContentBytes = (byte[])wsdlResource.getContent();
        if (wsdlContentBytes == null) {
            return;
        }
        try {
            wsdlElement = EndpointUtils.buildOMElement(RegistryUtils.decodeBytes((byte[])wsdlContentBytes));
        }
        catch (Exception e) {
            String msg = "Error in building the wsdl element for path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        try {
            soap11Elements = EndpointUtils.evaluateXPathToElements(SOAP11_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement soap11Element : soap11Elements) {
            String locationUrl = soap11Element.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("soap11", "true");
            EndpointUtils.saveEndpoint(registry, locationUrl, wsdlPath, properties, systemRegistry);
        }
        try {
            soap12Elements = EndpointUtils.evaluateXPathToElements(SOAP12_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement soap12Element : soap12Elements) {
            String locationUrl = soap12Element.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("soap12", "true");
            EndpointUtils.saveEndpoint(registry, locationUrl, wsdlPath, properties, systemRegistry);
        }
        try {
            httpElements = EndpointUtils.evaluateXPathToElements(HTTP_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement httpElement : httpElements) {
            String locationUrl = httpElement.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("http", "true");
            EndpointUtils.saveEndpoint(registry, locationUrl, wsdlPath, properties, systemRegistry);
        }
    }

    public static void saveEndpointsFromWSDL(String wsdlPath, Resource wsdlResource, Registry registry, Registry systemRegistry, String environment, List<String> dependencies, String version) throws RegistryException {
        List<OMElement> httpElements;
        List<OMElement> soap12Elements;
        List<OMElement> soap11Elements;
        OMElement wsdlElement;
        byte[] wsdlContentBytes = (byte[])wsdlResource.getContent();
        if (wsdlContentBytes == null) {
            return;
        }
        try {
            wsdlElement = EndpointUtils.buildOMElement(RegistryUtils.decodeBytes((byte[])wsdlContentBytes));
        }
        catch (Exception e) {
            String msg = "Error in building the wsdl element for path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        try {
            soap11Elements = EndpointUtils.evaluateXPathToElements(SOAP11_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement soap11Element : soap11Elements) {
            String locationUrl = soap11Element.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("soap11", "true");
            EndpointUtils.saveEndpoint(registry, locationUrl, wsdlPath, properties, systemRegistry, environment, dependencies, version);
        }
        try {
            soap12Elements = EndpointUtils.evaluateXPathToElements(SOAP12_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement soap12Element : soap12Elements) {
            String locationUrl = soap12Element.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("soap12", "true");
            EndpointUtils.saveEndpoint(registry, locationUrl, wsdlPath, properties, systemRegistry, environment, dependencies, version);
        }
        try {
            httpElements = EndpointUtils.evaluateXPathToElements(HTTP_ENDPOINT_EXPR, wsdlElement);
        }
        catch (Exception e) {
            String msg = "Error in evaluating xpath expressions to extract endpoints, wsdl path: " + wsdlPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        for (OMElement httpElement : httpElements) {
            String locationUrl = httpElement.getAttributeValue(new QName(LOCATION_ATTR));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("http", "true");
            EndpointUtils.saveEndpoint(registry, locationUrl, wsdlPath, properties, systemRegistry, environment, dependencies, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveEndpointsFromServices(String servicePath, OMElement serviceElement, Registry registry, Registry systemRegistry) throws RegistryException {
        if (!CommonUtil.isAddingAssociationLockAvailable()) {
            return;
        }
        CommonUtil.acquireAddingAssociationLock();
        try {
            List<OMElement> serviceEndpointEntryElements;
            try {
                serviceEndpointEntryElements = EndpointUtils.evaluateXPathToElements(SERVICE_ENDPOINT_ENTRY_EXPR, serviceElement);
            }
            catch (Exception e) {
                String msg = "Error in evaluating xpath expressions to extract endpoints, service path: " + servicePath + ".";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
            EndpointUtils.removeEndpointDependencies(servicePath, registry);
            for (OMElement endpointElement : serviceEndpointEntryElements) {
                HashMap<String, String> properties = new HashMap<String, String>();
                String entryText = endpointElement.getText();
                String entryKey = null;
                int colonIndex = entryText.indexOf(":");
                if (colonIndex < entryText.length() - 1) {
                    entryKey = entryText.substring(0, colonIndex);
                    entryText = entryText.substring(colonIndex + 1);
                }
                String entryVal = entryText;
                if (!"".equals(entryKey)) {
                    String endpointPath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance" + endpointLocation)) + EndpointUtils.deriveEndpointFromUrl(entryVal);
                    String existingEnv = null;
                    if (registry.resourceExists(endpointPath)) {
                        registry.get(endpointPath).removeProperty("environment");
                    }
                    existingEnv = entryKey;
                    properties.put("environment", existingEnv);
                }
                EndpointUtils.saveEndpoint(registry, entryVal, servicePath, properties, systemRegistry);
            }
        }
        finally {
            CommonUtil.releaseAddingAssociationLock();
        }
        EndpointUtils.addAssociations(servicePath, registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveEndpointsFromServices(String servicePath, OMElement serviceElement, Registry registry, Registry systemRegistry, String environment) throws RegistryException {
        if (!CommonUtil.isAddingAssociationLockAvailable()) {
            return;
        }
        CommonUtil.acquireAddingAssociationLock();
        try {
            List<OMElement> serviceEndpointEntryElements;
            try {
                serviceEndpointEntryElements = EndpointUtils.evaluateXPathToElements(SERVICE_ENDPOINT_ENTRY_EXPR, serviceElement);
            }
            catch (Exception e) {
                String msg = "Error in evaluating xpath expressions to extract endpoints, service path: " + servicePath + ".";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
            EndpointUtils.removeEndpointDependencies(servicePath, registry);
            for (OMElement endpointElement : serviceEndpointEntryElements) {
                HashMap<String, String> properties = new HashMap<String, String>();
                String entryText = endpointElement.getText();
                String entryKey = null;
                int colonIndex = entryText.indexOf(":");
                if (colonIndex < entryText.length() - 1) {
                    entryKey = entryText.substring(0, colonIndex);
                    entryText = entryText.substring(colonIndex + 1);
                }
                String entryVal = entryText;
                if (!"".equals(entryKey)) {
                    String endpointPath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance" + environment)) + EndpointUtils.deriveEndpointFromUrl(entryVal);
                    String existingEnv = null;
                    if (registry.resourceExists(endpointPath)) {
                        registry.get(endpointPath).removeProperty("environment");
                    }
                    existingEnv = entryKey;
                    properties.put("environment", existingEnv);
                }
                EndpointUtils.saveEndpoint(registry, entryVal, servicePath, properties, systemRegistry, environment);
            }
        }
        finally {
            CommonUtil.releaseAddingAssociationLock();
        }
        EndpointUtils.addAssociations(servicePath, registry);
    }

    private static void addAssociations(String servicePath, Registry registry) throws RegistryException {
        Association[] associations;
        for (Association association : associations = registry.getAssociations(servicePath, "depends")) {
            Association[] wsdlAssociations;
            Resource targetResource;
            String targetPath = association.getDestinationPath();
            if (!registry.resourceExists(targetPath) || !"application/wsdl+xml".equals((targetResource = registry.get(targetPath)).getMediaType())) continue;
            for (Association wsdlAssociation : wsdlAssociations = registry.getAssociations(targetPath, "depends")) {
                Resource wsdlTargetResource;
                String wsdlTargetPath = wsdlAssociation.getDestinationPath();
                if (!registry.resourceExists(wsdlTargetPath) || !"application/vnd.wso2.endpoint".equals((wsdlTargetResource = registry.get(wsdlTargetPath)).getMediaType())) continue;
                registry.addAssociation(servicePath, wsdlTargetPath, "depends");
                registry.addAssociation(wsdlTargetPath, servicePath, "usedBy");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeEndpointDependencies(String servicePath, Registry registry) throws RegistryException {
        try {
            Association[] associations;
            CommonUtil.releaseAddingAssociationLock();
            if (!CommonUtil.isUpdateLockAvailable()) {
                return;
            }
            for (Association association : associations = registry.getAllAssociations(servicePath)) {
                Resource endpointResource;
                String path = association.getDestinationPath();
                if (!registry.resourceExists(path) || !"application/vnd.wso2.endpoint".equals((endpointResource = registry.get(path)).getMediaType())) continue;
                registry.removeAssociation(servicePath, path, "depends");
                registry.removeAssociation(path, servicePath, "usedBy");
            }
        }
        finally {
            CommonUtil.acquireUpdateLock();
        }
    }

    private static List<OMElement> evaluateXPathToElements(String expression, OMElement root) throws Exception {
        String[] nsPrefixes = wsdlPrefixes;
        AXIOMXPath xpathExpression = new AXIOMXPath(expression);
        for (int j = 0; j < nsPrefixes.length; ++j) {
            xpathExpression.addNamespace(nsPrefixes[j++], nsPrefixes[j]);
        }
        return xpathExpression.selectNodes((Object)root);
    }

    private static OMElement buildOMElement(String content) throws Exception {
        XMLStreamReader parser;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(content));
        }
        catch (XMLStreamException e) {
            String msg = "Error in initializing the parser to build the OMElement.";
            throw new Exception(msg, e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    private static void saveEndpoint(Registry registry, String url, String associatedPath, Map<String, String> properties, Registry systemRegistry, String environment) throws RegistryException {
        String urlToPath = EndpointUtils.deriveEndpointFromUrl(url);
        String endpointAbsoluteBasePath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance" + environment));
        if (!systemRegistry.resourceExists(endpointAbsoluteBasePath)) {
            systemRegistry.put(endpointAbsoluteBasePath, (Resource)systemRegistry.newCollection());
        }
        String relativePath = environment + urlToPath;
        String endpointAbsolutePath = endpointAbsoluteBasePath + urlToPath;
        EndpointUtils.saveEndpointValues(registry, url, associatedPath, properties, systemRegistry, relativePath, endpointAbsolutePath);
    }

    private static void saveEndpoint(Registry registry, String url, String associatedPath, Map<String, String> properties, Registry systemRegistry, String environment, List<String> dependencies, String version) throws RegistryException {
        String urlToPath = EndpointUtils.deriveEndpointFromUrl(url);
        String endpointAbsoluteBasePath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)environment);
        if (!systemRegistry.resourceExists(endpointAbsoluteBasePath)) {
            systemRegistry.put(endpointAbsoluteBasePath, (Resource)systemRegistry.newCollection());
        }
        String prefix = urlToPath.substring(0, urlToPath.lastIndexOf("/") + 1);
        String name = urlToPath.replace(prefix, "");
        String regex = endpointAbsoluteBasePath + prefix + "[\\d].[\\d].[\\d]" + "/" + name;
        for (String dependency : dependencies) {
            if (!dependency.matches(regex)) continue;
            String newRelativePath = RegistryUtils.getRelativePathToOriginal((String)dependency, (String)"/_system/governance");
            EndpointUtils.saveEndpointValues(registry, url, associatedPath, properties, systemRegistry, newRelativePath, dependency);
            return;
        }
        String endpointAbsolutePath = environment + prefix + version + "/" + name;
        String relativePath = environment.substring(0, "/_system/governance".length()) + prefix + version + "/" + name;
        EndpointUtils.saveEndpointValues(registry, url, associatedPath, properties, systemRegistry, relativePath, endpointAbsolutePath);
    }

    private static void saveEndpoint(Registry registry, String url, String associatedPath, Map<String, String> properties, Registry systemRegistry) throws RegistryException {
        String urlToPath = EndpointUtils.deriveEndpointFromUrl(url);
        String endpointAbsoluteBasePath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance" + endpointLocation));
        if (!systemRegistry.resourceExists(endpointAbsoluteBasePath)) {
            systemRegistry.put(endpointAbsoluteBasePath, (Resource)systemRegistry.newCollection());
        }
        if (endpointLocation.endsWith("/")) {
            if (urlToPath.startsWith("/")) {
                urlToPath = urlToPath.replaceFirst("/", "");
            }
        } else if (!urlToPath.startsWith("/")) {
            urlToPath = "/" + urlToPath;
        }
        String relativePath = endpointLocation + urlToPath;
        String endpointAbsolutePath = endpointAbsoluteBasePath + urlToPath;
        EndpointUtils.saveEndpointValues(registry, url, associatedPath, properties, systemRegistry, relativePath, endpointAbsolutePath);
    }

    private static void saveEndpointValues(Registry registry, String url, String associatedPath, Map<String, String> properties, Registry systemRegistry, String relativePath, String endpointAbsolutePath) throws RegistryException {
        Resource resource;
        String endpointId = null;
        if (registry.resourceExists(endpointAbsolutePath)) {
            resource = registry.get(endpointAbsolutePath);
            endpointId = resource.getUUID();
        } else {
            resource = registry.newResource();
            resource.setContent((Object)RegistryUtils.encodeString((String)url));
        }
        boolean endpointIdCreated = false;
        if (endpointId == null) {
            endpointIdCreated = true;
            endpointId = UUID.randomUUID().toString();
            resource.setUUID(endpointId);
        }
        boolean propertiesChanged = false;
        if (properties != null) {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                propertiesChanged = true;
                resource.setProperty(e.getKey(), e.getValue());
            }
        }
        if (endpointIdCreated || propertiesChanged) {
            resource.setMediaType(endpointMediaType);
            registry.put(endpointAbsolutePath, resource);
        }
        registry.addAssociation(associatedPath, endpointAbsolutePath, "depends");
        registry.addAssociation(endpointAbsolutePath, associatedPath, "usedBy");
    }

    public static void addEndpointToService(Registry registry, String servicePath, String endpointUrl, String endpointEnv) throws RegistryException {
        OMElement serviceEndpointElement;
        OMElement serviceElement;
        Resource serviceResource = registry.get(servicePath);
        byte[] serviceBytes = (byte[])serviceResource.getContent();
        String serviceContent = RegistryUtils.decodeBytes((byte[])serviceBytes);
        try {
            serviceElement = EndpointUtils.buildOMElement(serviceContent);
        }
        catch (Exception e) {
            String msg = "Failed building the service element. " + servicePath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        OMNamespace namespace = OMAbstractFactory.getOMFactory().createOMNamespace("http://www.wso2.org/governance/metadata", null);
        try {
            List<OMElement> endpointElements = EndpointUtils.evaluateXPathToElements(SERVICE_ENDPOINT_EXPR, serviceElement);
            if (endpointElements.size() == 0) {
                serviceEndpointElement = OMAbstractFactory.getOMFactory().createOMElement(SERVICE_ENDPOINTS_ELEMENT, namespace);
                serviceElement.addChild((OMNode)serviceEndpointElement);
            } else {
                serviceEndpointElement = endpointElements.get(0);
            }
        }
        catch (Exception e) {
            String msg = "Error in getting the endpoint element of the service. service path: " + servicePath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        Iterator it = serviceEndpointElement.getChildElements();
        ArrayList<String> currentEndpoints = new ArrayList<String>();
        while (it.hasNext()) {
            currentEndpoints.add(((OMElement)it.next()).getText());
        }
        if (!currentEndpoints.contains(endpointEnv + ":" + endpointUrl)) {
            OMElement entryElement = OMAbstractFactory.getOMFactory().createOMElement(SERVICE_ENDPOINTS_ENTRY_ELEMENT, namespace);
            entryElement.setText(endpointEnv + ":" + endpointUrl);
            serviceEndpointElement.addChild((OMNode)entryElement);
            String serviceElementStr = serviceElement.toString();
            serviceResource.setContent((Object)RegistryUtils.encodeString((String)serviceElementStr));
            registry.put(servicePath, serviceResource);
        }
    }

    public static void removeEndpointFromService(Registry registry, String servicePath, String endpointUrl, String endpointEnv) throws RegistryException {
        OMElement serviceEndpointElement;
        OMElement serviceElement;
        Resource serviceResource = registry.get(servicePath);
        byte[] serviceBytes = (byte[])serviceResource.getContent();
        String serviceContent = RegistryUtils.decodeBytes((byte[])serviceBytes);
        try {
            serviceElement = EndpointUtils.buildOMElement(serviceContent);
        }
        catch (Exception e) {
            String msg = "Failed building the service element. " + servicePath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        OMNamespace namespace = OMAbstractFactory.getOMFactory().createOMNamespace("http://www.wso2.org/governance/metadata", null);
        try {
            List<OMElement> endpointElements = EndpointUtils.evaluateXPathToElements(SERVICE_ENDPOINT_EXPR, serviceElement);
            if (endpointElements.size() == 0) {
                serviceEndpointElement = OMAbstractFactory.getOMFactory().createOMElement(SERVICE_ENDPOINTS_ELEMENT, namespace);
                serviceElement.addChild((OMNode)serviceEndpointElement);
            } else {
                serviceEndpointElement = endpointElements.get(0);
            }
        }
        catch (Exception e) {
            String msg = "Error in getting the endpoint element of the service. service path: " + servicePath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        Iterator it = serviceEndpointElement.getChildElements();
        while (it.hasNext()) {
            OMElement next = (OMElement)it.next();
            if (!next.getText().equals(endpointEnv + ":" + endpointUrl)) continue;
            next.detach();
            String serviceElementStr = serviceElement.toString();
            serviceResource.setContent((Object)RegistryUtils.encodeString((String)serviceElementStr));
            registry.put(servicePath, serviceResource);
            break;
        }
    }

    public static void removeObsoleteWsdlEndpoint(OMElement oldServiceInfoElement, OMElement serviceInfoElement, String servicePath, Registry registry) throws RegistryException {
        String oldWsdlPath = CommonUtil.getWSDLURL(oldServiceInfoElement);
        String wsdlPath = CommonUtil.getWSDLURL(serviceInfoElement);
        if (oldWsdlPath != null && !wsdlPath.endsWith(oldWsdlPath)) {
            List endpointsNodes;
            Association[] associations = registry.getAssociations(servicePath, "depends");
            AXIOMXPath endpointsXPath = null;
            try {
                endpointsXPath = new AXIOMXPath("//ns:endpoints/ns:entry");
                endpointsXPath.addNamespace("ns", "http://www.wso2.org/governance/metadata");
                endpointsNodes = endpointsXPath.selectNodes((Object)serviceInfoElement);
            }
            catch (JaxenException e) {
                throw new RegistryException(e.getMessage());
            }
            for (Association association : associations) {
                if (!association.getDestinationPath().contains("/endpoints/")) continue;
                String endpoint = association.getDestinationPath();
                for (OMElement endpointEntry : endpointsNodes) {
                    if (!endpoint.equals(EndpointUtils.getEndpointPathFromUrl(endpointEntry.getText(), registry))) continue;
                    endpointEntry.detach();
                }
            }
            endpointsNodes.size();
        }
    }

    private static String getEndpointPathFromUrl(String endpointUrl, Registry registry) {
        int colonIndex = endpointUrl.indexOf(":");
        if (colonIndex < endpointUrl.length() - 1) {
            endpointUrl = endpointUrl.substring(colonIndex + 1);
        }
        return RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance" + endpointLocation)) + EndpointUtils.deriveEndpointFromUrl(endpointUrl);
    }

    public static String deriveEndpointFromUrl(String url) {
        String ENDPOINT_RESOURCE_PREFIX = "ep-";
        String tempURL = url;
        if (tempURL.startsWith("jms:/")) {
            tempURL = tempURL.split("[?]")[0];
        }
        String name = tempURL.split("/")[tempURL.split("/").length - 1].replace(".", "-").replace("=", "-").replace("@", "-").replace("#", "-").replace("~", "-");
        String[] temp = url.split("[?]")[0].split("/");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < temp.length - 1; ++i) {
            sb.append(temp[i]).append("/");
        }
        String urlToPath = CommonUtil.derivePathFragmentFromNamespace(sb.toString());
        urlToPath = urlToPath.substring(1, urlToPath.length() - 1);
        urlToPath = urlToPath + "/ep-" + name;
        return urlToPath;
    }
}

