/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class SmartLifecycleLinkHandler
extends Handler {
    private Map<String, String> states = new HashMap<String, String>();
    private String resourceKey = "service";

    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public void setStates(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName("state"))) continue;
            this.states.put(confElement.getAttributeValue(new QName("key")), confElement.getText());
        }
    }

    public boolean resourceExists(RequestContext requestContext) throws RegistryException {
        try {
            this.get(requestContext);
        }
        catch (RegistryException e) {
            return false;
        }
        return true;
    }

    public void put(RequestContext requestContext) throws RegistryException {
        requestContext.setProcessingComplete(true);
    }

    public void importResource(RequestContext requestContext) throws RegistryException {
        requestContext.setProcessingComplete(true);
    }

    public void createLink(RequestContext requestContext) throws RegistryException {
        requestContext.setProcessingComplete(true);
    }

    public void removeLink(RequestContext requestContext) throws RegistryException {
        requestContext.setProcessingComplete(true);
    }

    public void delete(RequestContext requestContext) throws RegistryException {
        requestContext.setProcessingComplete(true);
    }

    public void dump(RequestContext requestContext) throws RegistryException {
        requestContext.setProcessingComplete(true);
    }

    public void restore(RequestContext requestContext) throws RegistryException {
        requestContext.setProcessingComplete(true);
    }

    public String move(RequestContext requestContext) throws RegistryException {
        requestContext.setProcessingComplete(true);
        return requestContext.getTargetPath();
    }

    public String copy(RequestContext requestContext) throws RegistryException {
        requestContext.setProcessingComplete(true);
        return requestContext.getTargetPath();
    }

    public String rename(RequestContext requestContext) throws RegistryException {
        requestContext.setProcessingComplete(true);
        return requestContext.getTargetPath();
    }

    public Resource get(RequestContext requestContext) throws RegistryException {
        String path = requestContext.getResourcePath().getPath();
        String stateKey = RegistryUtils.getResourceName((String)path);
        if (!this.states.containsKey(stateKey)) {
            throw new ResourceNotFoundException("The given key, " + stateKey + " does not " + "correspond to a lifecycle state.");
        }
        String servicePath = RegistryUtils.getParentPath((String)path);
        Registry registry = requestContext.getRegistry();
        block6: for (String majorVersion : this.getSortedChildrenList(servicePath, registry)) {
            try {
                Integer.parseInt(RegistryUtils.getResourceName((String)majorVersion));
                block7: for (String minorVersion : this.getSortedChildrenList(majorVersion, registry)) {
                    try {
                        Integer.parseInt(RegistryUtils.getResourceName((String)minorVersion));
                        block8: for (String patchVersion : this.getSortedChildrenList(minorVersion, registry)) {
                            try {
                                Integer.parseInt(RegistryUtils.getResourceName((String)patchVersion));
                                String serviceResourcePath = patchVersion + "/" + this.resourceKey;
                                Resource resource = registry.get(serviceResourcePath);
                                for (Object propKey : resource.getProperties().keySet()) {
                                    if (!((String)propKey).matches("^registry[.]lifecycle.*[.]state$")) continue;
                                    if (!this.states.get(stateKey).equals(resource.getProperty((String)propKey))) continue block8;
                                    resource.setProperty("registry.link", "true");
                                    resource.setProperty("registry.mountpoint", path);
                                    resource.setProperty("registry.targetpoint", serviceResourcePath);
                                    resource.setProperty("registry.author", resource.getAuthorUserName());
                                    resource.setProperty("registry.actualpath", serviceResourcePath);
                                    requestContext.setProcessingComplete(true);
                                    return resource;
                                }
                            }
                            catch (NumberFormatException ignored) {
                                continue block7;
                            }
                        }
                    }
                    catch (NumberFormatException ignored) {
                        continue block6;
                    }
                }
            }
            catch (NumberFormatException ignored) {
                break;
            }
        }
        throw new ResourceNotFoundException("No Resources found to be in the given lifecycle state: " + stateKey);
    }

    private List<String> getSortedChildrenList(String servicePath, Registry registry) throws RegistryException {
        List<String> paths = Arrays.asList(((Collection)registry.get(servicePath)).getChildren());
        Collections.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int n2;
                int n1;
                try {
                    n1 = Integer.parseInt(RegistryUtils.getResourceName((String)o1));
                }
                catch (NumberFormatException ignored) {
                    return 1;
                }
                try {
                    n2 = Integer.parseInt(RegistryUtils.getResourceName((String)o2));
                }
                catch (NumberFormatException ignored) {
                    return -1;
                }
                return n1 < n2 ? 1 : (n1 > n2 ? -1 : 0);
            }
        });
        return paths;
    }
}

