/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ProcessMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(ProcessMediaTypeHandler.class);
    private List<String> smartLifecycleLinks = new LinkedList<String>();

    public void setSmartLifecycleLinks(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName("key"))) continue;
            this.smartLifecycleLinks.add(confElement.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            OMElement processInfoElement;
            Registry registry = requestContext.getRegistry();
            Resource resource = requestContext.getResource();
            if (resource == null) {
                throw new RegistryException("The resource is not available.");
            }
            String originalProcessPath = requestContext.getResourcePath().getPath();
            String resourceName = RegistryUtils.getResourceName((String)originalProcessPath);
            Object resourceContent = resource.getContent();
            String processInfo = resourceContent instanceof String ? (String)resourceContent : RegistryUtils.decodeBytes((byte[])((byte[])resourceContent));
            try {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(processInfo));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                processInfoElement = builder.getDocumentElement();
            }
            catch (Exception e) {
                String msg = "Error in parsing the process content of the process. The requested path to store the process: " + originalProcessPath + ".";
                log.error((Object)msg);
                throw new RegistryException(msg, (Throwable)e);
            }
            String processName = CommonUtil.getServiceName(processInfoElement);
            String processNamespace = CommonUtil.getServiceNamespace(processInfoElement);
            String processPath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance/processes" + (processNamespace == null ? "" : CommonUtil.derivePathFragmentFromNamespace(processNamespace)) + processName));
            String processVersion = org.wso2.carbon.registry.common.utils.CommonUtil.getServiceVersion((OMElement)processInfoElement);
            if (processVersion.length() == 0) {
                processVersion = "1.0.0";
                CommonUtil.setServiceVersion(processInfoElement, processVersion);
                resource.setContent((Object)processInfoElement.toString());
            }
            String processVersionPath = CommonUtil.computeProcessPathWithVersion(processPath, processVersion);
            String processId = resource.getUUID();
            if (processId == null) {
                processId = UUID.randomUUID().toString();
                resource.setUUID(processId);
            }
            if (registry.resourceExists(processVersionPath)) {
                Resource oldResource = registry.get(processVersionPath);
                String oldContent = RegistryUtils.decodeBytes((byte[])((byte[])oldResource.getContent()));
                Object oldProcessInfoElement = null;
                if (processInfo.equals(oldContent)) {
                    return;
                }
            }
            boolean alreadyAdded = false;
            String workflowURL = CommonUtil.getWorkflowURL(processInfoElement);
            if (workflowURL != null && workflowURL.startsWith("/")) {
                String workflowPath = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)workflowURL);
                boolean addItHere = false;
                if (!registry.resourceExists(workflowPath)) {
                    String msg = "Associating process to a non-existing workflow. workflow url: " + workflowPath + ", " + "process path: " + processVersionPath + ".";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                if (!registry.resourceExists(processVersionPath)) {
                    addItHere = true;
                } else {
                    Association[] dependencies = registry.getAssociations(processVersionPath, "depends");
                    boolean dependencyFound = false;
                    if (dependencies != null) {
                        for (Association dependency : dependencies) {
                            if (!workflowPath.equals(dependency.getDestinationPath())) continue;
                            dependencyFound = true;
                        }
                    }
                    if (!dependencyFound) {
                        addItHere = true;
                    }
                }
                if (addItHere) {
                    ((ResourceImpl)resource).prepareContentForPut();
                    this.persistProcessResource(registry, resource, processVersionPath);
                    alreadyAdded = true;
                    registry.addAssociation(processVersionPath, workflowPath, "depends");
                    registry.addAssociation(workflowPath, processVersionPath, "usedBy");
                }
            }
            if (!alreadyAdded) {
                ((ResourceImpl)resource).prepareContentForPut();
                this.persistProcessResource(registry, resource, processVersionPath);
            }
            String symlinkLocation = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)requestContext.getResource().getProperty("SymlinkPropertyName"));
            if (!processPath.equals(originalProcessPath)) {
                Resource processResource = requestContext.getRegistry().get(RegistryUtils.getParentPath((String)originalProcessPath));
                String isLink = processResource.getProperty("registry.link");
                String mountPoint = processResource.getProperty("registry.mountpoint");
                String targetPoint = processResource.getProperty("registry.targetpoint");
                String actualPath = processResource.getProperty("registry.actualpath");
                if (isLink != null && mountPoint != null && targetPoint != null) {
                    symlinkLocation = actualPath + "/";
                }
                if (symlinkLocation != null) {
                    registry.createLink(symlinkLocation + resourceName, processPath);
                }
            }
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    private void persistProcessResource(Registry registry, Resource resource, String processVersionPath) throws RegistryException {
        String patchVersionPath = RegistryUtils.getParentPath((String)processVersionPath);
        if (!registry.resourceExists(patchVersionPath)) {
            String minorVersionPath = RegistryUtils.getParentPath((String)patchVersionPath);
            if (!registry.resourceExists(minorVersionPath)) {
                String majorVersionPath = RegistryUtils.getParentPath((String)minorVersionPath);
                if (!registry.resourceExists(majorVersionPath)) {
                    Collection collection;
                    String versionCollectionPath = RegistryUtils.getParentPath((String)majorVersionPath);
                    if (!registry.resourceExists(versionCollectionPath)) {
                        collection = registry.newCollection();
                        collection.setMediaType("application/vnd.wso2-process-version.collection");
                        registry.put(versionCollectionPath, (Resource)collection);
                        for (String key : this.smartLifecycleLinks) {
                            Resource linkResource = registry.newResource();
                            linkResource.setMediaType("application/vnd.wso2-smart-link");
                            registry.put(versionCollectionPath + "/" + key, linkResource);
                        }
                    }
                    collection = registry.newCollection();
                    collection.setMediaType("application/vnd.wso2-process-version.major");
                    registry.put(majorVersionPath, (Resource)collection);
                }
                Collection collection = registry.newCollection();
                collection.setMediaType("application/vnd.wso2-process-version.minor");
                registry.put(minorVersionPath, (Resource)collection);
            }
            Collection collection = registry.newCollection();
            collection.setMediaType("application/vnd.wso2-process-version.patch");
            registry.put(patchVersionPath, (Resource)collection);
        }
        registry.put(processVersionPath, resource);
    }
}

