/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class Axis2RepositoryHandler
extends Handler {
    private static final Log log = LogFactory.getLog(Axis2RepositoryHandler.class);

    public void put(RequestContext requestContext) throws RegistryException {
        String path = requestContext.getResourcePath().getPath();
        String confPath = path + "/" + "conf";
        CollectionImpl confCollection = new CollectionImpl();
        confCollection.setPath(confPath);
        confCollection.setMediaType("axis2-conf");
        requestContext.getRegistry().put(confPath, (Resource)confCollection);
        String servicesPath = path + "/" + "services";
        CollectionImpl servicesCollection = new CollectionImpl();
        servicesCollection.setPath(servicesPath);
        servicesCollection.setMediaType("axis2-services");
        requestContext.getRegistry().put(servicesPath, (Resource)servicesCollection);
        String modulesPath = path + "/" + "modules";
        CollectionImpl modulesCollection = new CollectionImpl();
        modulesCollection.setPath(modulesPath);
        modulesCollection.setMediaType("axis2-modules");
        requestContext.getRegistry().put(modulesPath, (Resource)modulesCollection);
    }

    public void putChild(RequestContext requestContext) throws RegistryException {
        String childMediaType;
        Resource childResource = requestContext.getResource();
        if (childResource == null) {
            childResource = requestContext.getRegistry().get(requestContext.getResourcePath().getPath());
            requestContext.setResource(childResource);
        }
        if (!("axis2-conf".equals(childMediaType = requestContext.getResource().getMediaType()) || "axis2-services".equals(childMediaType) || "axis2-modules".equals(childMediaType))) {
            String msg = "Resources of type: " + childMediaType + " are not allowed to add as child resources of " + "the typed collection Axis2 Repository.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
    }
}

