/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.ui;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.registry.extensions.ui.clients.ResourceServiceClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class AddExtensionProcessor
extends AbstractFileUploadExecutor {
    private static final Log log = LogFactory.getLog(AddExtensionProcessor.class);

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        Map formFieldsMap = this.getFormFieldsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed. Content is not set properly.";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request);
            response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/admin/error.jsp");
            return false;
        }
        String errorRedirect = null;
        try {
            FileItemData fileItemData;
            ResourceServiceClient client = new ResourceServiceClient(cookie, serverURL, this.configurationContext);
            String redirect = null;
            if (formFieldsMap.get("redirect") != null) {
                redirect = (String)((ArrayList)formFieldsMap.get("redirect")).get(0);
            }
            if (formFieldsMap.get("errorRedirect") != null) {
                errorRedirect = (String)((ArrayList)formFieldsMap.get("errorRedirect")).get(0);
            }
            if ((fileItemData = (FileItemData)((ArrayList)fileItemsMap.get("upload")).get(0)) == null || fileItemData.getFileItem().getSize() == 0L) {
                String msg = "Failed add resource. Resource content is empty.";
                log.error((Object)msg);
                this.buildUIError(request, response, webContext, errorRedirect, msg);
                return false;
            }
            client.addExtension((String)((ArrayList)formFieldsMap.get("filename")).get(0), fileItemData.getDataHandler());
            response.setContentType("text/html; charset=utf-8");
            String msg = "Successfully uploaded extension.";
            if (redirect == null) {
                CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request);
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/admin/index.jsp");
            } else {
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/" + redirect);
            }
            return true;
        }
        catch (IOException e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)"File upload failed. ", (Throwable)e);
            if (errorRedirect == null) {
                CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request);
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/admin/error.jsp");
            } else {
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/" + errorRedirect + (errorRedirect.indexOf("?") == -1 ? "?" : "&") + "msg=" + URLEncoder.encode(msg, "UTF-8"));
            }
            return false;
        }
        catch (RuntimeException e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)"File upload failed. ", (Throwable)e);
            this.buildUIError(request, response, webContext, errorRedirect, msg);
            return false;
        }
        catch (Exception e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)"File upload failed. ", (Throwable)e);
            this.buildUIError(request, response, webContext, errorRedirect, msg);
            return false;
        }
    }

    private void buildUIError(HttpServletRequest request, HttpServletResponse response, String webContext, String errorRedirect, String msg) throws IOException {
        CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request);
        if (errorRedirect == null) {
            response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/admin/error.jsp");
        } else {
            response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/" + errorRedirect + (errorRedirect.indexOf("?") == -1 ? "?" : "&") + "msg=" + URLEncoder.encode(msg, "UTF-8"));
        }
    }
}

