/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.validators;

import java.util.Map;
import org.wso2.carbon.governance.registry.extensions.interfaces.CustomValidations;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class PropertyValueValidator
implements CustomValidations {
    private String propertyName = null;
    private String propertyValue = null;
    private boolean isMultiValued = false;

    @Override
    public void init(Map parameterMap) {
        if (parameterMap != null) {
            this.propertyName = (String)parameterMap.get("propertyName");
            this.propertyValue = (String)parameterMap.get("propertyValue");
            this.isMultiValued = Boolean.toString(true).equals(parameterMap.get("isMultiValued"));
        }
    }

    @Override
    public boolean validate(RequestContext context) {
        Resource resource = context.getResource();
        return this.validatePropertyOfResource(resource);
    }

    protected boolean validatePropertyOfResource(Resource resource) {
        if (this.propertyName != null && this.propertyValue != null) {
            if (!this.isMultiValued) {
                return this.propertyValue.equals(resource.getProperty(this.propertyName));
            }
            for (String value : resource.getPropertyValues(this.propertyName)) {
                if (!this.propertyValue.equals(value)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

