/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.validators;

import java.util.Collections;
import java.util.Map;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.registry.extensions.interfaces.CustomValidations;
import org.wso2.carbon.governance.registry.extensions.validators.AttributeExistenceValidator;

public class AttributeValueValidator
extends AttributeExistenceValidator
implements CustomValidations {
    private String pattern = null;
    private boolean atLeastOne = false;

    @Override
    public void init(Map parameterMap) {
        if (parameterMap != null) {
            this.pattern = (String)parameterMap.get("pattern");
            this.atLeastOne = Boolean.toString(true).equals(parameterMap.get("atLeastOne"));
            super.init(Collections.singletonMap("attributes", (String)parameterMap.get("attribute")));
        }
    }

    @Override
    protected boolean validateAttribute(GovernanceArtifact governanceArtifact, String attribute) throws GovernanceException {
        boolean output = true;
        if (this.pattern != null) {
            String[] values = governanceArtifact.getAttributes(attribute);
            if (values != null) {
                for (String value : values) {
                    if (value.matches(this.pattern)) {
                        if (!this.atLeastOne) continue;
                        return true;
                    }
                    output = false;
                }
            } else {
                output = false;
            }
        }
        return output;
    }
}

