/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.registry.extensions.executors.ServiceVersionExecutor;
import org.wso2.carbon.governance.registry.extensions.executors.utils.Utils;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class CopyExecutor
implements Execution {
    private static final Log log = LogFactory.getLog(ServiceVersionExecutor.class);
    private static final String KEY = "{@version}";
    private Map parameterMap;
    private boolean copyComments = false;
    private boolean copyTags = false;
    private boolean copyRatings = false;
    private boolean copyAllAssociations = false;

    @Override
    public void init(Map map) {
        this.parameterMap = map;
        if (this.parameterMap.get("copyComments") != null) {
            this.copyComments = Boolean.parseBoolean((String)this.parameterMap.get("copyComments"));
        }
        if (this.parameterMap.get("copyTags") != null) {
            this.copyTags = Boolean.parseBoolean((String)this.parameterMap.get("copyTags"));
        }
        if (this.parameterMap.get("copyRatings") != null) {
            this.copyRatings = Boolean.parseBoolean((String)this.parameterMap.get("copyRatings"));
        }
        if (this.parameterMap.get("copyAssociations") != null) {
            this.copyAllAssociations = Boolean.parseBoolean((String)this.parameterMap.get("copyAssociations"));
        }
    }

    @Override
    public boolean execute(RequestContext requestContext, String currentState, String targetState) {
        String resourcePath = requestContext.getResource().getPath();
        HashMap<String, String> currentParameterMap = new HashMap<String, String>();
        if (!Utils.populateParameterMap(requestContext, currentParameterMap)) {
            log.error((Object)"Failed to populate the parameter map");
            return false;
        }
        String currentEnvironment = this.getReformattedPath((String)this.parameterMap.get("currentEnvironment"), KEY, (String)currentParameterMap.get(resourcePath));
        String targetEnvironment = this.getReformattedPath((String)this.parameterMap.get("targetEnvironment"), KEY, (String)currentParameterMap.get(resourcePath));
        if (!resourcePath.startsWith(currentEnvironment)) {
            log.warn((Object)"Resource is not in the given environment");
            return true;
        }
        String newPath = resourcePath.substring(currentEnvironment.length());
        newPath = targetEnvironment + newPath;
        try {
            requestContext.getRegistry().copy(resourcePath, newPath);
            Resource newResource = requestContext.getRegistry().get(newPath);
            if (newResource.getUUID() != null) {
                Utils.addNewId(requestContext.getRegistry(), newResource, newPath);
            }
            requestContext.setResource(newResource);
            requestContext.setResourcePath(new ResourcePath(newPath));
            this.copyComments(requestContext.getRegistry(), newPath, resourcePath);
            this.copyTags(requestContext.getRegistry(), newPath, resourcePath);
            this.copyRatings(requestContext.getSystemRegistry(), newPath, resourcePath);
            this.copyAllAssociations(requestContext.getRegistry(), newPath, resourcePath);
            return true;
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getReformattedPath(String originalPath, String key, String value) {
        if (key == null || value == null) {
            return originalPath;
        }
        return originalPath.replace(key, value);
    }

    private void copyAllAssociations(Registry registry, String newPath, String path) throws RegistryException {
        if (this.copyAllAssociations) {
            Utils.copyAssociations(registry, newPath, path);
        }
    }

    private void copyRatings(Registry registry, String newPath, String path) throws RegistryException {
        if (this.copyRatings) {
            Utils.copyRatings(registry, newPath, path);
        }
    }

    private void copyTags(Registry registry, String newPath, String path) throws RegistryException {
        if (this.copyTags) {
            Utils.copyTags(registry, newPath, path);
        }
    }

    private void copyComments(Registry registry, String newPath, String path) throws RegistryException {
        if (this.copyComments) {
            Utils.copyComments(registry, newPath, path);
        }
    }
}

