/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class ConflictResolutionReader
extends Reader {
    private static final Log log = LogFactory.getLog(ConflictResolutionReader.class);
    private static final String XPATH_EXPRESSION = "//lastModified";
    private Reader reader;
    private StringBuffer buffer;
    private String path;
    private Registry registry;

    public ConflictResolutionReader(Reader reader, String path, Registry registry) {
        this.reader = reader;
        this.path = path;
        this.registry = registry;
        this.buffer = new StringBuffer();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int retValue = this.reader.read(cbuf, off, len);
        if (retValue != -1) {
            this.buffer.append(cbuf);
        } else {
            this.checkForConflicts();
        }
        return retValue;
    }

    @Override
    public int read() throws IOException {
        int ret = this.reader.read();
        if (ret != -1) {
            this.buffer.append((char)ret);
        } else {
            this.checkForConflicts();
        }
        return ret;
    }

    private void checkForConflicts() throws IOException {
        try {
            OMElement restoreElement = AXIOMUtil.stringToOM((String)this.buffer.toString());
            restoreElement.build();
            AXIOMXPath xpathQuery = new AXIOMXPath(XPATH_EXPRESSION);
            List lastModifiedTimes = xpathQuery.selectNodes((Object)restoreElement);
            Collections.sort(lastModifiedTimes, new Comparator<OMElement>(){

                @Override
                public int compare(OMElement o1, OMElement o2) {
                    long o2Value;
                    long o1Value = Long.parseLong(o1.getText());
                    if (o1Value < (o2Value = Long.parseLong(o2.getText()))) {
                        return 1;
                    }
                    if (o1Value > o2Value) {
                        return -1;
                    }
                    return 0;
                }
            });
            long maxTimeValue = this.getMaxTimeElement(lastModifiedTimes);
            LogEntry[] logs = this.registry.getLogs(null, -1, null, new Date(maxTimeValue), null, true);
            Arrays.sort(logs, new Comparator<LogEntry>(){

                @Override
                public int compare(LogEntry o1, LogEntry o2) {
                    return o2.getResourcePath().compareTo(o1.getResourcePath());
                }
            });
            for (LogEntry logEntry : logs) {
                if (!logEntry.getResourcePath().startsWith(this.path)) continue;
                String msg = "Another user has modified the content of the resource " + this.path;
                log.error((Object)msg);
                throw new IOException(msg);
            }
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error reading the restore file", (Throwable)e);
        }
        catch (JaxenException e) {
            log.error((Object)"Failed to initialize the Xpath", (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to get logs from registry", (Throwable)e);
        }
    }

    private long getMaxTimeElement(List lastUpdateTimes) {
        for (Object lastUpdateTime : lastUpdateTimes) {
            OMElement maxTimeElement = (OMElement)lastUpdateTime;
            OMContainer parentElement = maxTimeElement.getParent();
            OMElement versionChild = parentElement.getFirstChildWithName(new QName("version"));
            if (versionChild == null || Integer.parseInt(versionChild.getText()) <= 0) continue;
            return Long.parseLong(maxTimeElement.getText());
        }
        return Long.MIN_VALUE;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
    }
}

