/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.scm;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class FilesystemManager {
    private File baseDir;

    public FilesystemManager(String basePath) {
        this.baseDir = new File(basePath);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public byte[] getFileContent(String path) throws RegistryException {
        File file = new File(this.baseDir, path);
        try {
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new RegistryException("Unable to read file at path: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public String[] getDirectoryContent(String path) throws RegistryException {
        File directory = new File(this.baseDir, path);
        if (!directory.exists() || !directory.isDirectory()) {
            throw new RegistryException("A directory does not exist at path: " + directory.getAbsolutePath());
        }
        return directory.list((FilenameFilter)new AndFileFilter(HiddenFileFilter.VISIBLE, (IOFileFilter)new OrFileFilter(DirectoryFileFilter.INSTANCE, FileFileFilter.FILE)));
    }

    public void createOrUpdateFile(String path, byte[] content) throws RegistryException {
        File file = new File(this.baseDir, path);
        try {
            this.createDirectory(file.getParentFile().getAbsolutePath().substring(this.baseDir.getAbsolutePath().length()));
            FileUtils.writeByteArrayToFile((File)file, (byte[])content);
        }
        catch (IOException e) {
            throw new RegistryException("Unable to write content to file at path: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public void createDirectory(String path) throws RegistryException {
        File directory = new File(this.baseDir, path);
        if (directory.exists()) {
            return;
        }
        try {
            FileUtils.forceMkdir((File)directory);
        }
        catch (IOException e) {
            throw new RegistryException("Unable to create directory at path: " + directory.getAbsolutePath(), (Throwable)e);
        }
    }

    public void delete(String path) throws RegistryException {
        File file = new File(this.baseDir, path);
        if (!file.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new RegistryException("Unable to delete file at path: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public void copy(String source, String destination) throws RegistryException {
        File sourceFile = new File(this.baseDir, source);
        File destinationFile = new File(this.baseDir, destination);
        try {
            FileUtils.copyFile((File)sourceFile, (File)destinationFile);
        }
        catch (IOException e) {
            throw new RegistryException("Unable to copy file at path: " + sourceFile.getAbsolutePath() + " to path: " + destinationFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

