/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.beans.BusinessServiceInfo;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaProcessor;
import org.wso2.carbon.registry.extensions.handlers.utils.UDDIPublisher;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLInfo;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLProcessor;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;

public class WSDLMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(WSDLMediaTypeHandler.class);
    private String locationTag = "location";
    private String wsdlLocation = "/wsdls/";
    private OMElement wsdlLocationConfiguration;
    protected String schemaLocation = "/schema/";
    private OMElement schemaLocationConfiguration;
    protected String policyLocation = "/policy/";
    private OMElement policyLocationConfiguration;
    private boolean createService = true;
    private boolean disableWSDLValidation = false;

    public boolean getCreateService() {
        return this.createService;
    }

    public void setCreateService(String createService) {
        this.createService = Boolean.valueOf(createService);
    }

    public OMElement getWsdlLocationConfiguration() {
        return this.wsdlLocationConfiguration;
    }

    public void setWsdlLocationConfiguration(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName(this.locationTag))) continue;
            this.wsdlLocation = confElement.getText();
            if (!this.wsdlLocation.startsWith("/")) {
                this.wsdlLocation = "/" + this.wsdlLocation;
            }
            if (this.wsdlLocation.endsWith("/")) continue;
            this.wsdlLocation = this.wsdlLocation + "/";
        }
        WSDLProcessor.setCommonWSDLLocation(this.wsdlLocation);
        AuthorizationUtils.addAuthorizeRoleListener((int)102, (String)WSDLProcessor.getChrootedWSDLLocation(RegistryContext.getBaseInstance()), (String)"/permission/admin/manage/resources/govern/metadata/add", (String)"ui.execute");
        AuthorizationUtils.addAuthorizeRoleListener((int)112, (String)WSDLProcessor.getChrootedWSDLLocation(RegistryContext.getBaseInstance()), (String)"/permission/admin/manage/resources/govern/metadata/list", (String)"ui.execute", (String[])new String[]{"http://www.wso2.org/projects/registry/actions/get"});
        this.wsdlLocationConfiguration = locationConfiguration;
    }

    public OMElement getSchemaLocationConfiguration() {
        return this.schemaLocationConfiguration;
    }

    public void setSchemaLocationConfiguration(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName(this.locationTag))) continue;
            this.schemaLocation = confElement.getText();
            if (!this.schemaLocation.startsWith("/")) {
                this.schemaLocation = "/" + this.schemaLocation;
            }
            if (this.schemaLocation.endsWith("/")) continue;
            this.schemaLocation = this.schemaLocation + "/";
        }
        WSDLProcessor.setCommonSchemaLocation(this.schemaLocation);
        this.schemaLocationConfiguration = locationConfiguration;
    }

    public OMElement getPolicyLocationConfiguration() {
        return this.policyLocationConfiguration;
    }

    public void setPolicyLocationConfiguration(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName(this.locationTag))) continue;
            this.policyLocation = confElement.getText();
            if (!this.policyLocation.startsWith("/")) {
                this.policyLocation = "/" + this.policyLocation;
            }
            if (this.policyLocation.endsWith("/")) continue;
            this.policyLocation = this.policyLocation + "/";
        }
        WSDLProcessor.setCommonPolicyLocation(this.policyLocation);
        this.policyLocationConfiguration = locationConfiguration;
    }

    public void makeDir(File file) throws IOException {
        if (file != null && !file.exists() && !file.mkdir()) {
            log.warn((Object)("Failed to create directory at path: " + file.getAbsolutePath()));
        }
    }

    public void makeDirs(File file) throws IOException {
        if (file != null && !file.exists() && !file.mkdirs()) {
            log.warn((Object)("Failed to create directories at path: " + file.getAbsolutePath()));
        }
    }

    public void delete(File file) throws IOException {
        if (file != null && file.exists() && !file.delete()) {
            log.warn((Object)("Failed to delete file/directory at path: " + file.getAbsolutePath()));
        }
    }

    protected void onPutCompleted(String path, Map<String, String> addedResources, List<String> otherResources, RequestContext requestContext) throws RegistryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        WSDLProcessor wsdlProcessor = null;
        try {
            String path;
            Resource metadata;
            block49: {
                metadata = requestContext.getResource();
                path = requestContext.getResourcePath().getPath();
                try {
                    if (metadata != null) break block49;
                    return;
                }
                catch (IOException e) {
                    String msg = "Error in updating the wsdl. wsdl path: " + path + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new RegistryException(msg, (Throwable)e);
                }
            }
            Registry registry = requestContext.getRegistry();
            String remotePut = metadata.getProperty("registry.remotemount.operation");
            if (remotePut != null) {
                metadata.removeProperty("registry.remotemount.operation");
                registry.put(path, metadata);
                requestContext.setProcessingComplete(true);
                return;
            }
            if (registry.resourceExists(path)) {
                Object newContent = metadata.getContent();
                Resource oldResource = registry.get(path);
                if ("true".equals(oldResource.getProperty("registry.link"))) {
                    path = oldResource.getProperty("registry.actualpath");
                }
                Object oldContent = oldResource.getContent();
                String newContentString = null;
                String oldContentString = null;
                if (newContent != null) {
                    newContentString = newContent instanceof String ? (String)newContent : RegistryUtils.decodeBytes((byte[])((byte[])newContent));
                }
                if (oldContent != null) {
                    oldContentString = oldContent instanceof String ? (String)oldContent : RegistryUtils.decodeBytes((byte[])((byte[])oldContent));
                }
                if (newContent == null && oldContent == null || newContentString != null && newContentString.equals(oldContentString)) {
                    return;
                }
                LinkedHashSet<String> registryPaths = new LinkedHashSet<String>();
                registryPaths.add(path);
                Association[] dependencies = CommonUtil.getDependenciesRecursively(registry, path);
                if (dependencies != null) {
                    for (Association dependency : dependencies) {
                        String targetPath = dependency.getDestinationPath();
                        if (!targetPath.startsWith("/")) continue;
                        registryPaths.add(targetPath);
                    }
                }
                File referenceTempFile = File.createTempFile("wsdl", ".ref");
                File tempDir = new File(referenceTempFile.getAbsolutePath().substring(0, referenceTempFile.getAbsolutePath().length() - ".ref".length()));
                String tempDirPath = tempDir.getAbsolutePath();
                ArrayList<File> tempFiles = new ArrayList<File>();
                for (String registryPath : registryPaths) {
                    int byteCount;
                    byte[] resourceContentBytes;
                    Object resourceContent;
                    if (!registryPath.startsWith("/")) continue;
                    String filePath = tempDirPath + registryPath;
                    File tempFile = new File(filePath);
                    this.makeDirs(tempFile.getParentFile());
                    if (registryPath.equals(path)) {
                        resourceContent = metadata.getContent();
                    } else {
                        Resource r;
                        if (!registry.resourceExists(registryPath) || (r = registry.get(registryPath)) == null) continue;
                        resourceContent = r.getContent();
                    }
                    if (resourceContent == null) {
                        resourceContentBytes = new byte[]{};
                    } else if (resourceContent instanceof byte[]) {
                        resourceContentBytes = (byte[])resourceContent;
                    } else if (resourceContent instanceof String) {
                        resourceContentBytes = RegistryUtils.encodeString((String)((String)resourceContent));
                    } else {
                        String msg = "Unknown type for the content path: " + path + ", content type: " + resourceContent.getClass().getName() + ".";
                        log.error((Object)msg);
                        throw new RegistryException(msg);
                    }
                    ByteArrayInputStream in = new ByteArrayInputStream(resourceContentBytes);
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
                    byte[] contentChunk = new byte[1024];
                    while ((byteCount = in.read(contentChunk)) != -1) {
                        out.write(contentChunk, 0, byteCount);
                    }
                    out.flush();
                    out.close();
                    tempFiles.add(tempFile);
                }
                if (tempFiles.size() == 0) {
                    String msg = "Temporary files count is zero, when updating a wsdl. wsdl path: " + path + ".";
                    log.error((Object)msg);
                    return;
                }
                File tempFile = (File)tempFiles.get(0);
                String uri = tempFile.toURI().toString();
                if (uri.startsWith("file:")) {
                    uri = uri.substring(5);
                }
                while (uri.startsWith("/")) {
                    uri = uri.substring(1);
                }
                uri = "file:///" + uri;
                String wsdlPath = null;
                if (uri != null) {
                    requestContext.setSourceURL(uri);
                    requestContext.setResource(metadata);
                    wsdlProcessor = this.buildWSDLProcessor(requestContext);
                    wsdlPath = this.processWSDLImport(requestContext, wsdlProcessor, metadata, uri);
                }
                for (File temp : tempFiles) {
                    FileUtils.forceDelete((File)temp);
                }
                FileUtils.deleteDirectory((File)tempDir);
                FileUtils.forceDelete((File)referenceTempFile);
                if (wsdlPath != null) {
                    this.onPutCompleted(path, Collections.singletonMap(uri, wsdlPath), Collections.<String>emptyList(), requestContext);
                    requestContext.setActualPath(wsdlPath);
                }
                requestContext.setProcessingComplete(true);
                return;
            }
            try {
                int byteCount;
                byte[] resourceContentBytes;
                Object resourceContent = metadata.getContent();
                if (resourceContent == null) {
                    resourceContentBytes = new byte[]{};
                } else if (resourceContent instanceof byte[]) {
                    resourceContentBytes = (byte[])resourceContent;
                } else if (resourceContent instanceof String) {
                    resourceContentBytes = RegistryUtils.encodeString((String)((String)resourceContent));
                } else {
                    String msg = "Unknown type for the content path: " + path + ", content type: " + resourceContent.getClass().getName() + ".";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(resourceContentBytes);
                File tempFile = File.createTempFile("wsdl", ".wsdl");
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
                byte[] contentChunk = new byte[1024];
                while ((byteCount = in.read(contentChunk)) != -1) {
                    out.write(contentChunk, 0, byteCount);
                }
                out.flush();
                out.close();
                String uri = tempFile.toURI().toString();
                if (uri.startsWith("file:")) {
                    uri = uri.substring(5);
                }
                while (uri.startsWith("/")) {
                    uri = uri.substring(1);
                }
                uri = "file:///" + uri;
                String wsdlPath = null;
                if (uri != null) {
                    requestContext.setSourceURL(uri);
                    requestContext.setResource(metadata);
                    wsdlProcessor = this.buildWSDLProcessor(requestContext);
                    wsdlPath = this.processWSDLImport(requestContext, wsdlProcessor, metadata, uri);
                }
                this.delete(tempFile);
                if (wsdlPath != null) {
                    this.onPutCompleted(path, Collections.singletonMap(uri, wsdlPath), Collections.<String>emptyList(), requestContext);
                    requestContext.setActualPath(wsdlPath);
                }
            }
            catch (IOException e) {
                throw new RegistryException("An error occurred while uploading WSDL file", (Throwable)e);
            }
            requestContext.setProcessingComplete(true);
            if (wsdlProcessor != null && "enable".equals(System.getProperty("uddi"))) {
                BusinessServiceInfo businessServiceInfo = new BusinessServiceInfo();
                WSDLInfo wsdlInfo = wsdlProcessor.getMasterWSDLInfo();
                businessServiceInfo.setServiceWSDLInfo(wsdlInfo);
                UDDIPublisher publisher = new UDDIPublisher(businessServiceInfo);
                publisher.publishBusinessService();
            }
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    protected WSDLProcessor buildWSDLProcessor(RequestContext requestContext) {
        WSDLProcessor wsdlProcessor = new WSDLProcessor(requestContext);
        wsdlProcessor.setCreateService(this.getCreateService());
        return wsdlProcessor;
    }

    protected WSDLProcessor buildWSDLProcessor(RequestContext requestContext, boolean useOriginalSchema) {
        WSDLProcessor wsdlProcessor = new WSDLProcessor(requestContext, useOriginalSchema);
        wsdlProcessor.setCreateService(this.getCreateService());
        return wsdlProcessor;
    }

    protected SchemaProcessor buildSchemaProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo) {
        return new SchemaProcessor(requestContext, validationInfo);
    }

    protected SchemaProcessor buildSchemaProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo, boolean useOriginalSchema) {
        return new SchemaProcessor(requestContext, validationInfo, useOriginalSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importResource(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        WSDLProcessor wsdlProcessor = null;
        try {
            Resource metadata = requestContext.getResource();
            String sourceURL = requestContext.getSourceURL();
            if (requestContext.getSourceURL() != null && requestContext.getSourceURL().toLowerCase().startsWith("file:")) {
                String msg = "The source URL must not be file in the server's local file system";
                throw new RegistryException(msg);
            }
            try {
                wsdlProcessor = this.buildWSDLProcessor(requestContext);
                String wsdlPath = this.processWSDLImport(requestContext, wsdlProcessor, metadata, sourceURL);
                ResourcePath resourcePath = requestContext.getResourcePath();
                String path = null;
                if (resourcePath != null) {
                    path = resourcePath.getPath();
                }
                this.onPutCompleted(path, Collections.singletonMap(sourceURL, wsdlPath), Collections.<String>emptyList(), requestContext);
                requestContext.setActualPath(wsdlPath);
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            requestContext.setProcessingComplete(true);
            if (wsdlProcessor != null && "enable".equals(System.getProperty("uddi"))) {
                BusinessServiceInfo businessServiceInfo = new BusinessServiceInfo();
                businessServiceInfo.setServiceWSDLInfo(wsdlProcessor.getMasterWSDLInfo());
                UDDIPublisher publisher = new UDDIPublisher(businessServiceInfo);
                publisher.publishBusinessService();
            }
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    protected String processWSDLImport(RequestContext requestContext, WSDLProcessor wsdlProcessor, Resource metadata, String sourceURL) throws RegistryException {
        return wsdlProcessor.addWSDLToRegistry(requestContext, sourceURL, metadata, false, true, this.disableWSDLValidation);
    }

    public void setDisableWSDLValidation(String disableWSDLValidation) {
        this.disableWSDLValidation = Boolean.toString(true).equals(disableWSDLValidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            Registry registry = requestContext.getRegistry();
            ResourcePath resourcePath = requestContext.getResourcePath();
            if (resourcePath == null) {
                throw new RegistryException("The resource path is not available.");
            }
            Resource resource = registry.get(resourcePath.getPath());
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }
}

