/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.util.Date;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;

public class RetentionHandler
extends Handler {
    public void put(RequestContext requestContext) throws RegistryException {
        this.checkWriteLock(requestContext.getResourcePath().getPath(), requestContext);
    }

    public void addAssociation(RequestContext requestContext) throws RegistryException {
    }

    public void removeAssociation(RequestContext requestContext) throws RegistryException {
    }

    public void restore(RequestContext requestContext) throws RegistryException {
        this.checkWriteLock(requestContext.getResourcePath().getPath(), requestContext);
    }

    public void restoreVersion(RequestContext requestContext) throws RegistryException {
        this.checkWriteLock(new ResourcePath(requestContext.getVersionPath()).getPath(), requestContext);
    }

    public void delete(RequestContext requestContext) throws RegistryException {
        this.checkDeleteLock(requestContext.getResourcePath().getPath(), requestContext);
    }

    public void importResource(RequestContext requestContext) throws RegistryException {
        this.checkWriteLock(requestContext.getResourcePath().getPath(), requestContext);
    }

    public String rename(RequestContext requestContext) throws RegistryException {
        return this.move(requestContext);
    }

    public String move(RequestContext requestContext) throws RegistryException {
        this.checkDeleteLock(requestContext.getSourcePath(), requestContext);
        this.checkWriteLock(requestContext.getTargetPath(), requestContext);
        return requestContext.getTargetPath();
    }

    public String copy(RequestContext requestContext) throws RegistryException {
        this.checkWriteLock(requestContext.getTargetPath(), requestContext);
        return requestContext.getTargetPath();
    }

    private void checkWriteLock(String path, RequestContext requestContext) throws RegistryException {
        String owner = this.checkRetentionLock(requestContext.getRegistry(), path, "registry.retention.writeLocked");
        if (owner != null) {
            requestContext.setProcessingComplete(true);
            throw new RegistryException("Resource Retention does not allow this operation. Resource at path " + path + " is write locked by " + owner);
        }
    }

    private void checkDeleteLock(String path, RequestContext requestContext) throws RegistryException {
        String owner = this.checkRetentionLock(requestContext.getRegistry(), path, "registry.retention.deleteLocked");
        if (owner != null) {
            requestContext.setProcessingComplete(true);
            throw new RegistryException("Resource Retention does not allow this operation. Resource at path: " + path + " is delete locked by " + owner);
        }
    }

    private String checkRetentionLock(Registry registry, String path, String retentionProperty) throws RegistryException {
        if (!registry.resourceExists(path)) {
            return null;
        }
        Resource existingResource = registry.get(path);
        if (CurrentSession.getUser() != null && !CurrentSession.getUser().equals(existingResource.getProperty("registry.retention.user.name")) && Boolean.parseBoolean(existingResource.getProperty(retentionProperty))) {
            Date fromDate = CommonUtil.computeDate((String)existingResource.getProperty("registry.retention.fromDate"));
            Date toDate = CommonUtil.computeDate((String)existingResource.getProperty("registry.retention.toDate"));
            Date now = new Date();
            if (now.compareTo(fromDate) > 0 && now.compareTo(toDate) < 0) {
                return existingResource.getProperty("registry.retention.user.name");
            }
        }
        return null;
    }
}

