/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class EndpointMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(EndpointMediaTypeHandler.class);
    private static final String LOCATION_TAG = "location";
    OMElement endpointLocationElement;

    public void setEndpointLocationConfiguration(OMElement endpointLocationElement) throws RegistryException {
        String endpointLocation = null;
        Iterator configElements = endpointLocationElement.getChildElements();
        while (configElements.hasNext()) {
            OMElement configElement = (OMElement)configElements.next();
            if (!configElement.getQName().equals(new QName(LOCATION_TAG))) continue;
            endpointLocation = configElement.getText();
            if (!endpointLocation.startsWith("/")) {
                endpointLocation = "/" + endpointLocation;
            }
            if (endpointLocation.endsWith("/")) continue;
            endpointLocation = endpointLocation + "/";
        }
        EndpointUtils.setEndpointLocation(endpointLocation);
        String absoluteEndpointLocation = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)("/_system/governance" + endpointLocation));
        AuthorizationUtils.addAuthorizeRoleListener((int)104, (String)absoluteEndpointLocation, (String)"/permission/admin/manage/resources/govern/metadata/add", (String)"ui.execute");
        AuthorizationUtils.addAuthorizeRoleListener((int)114, (String)absoluteEndpointLocation, (String)"/permission/admin/manage/resources/govern/metadata/list", (String)"ui.execute", (String[])new String[]{"http://www.wso2.org/projects/registry/actions/get"});
        this.endpointLocationElement = endpointLocationElement;
    }

    public OMElement getEndpointLocationConfiguration() {
        return this.endpointLocationElement;
    }

    public void setEndpointMediaType(String endpointMediaType) throws RegistryException {
        EndpointUtils.setEndpointMediaType(endpointMediaType);
    }

    public String getEndpointMediaType() throws RegistryException {
        return EndpointUtils.getEndpointMediaType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            String resourceContent;
            Registry registry = requestContext.getRegistry();
            Resource resource = requestContext.getResource();
            Object resourceContentObj = resource.getContent();
            if (resourceContentObj instanceof String) {
                resourceContent = (String)resourceContentObj;
                resource.setContent((Object)RegistryUtils.encodeString((String)resourceContent));
            } else {
                resourceContent = RegistryUtils.decodeBytes((byte[])((byte[])resourceContentObj));
            }
            String urlToPath = EndpointUtils.deriveEndpointFromUrl(resourceContent);
            String basePath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance" + EndpointUtils.getEndpointLocation()));
            String path = basePath + urlToPath;
            String endpointId = resource.getUUID();
            if (registry.resourceExists(path)) {
                Resource oldResource = registry.get(path);
                byte[] oldContent = (byte[])oldResource.getContent();
                if (oldContent != null && !RegistryUtils.decodeBytes((byte[])oldContent).equals(resourceContent)) {
                    resource.setContent((Object)RegistryUtils.encodeString((String)resourceContent));
                }
            } else if (endpointId == null) {
                endpointId = UUID.randomUUID().toString();
                resource.setUUID(endpointId);
            }
            String relativeArtifactPath = RegistryUtils.getRelativePath((RegistryContext)registry.getRegistryContext(), (String)path);
            relativeArtifactPath = RegistryUtils.getRelativePathToOriginal((String)relativeArtifactPath, (String)"/_system/governance");
            Registry systemRegistry = CommonUtil.getUnchrootedSystemRegistry(requestContext);
            if (!systemRegistry.resourceExists(basePath)) {
                systemRegistry.put(basePath, (Resource)systemRegistry.newCollection());
            }
            registry.put(path, resource);
            ((ResourceImpl)resource).setPath(relativeArtifactPath);
            requestContext.setActualPath(path);
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    public String rename(RequestContext requestContext) throws RegistryException {
        return this.move(requestContext);
    }

    public String move(RequestContext requestContext) throws RegistryException {
        Registry registry = requestContext.getRegistry();
        String sourcePath = requestContext.getSourcePath();
        this.checkEndpointDependency(registry, sourcePath);
        return requestContext.getTargetPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isDeleteLockAvailable()) {
            return;
        }
        CommonUtil.acquireDeleteLock();
        Registry registry = requestContext.getRegistry();
        String path = requestContext.getResourcePath().getPath();
        try {
            if (path == null) {
                throw new RegistryException("The resource path is not available.");
            }
            this.checkEndpointDependency(registry, path);
            Resource resource = registry.get(path);
        }
        finally {
            CommonUtil.releaseDeleteLock();
        }
    }

    public void checkEndpointDependency(Registry registry, String path) throws RegistryException {
        Association[] endpointDependents = registry.getAssociations(path, "usedBy");
        ArrayList<String> dependents = new ArrayList<String>();
        for (Association endpointDependent : endpointDependents) {
            String targetPath = endpointDependent.getDestinationPath();
            if (!registry.resourceExists(targetPath)) continue;
            Resource targetResource = registry.get(targetPath);
            String mediaType = targetResource.getMediaType();
            if ("application/wsdl+xml".equals(mediaType)) {
                dependents.add(targetPath);
                continue;
            }
            if (!"application/vnd.wso2-service+xml".equals(mediaType)) continue;
            dependents.add(targetPath);
        }
        if (dependents.size() > 0) {
            String msg = "Error in deleting the endpoint resource. Please make sure detach the associations to the services and wsdls manually before deleting the endpoint. endpoint path: " + path + ".";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAssociation(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isAddingAssociationLockAvailable()) {
            return;
        }
        CommonUtil.acquireAddingAssociationLock();
        try {
            String targetPath = requestContext.getTargetPath();
            String sourcePath = requestContext.getSourcePath();
            Registry registry = requestContext.getRegistry();
            Resource targetResource = registry.get(targetPath);
            if ("application/vnd.wso2-service+xml".equals(targetResource.getMediaType()) && "usedBy".equals(requestContext.getAssociationType())) {
                Resource sourceResource = registry.get(sourcePath);
                byte[] sourceContent = (byte[])sourceResource.getContent();
                if (sourceContent == null) {
                    return;
                }
                String endpointUrl = RegistryUtils.decodeBytes((byte[])sourceContent);
                String endpointEnv = sourceResource.getProperty("environment");
                if (endpointEnv == null) {
                    endpointEnv = "";
                }
                if (endpointEnv.indexOf(",") > 0) {
                    for (String env : endpointEnv.split(",")) {
                        EndpointUtils.addEndpointToService(registry, targetPath, endpointUrl, env);
                    }
                } else {
                    EndpointUtils.addEndpointToService(registry, targetPath, endpointUrl, endpointEnv);
                }
            }
        }
        finally {
            CommonUtil.releaseAddingAssociationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssociation(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isAddingAssociationLockAvailable()) {
            return;
        }
        CommonUtil.acquireAddingAssociationLock();
        try {
            String targetPath = requestContext.getTargetPath();
            String sourcePath = requestContext.getSourcePath();
            Registry registry = requestContext.getRegistry();
            Resource targetResource = registry.get(targetPath);
            if ("application/vnd.wso2-service+xml".equals(targetResource.getMediaType()) && "usedBy".equals(requestContext.getAssociationType())) {
                Resource sourceResource = registry.get(sourcePath);
                byte[] sourceContent = (byte[])sourceResource.getContent();
                if (sourceContent == null) {
                    return;
                }
                String endpointUrl = RegistryUtils.decodeBytes((byte[])sourceContent);
                String endpointEnv = sourceResource.getProperty("environment");
                if (endpointEnv == null) {
                    endpointEnv = "";
                }
                if (endpointEnv.indexOf(",") > 0) {
                    for (String env : endpointEnv.split(",")) {
                        EndpointUtils.removeEndpointFromService(registry, targetPath, endpointUrl, env);
                    }
                } else {
                    EndpointUtils.removeEndpointFromService(registry, targetPath, endpointUrl, endpointEnv);
                }
            }
        }
        finally {
            CommonUtil.releaseAddingAssociationLock();
        }
    }
}

