/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.edit;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.perforce.command.AbstractPerforceConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceEditConsumer
extends AbstractPerforceConsumer
implements StreamConsumer {
    private static final String PATTERN = "^([^#]+)#\\d+ - (.*)";
    private static final String FILE_BEGIN_TOKEN = "//";
    private List<ScmFile> edits = new ArrayList<ScmFile>();
    private RE revisionRegexp;
    private boolean errors = false;
    private StringBuilder errorMessage = new StringBuilder();

    public PerforceEditConsumer() {
        try {
            this.revisionRegexp = new RE(PATTERN);
        }
        catch (RESyntaxException ignored) {
            ignored.printStackTrace();
        }
    }

    public List<ScmFile> getEdits() {
        return this.edits;
    }

    @Override
    public void consumeLine(String line) {
        if (line.startsWith("... ")) {
            return;
        }
        if (!line.startsWith(FILE_BEGIN_TOKEN)) {
            this.error(line);
        }
        if (!this.revisionRegexp.match(line)) {
            this.error(line);
        }
        this.edits.add(new ScmFile(this.revisionRegexp.getParen(1), ScmFileStatus.EDITED));
    }

    private void error(String line) {
        this.errors = true;
        this.output.println(line);
        if (this.errorMessage.length() > 0) {
            this.errorMessage.append(System.getProperty("line.separator"));
        }
        this.errorMessage.append(line);
    }

    public boolean isSuccess() {
        return !this.errors;
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }
}

