/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.local.command.update;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.local.command.LocalCommand;
import org.apache.maven.scm.provider.local.command.changelog.LocalChangeLogCommand;
import org.apache.maven.scm.provider.local.command.update.LocalUpdateScmResult;
import org.apache.maven.scm.provider.local.metadata.LocalScmMetadata;
import org.apache.maven.scm.provider.local.metadata.LocalScmMetadataUtils;
import org.apache.maven.scm.provider.local.repository.LocalScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalUpdateCommand
extends AbstractUpdateCommand
implements LocalCommand {
    @Override
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        List<ScmFile> updatedFiles;
        LocalScmProviderRepository repository = (LocalScmProviderRepository)repo;
        if (version != null) {
            throw new ScmException("The local scm doesn't support tags.");
        }
        File root = new File(repository.getRoot());
        String module = repository.getModule();
        File source = new File(root, module);
        File baseDestination = fileSet.getBasedir();
        if (!baseDestination.exists()) {
            throw new ScmException("The working directory doesn't exist (" + baseDestination.getAbsolutePath() + ").");
        }
        if (!root.exists()) {
            throw new ScmException("The base directory doesn't exist (" + root.getAbsolutePath() + ").");
        }
        if (!source.exists()) {
            throw new ScmException("The module directory doesn't exist (" + source.getAbsolutePath() + ").");
        }
        if (!baseDestination.exists() && !baseDestination.isDirectory()) {
            throw new ScmException("The destination directory isn't a directory or doesn't exist (" + baseDestination.getAbsolutePath() + ").");
        }
        try {
            List fileList;
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Updating '" + baseDestination.getAbsolutePath() + "' from '" + source.getAbsolutePath() + "'.");
            }
            List list = fileList = FileUtils.getFiles(source.getAbsoluteFile(), "**", null);
            updatedFiles = this.update(source, baseDestination, list);
            LocalScmMetadataUtils metadataUtils = new LocalScmMetadataUtils(this.getLogger());
            LocalScmMetadata originalMetadata = metadataUtils.readMetadata(baseDestination);
            if (originalMetadata != null) {
                LocalScmMetadata newMetadata = metadataUtils.buildMetadata(source);
                for (String filename : originalMetadata.getRepositoryFileNames()) {
                    File localFile;
                    if (newMetadata.getRepositoryFileNames().contains(filename) || !(localFile = new File(baseDestination, filename)).exists()) continue;
                    localFile.delete();
                    updatedFiles.add(new ScmFile("/" + filename, ScmFileStatus.UPDATED));
                }
            }
            metadataUtils.writeMetadata(baseDestination, metadataUtils.buildMetadata(source));
        }
        catch (IOException ex) {
            throw new ScmException("Error while checking out the files.", ex);
        }
        return new LocalUpdateScmResult(null, updatedFiles);
    }

    private List<ScmFile> update(File source, File baseDestination, List<File> files) throws ScmException, IOException {
        String sourcePath = source.getAbsolutePath();
        ArrayList<ScmFile> updatedFiles = new ArrayList<ScmFile>();
        for (File repositoryFile : files) {
            String destionationFileContents;
            File repositoryDirectory = repositoryFile.getParentFile();
            if (repositoryDirectory != null && repositoryDirectory.getName().equals("CVS")) continue;
            String dest = repositoryFile.getAbsolutePath().substring(sourcePath.length() + 1);
            File destinationFile = new File(baseDestination, dest);
            String repositoryFileContents = FileUtils.fileRead(repositoryFile);
            if (destinationFile.exists() && repositoryFileContents.equals(destionationFileContents = FileUtils.fileRead(destinationFile))) continue;
            File destinationDirectory = destinationFile.getParentFile();
            if (!destinationDirectory.exists() && !destinationDirectory.mkdirs()) {
                throw new ScmException("Could not create destination directory '" + destinationDirectory.getAbsolutePath() + "'.");
            }
            ScmFileStatus status2 = destinationFile.exists() ? ScmFileStatus.UPDATED : ScmFileStatus.ADDED;
            FileUtils.copyFileToDirectory(repositoryFile, destinationDirectory);
            int chop = baseDestination.getAbsolutePath().length();
            String fileName = "/" + destinationFile.getAbsolutePath().substring(chop + 1);
            updatedFiles.add(new ScmFile(fileName, status2));
        }
        return updatedFiles;
    }

    @Override
    protected ChangeLogCommand getChangeLogCommand() {
        return new LocalChangeLogCommand();
    }
}

