/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.Command;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.command.login.LoginScmResult;
import org.apache.maven.scm.command.mkdir.MkdirScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCvsScmProvider
extends AbstractScmProvider {
    public static final String TRANSPORT_EXT = "ext";
    public static final String TRANSPORT_LOCAL = "local";
    public static final String TRANSPORT_LSERVER = "lserver";
    public static final String TRANSPORT_PSERVER = "pserver";
    public static final String TRANSPORT_SSPI = "sspi";

    @Override
    public String getScmSpecificFilename() {
        return "CVS";
    }

    @Override
    public String sanitizeTagName(String arg0) {
        if (this.validateTagName(arg0)) {
            return arg0;
        }
        if (arg0.equals("HEAD") || arg0.equals("BASE") || !arg0.matches("[A-Za-z].*")) {
            throw new RuntimeException("Unable to sanitize tag " + arg0 + ": must begin with a letter" + "and not be HEAD or BASE");
        }
        return arg0.replaceAll("[^A-Za-z0-9_-]", "_");
    }

    @Override
    public boolean validateTagName(String arg0) {
        return arg0.matches("[A-Za-z][A-Za-z0-9_-]*") && !arg0.equals("HEAD") && !arg0.equals("BASE");
    }

    @Override
    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        ScmUrlParserResult result = this.parseScmUrl(scmSpecificUrl, delimiter);
        if (result.getMessages().size() > 0) {
            throw new ScmRepositoryException("The scm url is invalid.", result.getMessages());
        }
        return result.getRepository();
    }

    @Override
    public ScmProviderRepository makeProviderScmRepository(File path) throws ScmRepositoryException, UnknownRepositoryStructure {
        String module;
        String cvsRoot;
        if (path == null || !path.isDirectory()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a valid directory.");
        }
        File cvsDirectory = new File(path, "CVS");
        if (!cvsDirectory.exists()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a cvs checkout directory.");
        }
        File cvsRootFile = new File(cvsDirectory, "Root");
        File moduleFile = new File(cvsDirectory, "Repository");
        try {
            cvsRoot = FileUtils.fileRead(cvsRootFile).trim().substring(1);
        }
        catch (IOException e) {
            throw new ScmRepositoryException("Can't read " + cvsRootFile.getAbsolutePath());
        }
        try {
            module = FileUtils.fileRead(moduleFile).trim();
        }
        catch (IOException e) {
            throw new ScmRepositoryException("Can't read " + moduleFile.getAbsolutePath());
        }
        return this.makeProviderScmRepository(cvsRoot + ":" + module, ':');
    }

    @Override
    public List<String> validateScmUrl(String scmSpecificUrl, char delimiter) {
        ScmUrlParserResult result = this.parseScmUrl(scmSpecificUrl, delimiter);
        return result.getMessages();
    }

    @Override
    public String getScmType() {
        return "cvs";
    }

    @Override
    public AddScmResult add(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (AddScmResult)this.executeCommand(this.getAddCommand(), repository, fileSet, parameters);
    }

    @Override
    public BranchScmResult branch(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (BranchScmResult)this.executeCommand(this.getBranchCommand(), repository, fileSet, parameters);
    }

    @Override
    protected BlameScmResult blame(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (BlameScmResult)this.executeCommand(this.getBlameCommand(), repository, fileSet, parameters);
    }

    @Override
    public ChangeLogScmResult changelog(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (ChangeLogScmResult)this.executeCommand(this.getChangeLogCommand(), repository, fileSet, parameters);
    }

    @Override
    public CheckInScmResult checkin(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (CheckInScmResult)this.executeCommand(this.getCheckInCommand(), repository, fileSet, parameters);
    }

    @Override
    public CheckOutScmResult checkout(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (CheckOutScmResult)this.executeCommand(this.getCheckOutCommand(), repository, fileSet, parameters);
    }

    @Override
    public DiffScmResult diff(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (DiffScmResult)this.executeCommand(this.getDiffCommand(), repository, fileSet, parameters);
    }

    @Override
    protected ExportScmResult export(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (ExportScmResult)this.executeCommand(this.getExportCommand(), repository, fileSet, parameters);
    }

    @Override
    public LoginScmResult login(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (LoginScmResult)this.executeCommand(this.getLoginCommand(), repository, fileSet, parameters);
    }

    @Override
    public RemoveScmResult remove(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (RemoveScmResult)this.executeCommand(this.getRemoveCommand(), repository, fileSet, parameters);
    }

    @Override
    public StatusScmResult status(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (StatusScmResult)this.executeCommand(this.getStatusCommand(), repository, fileSet, parameters);
    }

    @Override
    public TagScmResult tag(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (TagScmResult)this.executeCommand(this.getTagCommand(), repository, fileSet, parameters);
    }

    protected TagScmResult tag(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters, ScmTagParameters scmParameters) throws ScmException {
        return (TagScmResult)this.getTagCommand().execute(repository, fileSet, parameters);
    }

    @Override
    public UpdateScmResult update(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (UpdateScmResult)this.executeCommand(this.getUpdateCommand(), repository, fileSet, parameters);
    }

    @Override
    protected ListScmResult list(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (ListScmResult)this.executeCommand(this.getListCommand(), repository, fileSet, parameters);
    }

    @Override
    protected MkdirScmResult mkdir(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (MkdirScmResult)this.executeCommand(this.getMkdirCommand(), repository, fileSet, parameters);
    }

    public static String getRelativePath(File basedir, File f) throws ScmException, IOException {
        File fileOrDir = AbstractCvsScmProvider.getAbsoluteFilePath(f);
        if (!fileOrDir.getPath().startsWith(basedir.getPath())) {
            throw new ScmException(fileOrDir.getPath() + " was not contained in " + basedir.getPath());
        }
        return fileOrDir.getPath().substring(basedir.getPath().length() + 1, fileOrDir.getPath().length());
    }

    protected ScmUrlParserResult parseScmUrl(String scmSpecificUrl, char delimiter) {
        String cvsroot;
        ScmUrlParserResult result = new ScmUrlParserResult();
        String[] tokens = StringUtils.split(scmSpecificUrl, Character.toString(delimiter));
        if (tokens.length < 3) {
            result.getMessages().add("The connection string contains too few tokens.");
            return result;
        }
        String transport = tokens[0];
        if (transport.equalsIgnoreCase(TRANSPORT_LOCAL)) {
            cvsroot = tokens[1];
        } else if (transport.equalsIgnoreCase(TRANSPORT_PSERVER) || transport.equalsIgnoreCase(TRANSPORT_LSERVER) || transport.equalsIgnoreCase(TRANSPORT_EXT) || transport.equalsIgnoreCase(TRANSPORT_SSPI)) {
            if (tokens.length != 4 && transport.equalsIgnoreCase(TRANSPORT_EXT)) {
                result.getMessages().add("The connection string contains too few tokens.");
                return result;
            }
            if ((tokens.length < 4 || tokens.length > 6) && transport.equalsIgnoreCase(TRANSPORT_PSERVER)) {
                result.getMessages().add("The connection string contains too few tokens.");
                return result;
            }
            if (tokens.length < 4 || tokens.length > 5 && !transport.equalsIgnoreCase(TRANSPORT_PSERVER)) {
                result.getMessages().add("The connection string contains too few tokens.");
                return result;
            }
            if (tokens.length < 4 || tokens.length > 5 && transport.equalsIgnoreCase(TRANSPORT_SSPI)) {
                result.getMessages().add("The connection string contains too few tokens.");
                return result;
            }
            cvsroot = transport.equalsIgnoreCase(TRANSPORT_LSERVER) ? tokens[1] + ":" + tokens[2] : (tokens.length == 4 ? ":" + transport + ":" + tokens[1] + ":" + tokens[2] : ":" + transport + ":" + tokens[1] + ":" + tokens[2] + ":" + tokens[3]);
        } else {
            result.getMessages().add("Unknown transport: " + transport);
            return result;
        }
        String user = null;
        String password = null;
        String host = null;
        String path = null;
        String module = null;
        int port = -1;
        if (transport.equalsIgnoreCase(TRANSPORT_PSERVER)) {
            String passhost;
            String userhost;
            port = 2401;
            if (tokens.length == 4) {
                userhost = tokens[1];
                int index = userhost.indexOf(64);
                if (index == -1) {
                    host = userhost;
                } else {
                    user = userhost.substring(0, index);
                    host = userhost.substring(index + 1);
                }
                path = tokens[2];
                module = tokens[3];
            } else if (tokens.length == 6) {
                user = tokens[1];
                passhost = tokens[2];
                int index = passhost.indexOf(64);
                if (index == -1) {
                    result.getMessages().add("The user_password_host part must be on the form: <username>:<password>@<hostname>.");
                    return result;
                }
                password = passhost.substring(0, index);
                host = passhost.substring(index + 1);
                port = new Integer(tokens[3]);
                path = tokens[4];
                module = tokens[5];
            } else {
                if (tokens[1].indexOf(64) > 0) {
                    userhost = tokens[1];
                    int index = userhost.indexOf(64);
                    user = userhost.substring(0, index);
                    host = userhost.substring(index + 1);
                    port = new Integer(tokens[2]);
                } else if (tokens[2].indexOf(64) >= 0) {
                    user = tokens[1];
                    passhost = tokens[2];
                    int index = passhost.indexOf(64);
                    password = passhost.substring(0, index);
                    host = passhost.substring(index + 1);
                } else {
                    try {
                        port = new Integer(tokens[2]);
                    }
                    catch (Exception e) {
                        result.getMessages().add("Your scm url is invalid.");
                        return result;
                    }
                    host = tokens[1];
                }
                path = tokens[3];
                module = tokens[4];
            }
            String userHost = host;
            if (user != null) {
                userHost = user + "@" + host;
            }
            cvsroot = ":" + transport + ":" + userHost + ":";
            if (port != -1) {
                cvsroot = cvsroot + port;
            }
            cvsroot = cvsroot + path;
        } else if (transport.equalsIgnoreCase(TRANSPORT_SSPI)) {
            String userhost = tokens[1];
            int index = userhost.indexOf(64);
            if (index == -1) {
                user = "";
                host = userhost;
            } else {
                user = userhost.substring(0, index);
                host = userhost.substring(index + 1);
            }
            if (tokens.length == 4) {
                path = tokens[2];
                module = tokens[3];
            } else {
                try {
                    port = new Integer(tokens[2]);
                    path = tokens[3];
                    module = tokens[4];
                }
                catch (Exception e) {
                    result.getMessages().add("Your scm url is invalid, could not get port value.");
                    return result;
                }
            }
            cvsroot = ":" + transport + ":" + host + ":";
            if (port != -1) {
                cvsroot = cvsroot + port;
            }
            cvsroot = cvsroot + path;
        } else {
            if (!transport.equalsIgnoreCase(TRANSPORT_LOCAL)) {
                String userhost = tokens[1];
                int index = userhost.indexOf(64);
                if (index == -1) {
                    host = userhost;
                } else {
                    user = userhost.substring(0, index);
                    host = userhost.substring(index + 1);
                }
            }
            if (transport.equals(TRANSPORT_LOCAL)) {
                path = tokens[1];
                module = tokens[2];
                if (module != null && module.startsWith("/")) {
                    module = module.substring(1);
                }
            } else if (tokens.length == 4) {
                path = tokens[2];
                module = tokens[3];
            } else {
                port = new Integer(tokens[2]);
                path = tokens[3];
                module = tokens[4];
            }
        }
        if (port == -1) {
            result.setRepository(new CvsScmProviderRepository(cvsroot, transport, user, password, host, path, module));
        } else {
            result.setRepository(new CvsScmProviderRepository(cvsroot, transport, user, password, host, port, path, module));
        }
        return result;
    }

    protected abstract Command getAddCommand();

    protected abstract Command getBranchCommand();

    protected abstract Command getBlameCommand();

    protected abstract Command getChangeLogCommand();

    protected abstract Command getCheckInCommand();

    protected abstract Command getCheckOutCommand();

    protected abstract Command getDiffCommand();

    protected abstract Command getExportCommand();

    protected abstract Command getListCommand();

    protected abstract Command getLoginCommand();

    protected abstract Command getRemoveCommand();

    protected abstract Command getStatusCommand();

    protected abstract Command getTagCommand();

    protected abstract Command getUpdateCommand();

    protected abstract Command getMkdirCommand();

    private ScmResult executeCommand(Command command, ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = AbstractCvsScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        command.setLogger(this.getLogger());
        return command.execute(repository, fileSet, parameters);
    }

    private static ScmFileSet fixUpScmFileSetAbsoluteFilePath(ScmFileSet currentFileSet) throws ScmException {
        ScmFileSet newFileSet = null;
        try {
            File basedir = AbstractCvsScmProvider.getAbsoluteFilePath(currentFileSet.getBasedir());
            ArrayList<File> fixedFiles = new ArrayList<File>(currentFileSet.getFileList().size());
            for (File file : currentFileSet.getFileList()) {
                if (file.isAbsolute()) {
                    fixedFiles.add(new File(AbstractCvsScmProvider.getRelativePath(basedir, file)));
                    continue;
                }
                fixedFiles.add(file);
            }
            newFileSet = new ScmFileSet(basedir, fixedFiles);
        }
        catch (IOException e) {
            throw new ScmException("Invalid file set.", e);
        }
        return newFileSet;
    }

    private static File getAbsoluteFilePath(File fileOrDir) throws IOException {
        String javaPathString = fileOrDir.getCanonicalPath().replace('\\', '/');
        if (javaPathString.endsWith("/")) {
            javaPathString = javaPathString.substring(0, javaPathString.length() - 1);
        }
        return new File(javaPathString);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScmUrlParserResult {
        private List<String> messages = new ArrayList<String>();
        private ScmProviderRepository repository;

        public List<String> getMessages() {
            return this.messages;
        }

        public void setMessages(List<String> messages) {
            this.messages = messages;
        }

        public ScmProviderRepository getRepository() {
            return this.repository;
        }

        public void setRepository(ScmProviderRepository repository) {
            this.repository = repository;
        }

        public void resetMessages() {
            this.messages = new ArrayList<String>();
        }
    }
}

