/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOutput;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.util.WSDLUtil;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2121
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private TypesRegistry registry = null;

    public BP2121(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(SOAPBinding binding, Object parent, WSDLTraversalContext ctx) {
        String style = binding.getStyle() == null ? "document" : binding.getStyle();
        ctx.addParameter("style", style);
    }

    public void visit(SOAPOperation operation, Object parent, WSDLTraversalContext ctx) {
        String style = operation.getStyle();
        if (style == null) {
            style = (String)ctx.getParameter("style");
        }
        if (!"document".equals(style)) {
            ctx.cancelBindingOperationProcessing();
        }
    }

    public void visit(SOAPBody body, Object parent, WSDLTraversalContext ctx) {
        if ("literal".equals(body.getUse())) {
            Message m;
            Operation op = ctx.getBindingOperation().getOperation();
            if (op == null || parent instanceof BindingInput && op.getInput() == null || parent instanceof BindingOutput && op.getOutput() == null) {
                return;
            }
            Message message = m = parent instanceof BindingInput ? op.getInput().getMessage() : op.getOutput().getMessage();
            if (m == null) {
                return;
            }
            List parts = WSDLUtil.getParts(op, m, body, "document");
            if (parts == null) {
                return;
            }
            for (Part p : parts) {
                if (p.getElementName() != null && this.registry.getType(p.getElementName()) != null) continue;
                this.errors.add(op.getName());
                ctx.cancelBindingOperationProcessing();
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        this.registry = new TypesRegistry(entryContext.getWSDLDocument().getDefinitions(), this.validator);
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitSOAPBinding(true);
        traversal.visitSOAPBody(true);
        traversal.visitSOAPOperation(true);
        traversal.ignoreReferences();
        traversal.ignoreImport();
        traversal.traverse((Binding)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

