/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;

public class BP4103
extends AssertionProcess {
    private static final String HTTP_AUTH_SCHEME_BASIC = "Basic";
    private static final String HTTP_AUTH_SCHEME_DIGEST = "Digest";
    private final BaseMessageValidator validator;

    public BP4103(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String headers = entryContext.getMessageEntry().getHTTPHeaders();
        if (entryContext.getMessageEntry().getType().equals("request")) {
            if (!this.containsInvalidAuth(headers, "Authorization") && !this.containsInvalidAuth(headers, "Proxy-Authorization")) {
                this.result = "notApplicable";
            }
        } else if (!this.containsInvalidAuth(headers, "WWW-Authenticate") && !this.containsInvalidAuth(headers, "Proxy-Authenticate")) {
            this.result = "notApplicable";
        }
        if (this.result.equals("passed")) {
            this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsInvalidAuth(String headers, String header) {
        String headerValue = null;
        try {
            headerValue = (String)HTTPUtils.getHttpHeaderTokens(headers, ":").get(header.toUpperCase());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (headerValue != null) {
            int idxSP = headerValue.indexOf(" ");
            if (idxSP > -1) {
                headerValue = headerValue.substring(0, idxSP);
            }
            if (!headerValue.equalsIgnoreCase(HTTP_AUTH_SCHEME_BASIC) && !headerValue.equalsIgnoreCase(HTTP_AUTH_SCHEME_DIGEST)) {
                return true;
            }
        }
        return false;
    }
}

