/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BP1202
extends AssertionProcess
implements WSITag {
    private final BaseMessageValidator validator;

    public BP1202(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document doc = entryContext.getMessageEntryDocument();
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else if (!this.validator.containsSoapBodyWithChild(doc)) {
            this.result = "notApplicable";
        } else {
            Element root = doc.getDocumentElement();
            NodeList rootNodeList = root.getElementsByTagNameNS(ELEM_SOAP_BODY.getNamespaceURI(), ELEM_SOAP_BODY.getLocalPart());
            if (rootNodeList.getLength() > 0) {
                Element body = (Element)rootNodeList.item(0);
                NodeList children = body.getChildNodes();
                for (int i = 0; i < children.getLength() && this.result == "passed"; ++i) {
                    String ns;
                    Node n = children.item(i);
                    if (!(n instanceof Element) || (ns = n.getNamespaceURI()) != null && ns.length() != 0) continue;
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(entryContext.getMessageEntry().getMessage(), entryContext);
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

