/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AnalyzerContext;
import org.eclipse.wst.wsi.internal.core.profile.ProfileArtifact;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.BaseValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.EnvelopeValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.report.Entry;
import org.eclipse.wst.wsi.internal.core.report.FailureDetail;
import org.eclipse.wst.wsi.internal.core.report.PrereqFailedList;
import org.eclipse.wst.wsi.internal.core.report.ReportArtifact;
import org.eclipse.wst.wsi.internal.core.report.Reporter;
import org.eclipse.wst.wsi.internal.core.report.impl.PrereqFailedListImpl;
import org.eclipse.wst.wsi.internal.core.util.EntryType;
import org.eclipse.wst.wsi.internal.core.xml.XMLDocumentCacheUser;
import org.eclipse.wst.wsi.internal.core.xml.dom.ElementLocation;

public abstract class BaseValidatorImpl
extends XMLDocumentCacheUser
implements BaseValidator {
    private static final Hashtable resultPriority = new Hashtable(6);
    private static final int MAX_VALID_PRIORITY = 1;
    public AnalyzerContext analyzerContext;
    protected ProfileArtifact profileArtifact;
    protected Reporter reporter;
    protected ReportArtifact reportArtifact;
    public boolean verboseOption = false;
    protected int assertionCount = 0;

    public void init(AnalyzerContext analyzerContext, ProfileArtifact profileArtifact, ReportArtifact reportArtifact, Reporter reporter) throws WSIException {
        this.analyzerContext = analyzerContext;
        this.profileArtifact = profileArtifact;
        this.reportArtifact = reportArtifact;
        this.reporter = reporter;
        this.verboseOption = reporter.getReport().getReportContext().getAnalyzer().getAnalyzerConfig().getVerboseOption();
    }

    protected void processAssertions(String classPrefix, EntryContext entryContext) throws WSIException {
        long startTime = 0L;
        HashMap<String, AssertionProcess> processList = new HashMap<String, AssertionProcess>();
        TestAssertion testAssertion2 = null;
        Class[] paramTypes = new Class[]{this instanceof BaseMessageValidator ? BaseMessageValidator.class : this.getClass()};
        Object[] params = new Object[]{this};
        Entry entry = entryContext.getEntry();
        this.reportArtifact.addEntry(entry);
        if (this instanceof EnvelopeValidator) {
            this.reporter.setCurrentEnvelopeEntry(entry);
        } else {
            this.reporter.setCurrentEntry(entry);
        }
        try {
            for (TestAssertion testAssertion2 : this.profileArtifact.getTestAssertionList()) {
                AssertionResult assertionResult = null;
                if (!testAssertion2.isEnabled() || !this.isPrimaryEntryTypeMatch(testAssertion2, entryContext)) continue;
                try {
                    ++this.assertionCount;
                    AssertionProcess assertionProcess = (AssertionProcess)processList.get(testAssertion2.getId());
                    if (assertionProcess == null) {
                        Class<?> assertionClass = Class.forName(classPrefix + testAssertion2.getId());
                        assertionProcess = (AssertionProcess)assertionClass.getConstructor(paramTypes).newInstance(params);
                        processList.put(testAssertion2.getId(), assertionProcess);
                    }
                    if (entry.getEntryDetail() == null) {
                        assertionResult = this.createAssertionResult(testAssertion2, "missingInput", (String)null);
                    } else if (this.isNotApplicable(testAssertion2)) {
                        assertionResult = this.createAssertionResult(testAssertion2, "notApplicable", (String)null);
                    } else {
                        TreeMap preReqResults = null;
                        PrereqFailedList prereqFailedList = null;
                        Iterator i = testAssertion2.getPrereqIdList().iterator();
                        while (i.hasNext()) {
                            if (preReqResults == null) {
                                preReqResults = new TreeMap();
                            }
                            String preReqId = (String)i.next();
                            AssertionResult preReqResult = this.reporter.getAssertionResult(preReqId);
                            preReqResults.put(resultPriority.get(preReqResult.getResult()), preReqResult.getResult());
                            if ((Integer)resultPriority.get(preReqResult.getResult()) <= 1) continue;
                            if (prereqFailedList == null) {
                                prereqFailedList = new PrereqFailedListImpl();
                            }
                            prereqFailedList.addTestAssertionID(preReqId);
                        }
                        if (prereqFailedList != null) {
                            Integer maxRes = (Integer)preReqResults.lastKey();
                            String resString = (String)preReqResults.get(maxRes);
                            if (resString.equals("failed") || resString.equals("warning")) {
                                resString = "prereqFailed";
                            }
                            assertionResult = this.createAssertionResult(testAssertion2, resString, prereqFailedList);
                        } else {
                            assertionProcess.reset();
                            if (this.verboseOption) {
                                System.err.println("  Processing " + testAssertion2.getId() + " for entry reference ID [" + entry.getReferenceID() + "] ...");
                                startTime = System.currentTimeMillis();
                            }
                            assertionResult = assertionProcess.validate(testAssertion2, entryContext);
                            if (this.verboseOption) {
                                System.err.println("    Elapsed time: " + (System.currentTimeMillis() - startTime) + "ms");
                            }
                        }
                    }
                    this.reporter.addAssertionResult(assertionResult);
                }
                catch (ClassNotFoundException cnfe) {
                    if (testAssertion2 == null) continue;
                    this.reporter.getReport().getReportContext().getAnalyzer().printMessage("WARNING: " + testAssertion2.getId() + " is not supported currently.");
                }
            }
        }
        catch (Exception e) {
            System.err.println("EXECEPTION: " + e.getMessage());
            if (this.verboseOption) {
                e.printStackTrace();
            }
            if (e instanceof WSIException) {
                throw (WSIException)e;
            }
            throw new WSIException(e.getMessage(), e);
        }
        finally {
            this.reporter.endCurrentEntry();
        }
    }

    protected abstract boolean isPrimaryEntryTypeMatch(TestAssertion var1, EntryContext var2);

    protected boolean isPrimaryEntryTypeMatch(TestAssertion testAssertion, Entry entry) {
        boolean match = false;
        if (testAssertion.getEntryTypeName().equals(entry.getEntryType().getTypeName())) {
            match = true;
        }
        return match;
    }

    protected abstract boolean isNotApplicable(TestAssertion var1);

    public void cleanup() throws WSIException {
        if (this.assertionCount == 0) {
            this.setAllMissingInput();
        }
    }

    public AssertionResult createAssertionResult(TestAssertion testAssertion, String result, FailureDetail failureDetail) {
        Vector<FailureDetail> failureDetailList = null;
        if (failureDetail != null) {
            failureDetailList = new Vector<FailureDetail>();
            failureDetailList.add(failureDetail);
        }
        return this.createAssertionResult(testAssertion, result, failureDetailList);
    }

    public AssertionResult createAssertionResult(TestAssertion testAssertion, String result, String failureDetailMessage) {
        return this.createAssertionResult(testAssertion, result, failureDetailMessage, null);
    }

    public AssertionResult createAssertionResult(TestAssertion testAssertion, String result, String failureDetailMessage, ElementLocation elementLocation) {
        Vector<FailureDetail> failureDetailList = null;
        if (failureDetailMessage != null) {
            failureDetailList = new Vector<FailureDetail>();
            FailureDetail failureDetail = this.reporter.createFailureDetail();
            failureDetail.setFailureMessage(failureDetailMessage);
            failureDetail.setElementLocation(elementLocation);
            failureDetailList.add(failureDetail);
        }
        return this.createAssertionResult(testAssertion, result, failureDetailList);
    }

    public AssertionResult createAssertionResult(TestAssertion testAssertion, String result, Vector failureDetailList) {
        AssertionResult assertionResult = this.reporter.createAssertionResult();
        assertionResult.setAssertion(testAssertion);
        assertionResult.setResult(result);
        assertionResult.setEntry(this.reporter.getReport().getCurrentEntry());
        assertionResult.setFailureDetailList(failureDetailList);
        return assertionResult;
    }

    public AssertionResult createAssertionResult(TestAssertion testAssertion, String result, PrereqFailedList prereqFailedList) {
        AssertionResult assertionResult = this.reporter.createAssertionResult();
        assertionResult.setAssertion(testAssertion);
        assertionResult.setResult(result);
        assertionResult.setEntry(this.reporter.getReport().getCurrentEntry());
        assertionResult.setPrereqFailedList(prereqFailedList);
        return assertionResult;
    }

    protected void addAssertionResult(String assertionId, String result) throws WSIException {
        AssertionResult assertionResult = this.reporter.createAssertionResult();
        assertionResult.setAssertion(this.profileArtifact.getTestAssertion(assertionId));
        assertionResult.setResult(result);
        assertionResult.setEntry(this.reporter.getReport().getCurrentEntry());
        this.reporter.addAssertionResult(assertionResult);
    }

    protected void addAssertionResult(String assertionId, String result, String failureDetailMessage) throws WSIException {
        Vector<FailureDetail> failureDetailList = null;
        if (failureDetailMessage != null) {
            failureDetailList = new Vector<FailureDetail>();
            FailureDetail failureDetail = this.reporter.createFailureDetail();
            failureDetailList.add(failureDetail);
        }
        this.addAssertionResult(assertionId, result, failureDetailList);
    }

    protected void addAssertionResult(String assertionId, String result, Vector failureDetailList) throws WSIException {
        AssertionResult assertionResult = this.reporter.createAssertionResult();
        assertionResult.setAssertion(this.profileArtifact.getTestAssertion(assertionId));
        assertionResult.setResult(result);
        assertionResult.setEntry(this.reporter.getReport().getCurrentEntry());
        assertionResult.setFailureDetailList(failureDetailList);
        this.reporter.addAssertionResult(assertionResult);
    }

    protected void addMissingInputResult(TestAssertion testAssertion) throws WSIException {
        AssertionResult assertionResult = this.reporter.createAssertionResult();
        assertionResult.setAssertion(testAssertion);
        assertionResult.setResult("missingInput");
        assertionResult.setEntry(this.reporter.getReport().getCurrentEntry());
        this.reporter.addAssertionResult(assertionResult);
    }

    public void setAllMissingInput() throws WSIException {
        if (this.profileArtifact != null) {
            Entry entry = this.reporter.getReport().createEntry();
            entry.setArtifactName(this.reportArtifact.getType().getTypeName());
            this.reportArtifact.addEntry(entry);
            this.reporter.setCurrentEntry(entry);
            for (TestAssertion testAssertion : this.profileArtifact.getTestAssertionList()) {
                if (!testAssertion.isEnabled()) continue;
                this.addMissingInputResult(testAssertion);
            }
            this.reporter.endCurrentEntry();
        }
    }

    protected void setMissingInput(EntryType entryType) throws WSIException {
        Entry entry = this.reporter.getReport().createEntry();
        entry.setEntryType(entryType);
        entry.setReferenceID("[" + entryType.getTypeName() + "]");
        this.reportArtifact.addEntry(entry);
        this.reporter.setCurrentEntry(entry);
        for (TestAssertion testAssertion : this.profileArtifact.getTestAssertionList()) {
            if (!testAssertion.isEnabled() || !this.isPrimaryEntryTypeMatch(testAssertion, entry)) continue;
            this.addMissingInputResult(testAssertion);
        }
        this.reporter.endCurrentEntry();
    }

    static {
        resultPriority.put("passed", new Integer(0));
        resultPriority.put("notApplicable", new Integer(1));
        resultPriority.put("missingInput", new Integer(2));
        resultPriority.put("warning", new Integer(3));
        resultPriority.put("prereqFailed", new Integer(4));
        resultPriority.put("failed", new Integer(5));
    }
}

