/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.monitor;

import java.io.StringReader;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.log.Log;
import org.eclipse.wst.wsi.internal.core.log.LogWriter;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.monitor.Monitor;

public class MessageEntryQueue {
    protected Vector requestList = new Vector();
    protected Vector responseList = new Vector();
    protected Monitor monitor = null;
    protected Log log = null;
    protected LogWriter logWriter = null;
    protected String listLock = "listLock";
    protected int messageId = 1;

    public MessageEntryQueue(Monitor monitor, Log log, LogWriter logWriter) {
        this.monitor = monitor;
        this.log = log;
        this.logWriter = logWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addMessageEntry(MessageEntry messageEntry) throws WSIException {
        String string = this.listLock;
        synchronized (string) {
            if (messageEntry.getType().equals("request")) {
                this.requestList.add(messageEntry);
            } else {
                this.responseList.add(messageEntry);
            }
        }
        this.writeFromQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeFromQueue() throws WSIException {
        MessageEntry requestMessageEntry = null;
        MessageEntry responseMessageEntry = null;
        boolean responseFound = false;
        int[] requestIndexList = new int[this.requestList.size()];
        int reqIndexCount = 0;
        String string = this.listLock;
        synchronized (string) {
            for (int reqIndex = 0; reqIndex < this.requestList.size(); ++reqIndex) {
                requestMessageEntry = (MessageEntry)this.requestList.elementAt(reqIndex);
                responseFound = false;
                for (int respIndex = 0; respIndex < this.responseList.size() && !responseFound; ++respIndex) {
                    responseMessageEntry = (MessageEntry)this.responseList.elementAt(respIndex);
                    if (!requestMessageEntry.getConversationId().equals(responseMessageEntry.getConversationId())) continue;
                    responseFound = true;
                    requestMessageEntry.setId(this.getNextMessageId());
                    responseMessageEntry.setId(this.getNextMessageId());
                    StringReader requestReader = new StringReader(requestMessageEntry.toXMLString(""));
                    this.logWriter.write(requestReader);
                    this.printMessage(requestMessageEntry);
                    StringReader responseReader = new StringReader(responseMessageEntry.toXMLString(""));
                    this.logWriter.write(responseReader);
                    this.printMessage(responseMessageEntry);
                    requestIndexList[reqIndexCount++] = reqIndex;
                    this.responseList.remove(respIndex);
                }
            }
            for (int count = 0; count < reqIndexCount; ++count) {
                this.requestList.remove(requestIndexList[count]);
            }
        }
    }

    protected synchronized String getNextMessageId() {
        return String.valueOf(this.messageId++);
    }

    protected void printMessage(MessageEntry messageEntry) {
        this.monitor.printMessage("log01", messageEntry.getId() + ", " + messageEntry.getType() + ", " + messageEntry.getSenderHostAndPort(), "Log message entry -  ID: " + messageEntry.getId() + ", Type: " + messageEntry.getType() + ", Sender: " + messageEntry.getSenderHostAndPort());
    }
}

