/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11.soap;

import com.ibm.wsdl.BindingFaultImpl;
import com.ibm.wsdl.BindingImpl;
import com.ibm.wsdl.BindingInputImpl;
import com.ibm.wsdl.BindingOperationImpl;
import com.ibm.wsdl.BindingOutputImpl;
import com.ibm.wsdl.PortImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11Validator;

public class SOAPValidator
implements IWSDL11Validator {
    private static String SOAP_RESOURCE_BUNDLE_NAME = "validatewsdlsoap";
    private final String _ERROR_INVALID_PORT_ELEMENT = "_ERROR_INVALID_PORT_ELEMENT";
    private final String _ERROR_INVALID_BINDING_ELEMENT = "_ERROR_INVALID_BINDING_ELEMENT";
    private final String _ERROR_INVALID_BINDING_OPERATION_ELEMENT = "_ERROR_INVALID_BINDING_OPERATION_ELEMENT";
    private final String _ERROR_INVALID_HEADER_BODY_ELEMENT = "_ERROR_INVALID_HEADER_BODY_ELEMENT";
    private final String _ERROR_INVALID_FAULT_ELEMENT = "_ERROR_INVALID_FAULT_ELEMENT";
    private final String _ERROR_INVALID_SOAP_ELEMENT_FOR_LOCATION = "_ERROR_INVALID_SOAP_ELEMENT_FOR_LOCATION";
    private final String _ERROR_NO_LOCATION_FOR_ADDRESS = "_ERROR_NO_LOCATION_FOR_ADDRESS";
    private final String _ERROR_NO_SOAPBINDING_FOR_ADDRESS = "_ERROR_NO_SOAPBINDING_FOR_ADDRESS";
    private final String _ERROR_INVALID_BINDING_STYLE = "_ERROR_INVALID_BINDING_STYLE";
    private final String _ERROR_INVALID_BINDING_URI = "_ERROR_INVALID_BINDING_URI";
    private final String _ERROR_INVALID_OPERATION_STYLE = "_ERROR_INVALID_OPERATION_STYLE";
    private final String _ERROR_NO_SOAPBINDING_FOR_OPERATION = "_ERROR_NO_SOAPBINDING_FOR_OPERATION";
    private final String _ERROR_INVALID_BODY_ENCODING_STYLE = "_ERROR_INVALID_BODY_ENCODING_STYLE";
    private final String _ERROR_INVALID_BODY_USE = "_ERROR_INVALID_BODY_USE";
    private final String _ERROR_INVALID_BODY_PART_NOT_TYPE = "_ERROR_INVALID_BODY_PART_NOT_TYPE";
    private final String _ERROR_INVALID_BODY_PART_UNDEFINED = "_ERROR_INVALID_BODY_PART_UNDEFINED";
    private final String _ERROR_NO_SOAPBINDING_FOR_BODY = "_ERROR_NO_SOAPBINDING_FOR_BODY";
    private final String _ERROR_HEADER_MESSAGE_UNDEFINED = "_ERROR_HEADER_MESSAGE_UNDEFINED";
    private final String _ERROR_HEADER_PART_UNDEFINED = "_ERROR_HEADER_PART_UNDEFINED";
    private final String _ERROR_HEADER_USE_UNDEFINED = "_ERROR_HEADER_USE_UNDEFINED";
    private final String _ERROR_HEADER_ENCODINGSTYLE_UNDEFINED = "_ERROR_HEADER_ENCODINGSTYLE_UNDEFINED";
    private final String _ERROR_HEADER_NAMESPACE_UNDEFINED = "_ERROR_HEADER_NAMESPACE_UNDEFINED";
    private final String _ERROR_NO_SOAPBINDING_FOR_HEADER = "_ERROR_NO_SOAPBINDING_FOR_HEADER";
    private final String _ERROR_HEADERFAULT_MESSAGE_UNDEFINED = "_ERROR_HEADERFAULT_MESSAGE_UNDEFINED";
    private final String _ERROR_HEADERFAULT_PART_UNDEFINED = "_ERROR_HEADERFAULT_PART_UNDEFINED";
    private final String _ERROR_HEADERFAULT_USE_UNDEFINED = "_ERROR_HEADERFAULT_USE_UNDEFINED";
    private final String _ERROR_HEADERFAULT_ENCODINGSTYLE_UNDEFINED = "_ERROR_HEADERFAULT_ENCODINGSTYLE_UNDEFINED";
    private final String _ERROR_HEADERFAULT_NAMESPACE_UNDEFINED = "_ERROR_HEADERFAULT_NAMESPACE_UNDEFINED";
    private final String _ERROR_INVALID_FAULT_NAME = "_ERROR_INVALID_FAULT_NAME";
    private final String ENCODED = "encoded";
    private final String LITERAL = "literal";
    private final String RPC = "rpc";
    private final String DOCUMENT = "document";
    private final String QUOTE = "'";
    private final String EMPTY_STRING = "";
    protected MessageGenerator messagegenerator;

    public SOAPValidator() {
        ResourceBundle rb = ResourceBundle.getBundle(SOAP_RESOURCE_BUNDLE_NAME, Locale.getDefault());
        this.messagegenerator = new MessageGenerator(rb);
    }

    public void validate(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        if (parents.get(0).getClass() == PortImpl.class) {
            if (element.getClass() == SOAPAddressImpl.class) {
                this.validateAddress(element, parents, valInfo);
            } else {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_PORT_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            }
        } else if (parents.get(0).getClass() == BindingImpl.class) {
            if (element.getClass() == SOAPBindingImpl.class) {
                this.validateBinding(element, parents, valInfo);
            } else {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            }
        } else if (parents.get(0).getClass() == BindingOperationImpl.class) {
            if (element.getClass() == SOAPOperationImpl.class) {
                this.validateOperation(element, parents, valInfo);
            } else {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_OPERATION_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            }
        } else if (parents.get(0).getClass() == BindingInputImpl.class || parents.get(0).getClass() == BindingOutputImpl.class) {
            if (element.getClass() == SOAPBodyImpl.class) {
                this.validateBody(element, parents, valInfo);
            } else if (element.getClass() == SOAPHeaderImpl.class) {
                this.validateHeader(element, parents, valInfo);
            } else {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_HEADER_BODY_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            }
        } else if (parents.get(0).getClass() == BindingFaultImpl.class) {
            if (element.getClass() == SOAPFaultImpl.class) {
                this.validateFault(element, parents, valInfo);
            } else {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_FAULT_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            }
        } else {
            ExtensibilityElement e = (ExtensibilityElement)element;
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_SOAP_ELEMENT_FOR_LOCATION", "'" + e.getElementType().getLocalPart() + "'"), element);
        }
    }

    protected void validateAddress(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Port port;
        Binding binding;
        SOAPAddressImpl sa = (SOAPAddressImpl)element;
        String uri = sa.getLocationURI();
        if (uri == null || uri.equalsIgnoreCase("")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_LOCATION_FOR_ADDRESS"), sa);
        }
        if (!this.hasSoapBinding(binding = (port = (Port)parents.get(0)).getBinding())) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_SOAPBINDING_FOR_ADDRESS", "'" + binding.getQName().getLocalPart() + "'", "'" + port.getName() + "'"), sa);
        }
    }

    protected void validateBinding(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        SOAPBindingImpl sb = (SOAPBindingImpl)element;
        String style = sb.getStyle();
        String uri = sb.getTransportURI();
        if (style != null && !style.equalsIgnoreCase("rpc") && !style.equalsIgnoreCase("document")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_STYLE", "'" + sb.getStyle() + "'"), element);
        }
        if (uri.equalsIgnoreCase("")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_URI"), element);
        }
    }

    protected void validateOperation(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Binding binding;
        SOAPOperation so = (SOAPOperation)element;
        String soapStyle = so.getStyle();
        if (soapStyle != null && !soapStyle.equalsIgnoreCase("rpc") && !soapStyle.equalsIgnoreCase("document")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_OPERATION_STYLE"), element);
        }
        if (!this.hasSoapBinding(binding = (Binding)parents.get(1))) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_SOAPBINDING_FOR_OPERATION", "'" + binding.getQName().getLocalPart() + "'"), so);
        }
    }

    protected void validateBody(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Binding binding;
        SOAPBodyImpl sb = (SOAPBodyImpl)element;
        String use = sb.getUse();
        if (use != null && use.equalsIgnoreCase("encoded")) {
            List encodingStyles = sb.getEncodingStyles();
            if (encodingStyles == null || encodingStyles.size() == 0) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_ENCODING_STYLE"), sb);
            }
        } else if (use != null && !use.equalsIgnoreCase("literal")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_USE", "'" + use + "'"), sb);
        }
        List parts = sb.getParts();
        if (parts != null) {
            for (String part : parts) {
                BindingOperation bo = (BindingOperation)parents.get(1);
                Operation o = bo.getOperation();
                if (o != null && !o.isUndefined()) {
                    Output output;
                    Message mess = null;
                    if (parents.get(0).getClass() == BindingInputImpl.class) {
                        Input input = o.getInput();
                        if (input != null) {
                            mess = input.getMessage();
                        }
                    } else if (parents.get(0).getClass() == BindingOutputImpl.class && (output = o.getOutput()) != null) {
                        mess = output.getMessage();
                    }
                    if (mess != null && !mess.isUndefined()) {
                        Part p = mess.getPart(part);
                        if (p != null) {
                            if (use == null || !use.equalsIgnoreCase("encoded") || p.getTypeName() != null) continue;
                            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_PART_NOT_TYPE", "'" + part + "'"), sb);
                            continue;
                        }
                        valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_PART_UNDEFINED", "'" + part + "'"), sb);
                        continue;
                    }
                    valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_PART_UNDEFINED", "'" + part + "'"), sb);
                    continue;
                }
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_PART_UNDEFINED", "'" + part + "'"), sb);
            }
        }
        if (!this.hasSoapBinding(binding = (Binding)parents.get(2))) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_SOAPBINDING_FOR_BODY", "'" + binding.getQName().getLocalPart() + "'"), sb);
        }
    }

    protected void validateHeader(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Binding binding;
        List headerFaults;
        SOAPHeaderImpl soapHeader = (SOAPHeaderImpl)element;
        QName messageQName = soapHeader.getMessage();
        Message message = ((Definition)parents.get(parents.size() - 1)).getMessage(messageQName);
        if (message == null) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_HEADER_MESSAGE_UNDEFINED", "'" + messageQName.getLocalPart() + "'"), soapHeader);
        } else {
            String partname = soapHeader.getPart();
            Part part = message.getPart(partname);
            if (part == null) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADER_PART_UNDEFINED", "'" + partname + "'", "'" + messageQName.getLocalPart() + "'"), soapHeader);
            }
        }
        String use = soapHeader.getUse();
        if (use != null && !use.equalsIgnoreCase("literal") && !use.equalsIgnoreCase("encoded")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_HEADER_USE_UNDEFINED", "'" + use + "'"), soapHeader);
        }
        if (use.equalsIgnoreCase("encoded")) {
            String namespace;
            List encodingStyles = soapHeader.getEncodingStyles();
            if (encodingStyles == null || encodingStyles.isEmpty()) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADER_ENCODINGSTYLE_UNDEFINED"), soapHeader);
            }
            if ((namespace = soapHeader.getNamespaceURI()) == null || namespace.equalsIgnoreCase("")) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADER_NAMESPACE_UNDEFINED"), soapHeader);
            }
        }
        if ((headerFaults = soapHeader.getSOAPHeaderFaults()) != null) {
            Iterator iheaderFaults = headerFaults.iterator();
            while (iheaderFaults.hasNext()) {
                this.validateHeaderFault(iheaderFaults.next(), parents, valInfo);
            }
        }
        if (!this.hasSoapBinding(binding = (Binding)parents.get(2))) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_SOAPBINDING_FOR_HEADER", "'" + binding.getQName().getLocalPart() + "'"), soapHeader);
        }
    }

    protected void validateHeaderFault(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        SOAPHeaderFaultImpl soapHeaderFault = (SOAPHeaderFaultImpl)element;
        QName messageQName = soapHeaderFault.getMessage();
        Message message = ((Definition)parents.get(parents.size() - 1)).getMessage(messageQName);
        if (message == null) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_HEADERFAULT_MESSAGE_UNDEFINED", "'" + messageQName.getLocalPart() + "'"), soapHeaderFault);
        } else {
            String partname = soapHeaderFault.getPart();
            Part part = message.getPart(partname);
            if (part == null) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADERFAULT_PART_UNDEFINED", "'" + partname + "'", "'" + messageQName.getLocalPart() + "'"), soapHeaderFault);
            }
        }
        String use = soapHeaderFault.getUse();
        if (use != null && !use.equalsIgnoreCase("literal") && !use.equalsIgnoreCase("encoded")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_HEADERFAULT_USE_UNDEFINED", "'" + use + "'"), soapHeaderFault);
        }
        if (use.equalsIgnoreCase("encoded")) {
            String namespace;
            List encodingStyles = soapHeaderFault.getEncodingStyles();
            if (encodingStyles == null || encodingStyles.isEmpty()) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADERFAULT_ENCODINGSTYLE_UNDEFINED"), soapHeaderFault);
            }
            if ((namespace = soapHeaderFault.getNamespaceURI()) == null || namespace.equalsIgnoreCase("")) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADERFAULT_NAMESPACE_UNDEFINED"), soapHeaderFault);
            }
        }
    }

    protected void validateFault(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        String parentName;
        SOAPFaultImpl fault = (SOAPFaultImpl)element;
        String name = fault.getName();
        if (!name.equals(parentName = ((BindingFault)parents.get(0)).getName())) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_FAULT_NAME", "'" + name + "'", "'" + parentName + "'"), fault);
        }
    }

    protected boolean hasSoapBinding(Binding binding) {
        List extelems;
        if (binding != null && (extelems = binding.getExtensibilityElements()) != null) {
            Iterator iextelems = extelems.iterator();
            while (iextelems.hasNext()) {
                if (iextelems.next().getClass() != SOAPBindingImpl.class) continue;
                return true;
            }
        }
        return false;
    }
}

