/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.validation.internal.IValidationSelectionHandler;

public class ValidationSelectionHandlerRegistryReader
extends RegistryReader {
    public static final String VALIDATION_SELECTION_HANDLER = "validationSelectionHandler";
    static final String ATT_ID = "id";
    static final String ATT_HANDLER_CLASS = "handlerClass";
    static final String ATT_SELECTION_TYPE = "selectionType";
    private static ValidationSelectionHandlerRegistryReader INSTANCE;
    private List validationSelectionHandlers;

    public ValidationSelectionHandlerRegistryReader() {
        super("org.eclipse.wst.validation", VALIDATION_SELECTION_HANDLER);
    }

    public static ValidationSelectionHandlerRegistryReader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ValidationSelectionHandlerRegistryReader();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(VALIDATION_SELECTION_HANDLER)) {
            return false;
        }
        String selectionType = element.getAttribute(ATT_SELECTION_TYPE);
        IValidationSelectionHandler handler = null;
        try {
            handler = (IValidationSelectionHandler)element.createExecutableExtension(ATT_HANDLER_CLASS);
            handler.setValidationTypeString(selectionType);
            this.getValidationSelectionHandlers().add(handler);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private List getValidationSelectionHandlers() {
        if (this.validationSelectionHandlers == null) {
            this.validationSelectionHandlers = new ArrayList();
        }
        return this.validationSelectionHandlers;
    }

    public Object getExtendedType(Object selection) {
        IResource result = null;
        int i = 0;
        while (i < this.getValidationSelectionHandlers().size()) {
            IValidationSelectionHandler handler = (IValidationSelectionHandler)this.getValidationSelectionHandlers().get(i);
            result = handler.getBaseValidationType(selection);
            if (result != null) break;
            ++i;
        }
        return result;
    }
}

