/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BufferedTokenStream;

public class CommonGramsFilter
extends BufferedTokenStream {
    private static final char SEPARATOR = '_';
    private final CharArraySet commonWords;
    private StringBuilder buffer = new StringBuilder();

    public CommonGramsFilter(TokenStream input, Set commonWords) {
        this(input, commonWords, false);
    }

    public CommonGramsFilter(TokenStream input, Set commonWords, boolean ignoreCase) {
        super(input);
        if (commonWords instanceof CharArraySet) {
            this.commonWords = (CharArraySet)commonWords;
        } else {
            this.commonWords = new CharArraySet(commonWords.size(), ignoreCase);
            this.commonWords.addAll(commonWords);
        }
        this.init();
    }

    public CommonGramsFilter(TokenStream input, String[] commonWords) {
        this(input, commonWords, false);
        this.init();
    }

    public CommonGramsFilter(TokenStream input, String[] commonWords, boolean ignoreCase) {
        super(input);
        this.commonWords = CommonGramsFilter.makeCommonSet(commonWords, ignoreCase);
        this.init();
    }

    public void init() {
    }

    public static final CharArraySet makeCommonSet(String[] commonWords) {
        return CommonGramsFilter.makeCommonSet(commonWords, false);
    }

    public static final CharArraySet makeCommonSet(String[] commonWords, boolean ignoreCase) {
        CharArraySet commonSet = new CharArraySet(commonWords.length, ignoreCase);
        commonSet.addAll(Arrays.asList(commonWords));
        return commonSet;
    }

    public Token process(Token token) throws IOException {
        Token next = this.peek(1);
        if (next == null) {
            return token;
        }
        if (this.isCommon(token) || this.isCommon(next)) {
            Token gram = this.gramToken(token, next);
            this.write(gram);
        }
        return token;
    }

    private boolean isCommon(Token token) {
        return this.commonWords != null && this.commonWords.contains(token.termBuffer(), 0, token.termLength());
    }

    private Token gramToken(Token first, Token second) {
        this.buffer.setLength(0);
        this.buffer.append(first.termText());
        this.buffer.append('_');
        this.buffer.append(second.termText());
        Token result = new Token(this.buffer.toString(), first.startOffset(), second.endOffset(), "gram");
        result.setPositionIncrement(0);
        return result;
    }

    public void reset() throws IOException {
        super.reset();
        this.buffer.setLength(0);
    }
}

