/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.solr.SolrClient;

public class AsyncIndexer
implements Runnable {
    private static Log log = LogFactory.getLog(AsyncIndexer.class);
    private final SolrClient client;
    private LinkedBlockingQueue<File2Index> queue = new LinkedBlockingQueue();

    public void addFile(File2Index file2Index) {
        this.queue.offer(file2Index);
    }

    protected AsyncIndexer() throws RegistryException {
        try {
            this.client = SolrClient.getInstance();
        }
        catch (IndexerException e) {
            throw new RegistryException("Error initializing Async Indexer " + e.getMessage(), (Throwable)e);
        }
    }

    public SolrClient getClient() {
        return this.client;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                File2Index fileData = this.queue.take();
                Indexer indexer = IndexingManager.getInstance().getIndexerForMediaType(fileData.mediaType);
                try {
                    this.getClient().indexDocument(fileData, indexer);
                }
                catch (Exception e) {
                    log.warn((Object)("Could not index the resource: path=" + fileData.path + ", media type=" + fileData.mediaType));
                }
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    return;
                }
                log.error((Object)"Error while indexing.", e);
            }
        }
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    public static class File2Index {
        public byte[] data;
        public String mediaType;
        public String path;
        public int tenantId;

        public File2Index(byte[] data, String mediaType, String path, int tenantId) {
            this.data = data;
            this.mediaType = mediaType;
            this.path = path;
            this.tenantId = tenantId;
        }
    }
}

