/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.utils.IndexingUtils;

public class ResourceSubmitter
implements Runnable {
    private static Log log = LogFactory.getLog(ResourceSubmitter.class);
    private IndexingManager indexingManager;

    protected ResourceSubmitter(IndexingManager indexingManager) {
        this.indexingManager = indexingManager;
    }

    @Override
    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"})
    public void run() {
        try {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            UserRegistry registry = this.indexingManager.getRegistry();
            String lastAccessTimeLocation = this.indexingManager.getLastAccessTimeLocation();
            LogEntry[] entries = registry.getLogs(null, -1, null, this.indexingManager.getLastAccessTime(), new Date(), false);
            Arrays.sort(entries, new Comparator<LogEntry>(){

                @Override
                public int compare(LogEntry o1, LogEntry o2) {
                    return o1.getDate().compareTo(o2.getDate());
                }
            });
            Date currentTime = entries.length > 0 ? entries[entries.length - 1].getDate() : this.indexingManager.getLastAccessTime();
            for (LogEntry logEntry : entries) {
                String path = logEntry.getResourcePath();
                try {
                    Resource resourceToIndex;
                    if (path.equals(lastAccessTimeLocation)) continue;
                    if (logEntry.getAction() == 7) {
                        this.indexingManager.deleteFromIndex(logEntry.getResourcePath(), -1234);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Resource Deleted: Resource at " + path + " will be deleted from Indexing Server"));
                        continue;
                    }
                    if (!this.indexingManager.canIndex(path) || !IndexingUtils.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get") || !registry.resourceExists(path) || !this.indexingManager.isIndexable(resourceToIndex = registry.get(path))) continue;
                    if (logEntry.getAction() == 1) {
                        this.indexingManager.submitFileForIndexing(resourceToIndex, path, null);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Resource Updated: Resource at " + path + " has been submitted to the Indexing Server"));
                        continue;
                    }
                    if (logEntry.getAction() == 0) {
                        this.indexingManager.submitFileForIndexing(resourceToIndex, path, null);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Resource Inserted: Resource at " + path + " has been submitted to the Indexing Server"));
                        continue;
                    }
                    if (logEntry.getAction() == 10) {
                        this.indexingManager.submitFileForIndexing(resourceToIndex, path, null);
                        this.indexingManager.deleteFromIndex(logEntry.getActionData(), -1234);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Resource Moved: Resource at " + path + " has been submitted to the Indexing Server"));
                        continue;
                    }
                    if (logEntry.getAction() != 11) continue;
                    path = logEntry.getActionData();
                    this.indexingManager.submitFileForIndexing(resourceToIndex, path, null);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Resource Copied : Resource at " + path + " has been submitted to the Indexing Server"));
                }
                catch (Exception e) {
                    log.warn((Object)("An error occurred while submitting the resource for indexing, path: " + path), (Throwable)e);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("last successfully indexed activity time is : " + this.indexingManager.getLastAccessTime().toString()));
            }
            this.indexingManager.setLastAccessTime(currentTime);
        }
        catch (Throwable e) {
            log.warn((Object)"An error occurred while submitting resources for indexing", e);
        }
    }
}

