/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.FieldFacetStats;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.request.NumberedTermEnum;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.TermIndex;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.BoundedTreeSet;

public class UnInvertedField {
    private static int TNUM_OFFSET = 2;
    String field;
    int numTermsInField;
    int termsInverted;
    long termInstances;
    final TermIndex ti;
    long memsz;
    int total_time;
    int phase1_time;
    final AtomicLong use = new AtomicLong();
    int[] index;
    byte[][] tnums = new byte[256][];
    int[] maxTermCounts;
    final Map<Integer, TopTerm> bigTerms = new LinkedHashMap<Integer, TopTerm>();

    public long memSize() {
        if (this.memsz != 0L) {
            return this.memsz;
        }
        long sz = 96L;
        sz += (long)(this.bigTerms.size() * 64);
        for (TopTerm tt : this.bigTerms.values()) {
            sz += tt.memSize();
        }
        if (this.index != null) {
            sz += (long)(this.index.length * 4);
        }
        if (this.tnums != null) {
            for (byte[] arr : this.tnums) {
                if (arr == null) continue;
                sz += (long)arr.length;
            }
        }
        if (this.maxTermCounts != null) {
            sz += (long)(this.maxTermCounts.length * 4);
        }
        this.memsz = sz += this.ti.memSize();
        return sz;
    }

    static int vIntSize(int x) {
        if ((x & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((x & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((x & 0xFFE00000) == 0) {
            return 3;
        }
        if ((x & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    static int writeInt(int x, byte[] arr, int pos) {
        int a = x >>> 28;
        if (a != 0) {
            arr[pos++] = (byte)(a | 0x80);
        }
        if ((a = x >>> 21) != 0) {
            arr[pos++] = (byte)(a | 0x80);
        }
        if ((a = x >>> 14) != 0) {
            arr[pos++] = (byte)(a | 0x80);
        }
        if ((a = x >>> 7) != 0) {
            arr[pos++] = (byte)(a | 0x80);
        }
        arr[pos++] = (byte)(x & 0x7F);
        return pos;
    }

    public UnInvertedField(String field, SolrIndexSearcher searcher) throws IOException {
        this.field = field;
        this.ti = new TermIndex(field, TrieField.getMainValuePrefix(searcher.getSchema().getFieldType(field)));
        this.uninvert(searcher);
    }

    private void uninvert(SolrIndexSearcher searcher) throws IOException {
        int val;
        Term t;
        long startTime = System.currentTimeMillis();
        SolrIndexReader reader = searcher.getReader();
        int maxDoc = ((IndexReader)reader).maxDoc();
        int[] index = new int[maxDoc];
        this.index = index;
        int[] lastTerm = new int[maxDoc];
        byte[][] bytes = new byte[maxDoc][];
        this.maxTermCounts = new int[1024];
        NumberedTermEnum te = this.ti.getEnumerator(reader);
        int threshold = maxDoc / 20 + 2;
        int[] docs = new int[1000];
        int[] freqs = new int[1000];
        byte[] tempArr = new byte[12];
        while ((t = te.term()) != null) {
            int n;
            int df;
            int termNum = te.getTermNumber();
            if (termNum >= this.maxTermCounts.length) {
                int[] newMaxTermCounts = new int[this.maxTermCounts.length * 2];
                System.arraycopy(this.maxTermCounts, 0, newMaxTermCounts, 0, termNum);
                this.maxTermCounts = newMaxTermCounts;
            }
            if ((df = te.docFreq()) >= threshold) {
                TopTerm topTerm = new TopTerm();
                topTerm.term = t;
                topTerm.termNum = termNum;
                this.bigTerms.put(topTerm.termNum, topTerm);
                DocSet set = searcher.getDocSet(new TermQuery(topTerm.term));
                this.maxTermCounts[termNum] = set.size();
                te.next();
                continue;
            }
            ++this.termsInverted;
            TermDocs td = te.getTermDocs();
            td.seek(te);
            while ((n = td.read(docs, freqs)) > 0) {
                int n2 = termNum;
                this.maxTermCounts[n2] = this.maxTermCounts[n2] + n;
                for (int i = 0; i < n; ++i) {
                    ++this.termInstances;
                    int doc = docs[i];
                    int delta = termNum - lastTerm[doc] + TNUM_OFFSET;
                    lastTerm[doc] = termNum;
                    val = index[doc];
                    if ((val & 0xFF) == 1) {
                        byte[] arr;
                        int pos = val >>> 8;
                        int ilen = UnInvertedField.vIntSize(delta);
                        int newend = pos + ilen;
                        if (newend > (arr = bytes[doc]).length) {
                            int newLen = newend + 3 & 0xFFFFFFFC;
                            byte[] newarr = new byte[newLen];
                            System.arraycopy(arr, 0, newarr, 0, pos);
                            arr = newarr;
                            bytes[doc] = newarr;
                        }
                        pos = UnInvertedField.writeInt(delta, arr, pos);
                        index[doc] = pos << 8 | 1;
                        continue;
                    }
                    int ipos = val == 0 ? 0 : ((val & 0xFF80) == 0 ? 1 : ((val & 0xFF8000) == 0 ? 2 : ((val & 0xFF800000) == 0 ? 3 : 4)));
                    int endPos = UnInvertedField.writeInt(delta, tempArr, ipos);
                    if (endPos <= 4) {
                        for (int j = ipos; j < endPos; ++j) {
                            val |= (tempArr[j] & 0xFF) << (j << 3);
                        }
                        index[doc] = val;
                        continue;
                    }
                    for (int j = 0; j < ipos; ++j) {
                        tempArr[j] = (byte)val;
                        val >>>= 8;
                    }
                    index[doc] = endPos << 8 | 1;
                    bytes[doc] = tempArr;
                    tempArr = new byte[12];
                }
            }
            te.next();
        }
        this.numTermsInField = te.getTermNumber();
        te.close();
        if (this.maxTermCounts.length - this.numTermsInField > 1024) {
            int[] newMaxTermCounts = new int[this.numTermsInField];
            System.arraycopy(this.maxTermCounts, 0, newMaxTermCounts, 0, this.numTermsInField);
            this.maxTermCounts = newMaxTermCounts;
        }
        long midPoint = System.currentTimeMillis();
        if (this.termInstances == 0L) {
            this.index = null;
            index = null;
            this.tnums = null;
        } else {
            for (int pass = 0; pass < 256; ++pass) {
                byte[] target = this.tnums[pass];
                int pos = 0;
                if (target != null) {
                    pos = target.length;
                } else {
                    target = new byte[4096];
                }
                for (int docbase = pass << 16; docbase < maxDoc; docbase += 0x1000000) {
                    int lim = Math.min(docbase + 65536, maxDoc);
                    for (int doc = docbase; doc < lim; ++doc) {
                        val = index[doc];
                        if ((val & 0xFF) != 1) continue;
                        int len = val >>> 8;
                        index[doc] = pos << 8 | 1;
                        if ((pos & 0xFF000000) != 0) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Too many values for UnInvertedField faceting on field " + this.field);
                        }
                        byte[] arr = bytes[doc];
                        bytes[doc] = null;
                        if (target.length <= pos + len) {
                            int newlen;
                            for (newlen = target.length; newlen <= pos + len; newlen <<= 1) {
                            }
                            byte[] newtarget = new byte[newlen];
                            System.arraycopy(target, 0, newtarget, 0, pos);
                            target = newtarget;
                        }
                        System.arraycopy(arr, 0, target, pos, len);
                        pos += len + 1;
                    }
                }
                if (pos < target.length) {
                    byte[] newtarget = new byte[pos];
                    System.arraycopy(target, 0, newtarget, 0, pos);
                    target = newtarget;
                    if ((double)target.length > 1.50994944E7) {
                        SolrCore.log.warn("Approaching too many values for UnInvertedField faceting on field '" + this.field + "' : bucket size=" + target.length);
                    }
                }
                this.tnums[pass] = target;
                if (pass << 16 > maxDoc) break;
            }
        }
        long endTime = System.currentTimeMillis();
        this.total_time = (int)(endTime - startTime);
        this.phase1_time = (int)(midPoint - startTime);
        SolrCore.log.info("UnInverted multi-valued field " + this.toString());
    }

    public NamedList getCounts(SolrIndexSearcher searcher, DocSet baseDocs, int offset, int limit, Integer mincount, boolean missing, String sort, String prefix) throws IOException {
        this.use.incrementAndGet();
        FieldType ft = searcher.getSchema().getFieldType(this.field);
        NamedList<Integer> res = new NamedList<Integer>();
        DocSet docs = baseDocs;
        int baseSize = docs.size();
        int maxDoc = searcher.maxDoc();
        if (baseSize >= mincount) {
            int lim;
            boolean doNegative;
            int[] index = this.index;
            int[] counts = new int[this.numTermsInField];
            int startTerm = 0;
            int endTerm = this.numTermsInField;
            NumberedTermEnum te = this.ti.getEnumerator(searcher.getReader());
            if (prefix != null && prefix.length() > 0) {
                te.skipTo(prefix);
                startTerm = te.getTermNumber();
                te.skipTo(prefix + "\uffff\uffff\uffff\uffff");
                endTerm = te.getTermNumber();
            }
            boolean bl = doNegative = baseSize > maxDoc >> 1 && this.termInstances > 0L && startTerm == 0 && endTerm == this.numTermsInField && docs instanceof BitDocSet;
            if (doNegative) {
                OpenBitSet bs = (OpenBitSet)((BitDocSet)docs).getBits().clone();
                bs.flip(0L, maxDoc);
                docs = new BitDocSet(bs, maxDoc - baseSize);
            }
            for (TopTerm tt : this.bigTerms.values()) {
                if (tt.termNum < startTerm || tt.termNum >= endTerm) continue;
                counts[tt.termNum] = searcher.numDocs((Query)new TermQuery(tt.term), docs);
            }
            if (this.termInstances > 0L) {
                DocIterator iter = docs.iterator();
                block1: while (iter.hasNext()) {
                    int doc = iter.nextDoc();
                    int code = index[doc];
                    if ((code & 0xFF) == 1) {
                        int pos = code >>> 8;
                        int whichArray = doc >>> 16 & 0xFF;
                        byte[] arr = this.tnums[whichArray];
                        int tnum = 0;
                        while (true) {
                            byte b;
                            int delta = 0;
                            do {
                                b = arr[pos++];
                                delta = delta << 7 | b & 0x7F;
                            } while ((b & 0x80) != 0);
                            if (delta == 0) continue block1;
                            int n = tnum += delta - TNUM_OFFSET;
                            counts[n] = counts[n] + 1;
                        }
                    }
                    int tnum = 0;
                    int delta = 0;
                    while (true) {
                        delta = delta << 7 | code & 0x7F;
                        if ((code & 0x80) == 0) {
                            if (delta == 0) continue block1;
                            int n = tnum += delta - TNUM_OFFSET;
                            counts[n] = counts[n] + 1;
                            delta = 0;
                        }
                        code >>>= 8;
                    }
                }
            }
            int off = offset;
            int n = lim = limit >= 0 ? limit : Integer.MAX_VALUE;
            if (sort.equals("count") || sort.equals("true")) {
                int maxsize = limit > 0 ? offset + limit : 0x7FFFFFFE;
                maxsize = Math.min(maxsize, this.numTermsInField);
                BoundedTreeSet<Long> queue = new BoundedTreeSet<Long>(maxsize);
                int min = mincount - 1;
                for (int i = startTerm; i < endTerm; ++i) {
                    int c;
                    int n2 = c = doNegative ? this.maxTermCounts[i] - counts[i] : counts[i];
                    if (c <= min) continue;
                    long pair = (long)(-c) << 32 | (long)i;
                    queue.add(new Long(pair));
                    if (queue.size() < maxsize) continue;
                    min = -((int)((Long)queue.last() >>> 32));
                }
                for (Long p : queue) {
                    if (--off >= 0) continue;
                    if (--lim >= 0) {
                        int c = -((int)(p >>> 32));
                        int tnum = (int)p.longValue();
                        String label = ft.indexedToReadable(this.getTermText(te, tnum));
                        res.add(label, c);
                        continue;
                    }
                    break;
                }
            } else {
                int i = startTerm;
                if (mincount <= 0) {
                    i = startTerm + off;
                    off = 0;
                }
                while (i < endTerm) {
                    int c;
                    int n3 = c = doNegative ? this.maxTermCounts[i] - counts[i] : counts[i];
                    if (c >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        String label = ft.indexedToReadable(this.getTermText(te, i));
                        res.add(label, c);
                    }
                    ++i;
                }
            }
            te.close();
        }
        if (missing) {
            res.add(null, SimpleFacets.getFieldMissingCount(searcher, baseDocs, this.field));
        }
        return res;
    }

    public StatsValues getStats(SolrIndexSearcher searcher, DocSet baseDocs, String[] facet) throws IOException {
        this.use.incrementAndGet();
        StatsValues allstats = new StatsValues();
        DocSet docs = baseDocs;
        int baseSize = docs.size();
        int maxDoc = searcher.maxDoc();
        if (baseSize <= 0) {
            return allstats;
        }
        FieldType ft = searcher.getSchema().getFieldType(this.field);
        DocSet missing = docs.andNot(searcher.getDocSet(new TermRangeQuery(this.field, null, null, false, false)));
        int i = 0;
        FieldFacetStats[] finfo = new FieldFacetStats[facet.length];
        for (String f : facet) {
            FieldCache.StringIndex si;
            FieldType facet_ft = searcher.getSchema().getFieldType(f);
            try {
                si = FieldCache.DEFAULT.getStringIndex(searcher.getReader(), f);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to open field cache for: " + f, e);
            }
            finfo[i] = new FieldFacetStats(f, si, facet_ft, this.numTermsInField);
            ++i;
        }
        int[] index = this.index;
        int[] counts = new int[this.numTermsInField];
        NumberedTermEnum te = this.ti.getEnumerator(searcher.getReader());
        boolean doNegative = false;
        if (finfo.length == 0) {
            boolean bl = doNegative = baseSize > maxDoc >> 1 && this.termInstances > 0L && docs instanceof BitDocSet;
        }
        if (doNegative) {
            OpenBitSet bs = (OpenBitSet)((BitDocSet)docs).getBits().clone();
            bs.flip(0L, maxDoc);
            docs = new BitDocSet(bs, maxDoc - baseSize);
        }
        for (TopTerm tt : this.bigTerms.values()) {
            if (tt.termNum < 0 || tt.termNum >= this.numTermsInField) continue;
            if (finfo.length == 0) {
                counts[tt.termNum] = searcher.numDocs((Query)new TermQuery(tt.term), docs);
                continue;
            }
            DocSet bigTermDocSet = searcher.getDocSet(new TermQuery(tt.term)).intersection(docs);
            DocIterator iter = bigTermDocSet.iterator();
            while (iter.hasNext()) {
                int doc = iter.nextDoc();
                int n = tt.termNum;
                counts[n] = counts[n] + 1;
                for (FieldFacetStats f : finfo) {
                    f.facetTermNum(doc, tt.termNum);
                }
            }
        }
        if (this.termInstances > 0L) {
            DocIterator iter = docs.iterator();
            block6: while (iter.hasNext()) {
                int doc = iter.nextDoc();
                int code = index[doc];
                if ((code & 0xFF) == 1) {
                    int pos = code >>> 8;
                    int whichArray = doc >>> 16 & 0xFF;
                    byte[] arr = this.tnums[whichArray];
                    int tnum = 0;
                    block7: while (true) {
                        byte b;
                        int delta = 0;
                        do {
                            b = arr[pos++];
                            delta = delta << 7 | b & 0x7F;
                        } while ((b & 0x80) != 0);
                        if (delta == 0) continue block6;
                        int n = tnum += delta - TNUM_OFFSET;
                        counts[n] = counts[n] + 1;
                        FieldFacetStats[] arr$ = finfo;
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (true) {
                            if (i$ >= len$) continue block7;
                            FieldFacetStats f = arr$[i$];
                            f.facetTermNum(doc, tnum);
                            ++i$;
                        }
                        break;
                    }
                }
                int tnum = 0;
                int delta = 0;
                while (true) {
                    delta = delta << 7 | code & 0x7F;
                    if ((code & 0x80) == 0) {
                        if (delta == 0) continue block6;
                        int n = tnum += delta - TNUM_OFFSET;
                        counts[n] = counts[n] + 1;
                        for (FieldFacetStats f : finfo) {
                            f.facetTermNum(doc, tnum);
                        }
                        delta = 0;
                    }
                    code >>>= 8;
                }
            }
        }
        for (i = 0; i < this.numTermsInField; ++i) {
            int c;
            int n = c = doNegative ? this.maxTermCounts[i] - counts[i] : counts[i];
            if (c == 0) continue;
            Double value = Double.parseDouble(ft.indexedToReadable(this.getTermText(te, i)));
            allstats.accumulate(value, c);
            for (FieldFacetStats f : finfo) {
                f.accumulateTermNum(i, value);
            }
        }
        te.close();
        int c = missing.size();
        allstats.addMissing(c);
        if (finfo.length > 0) {
            allstats.facets = new HashMap<String, Map<String, StatsValues>>();
            for (FieldFacetStats f : finfo) {
                Map<String, StatsValues> facetStatsValues = f.facetStatsValues;
                FieldType facetType = searcher.getSchema().getFieldType(f.name);
                for (Map.Entry<String, StatsValues> entry : facetStatsValues.entrySet()) {
                    String termLabel = entry.getKey();
                    int missingCount = searcher.numDocs((Query)new TermQuery(new Term(f.name, facetType.toInternal(termLabel))), missing);
                    entry.getValue().addMissing(missingCount);
                }
                allstats.facets.put(f.name, facetStatsValues);
            }
        }
        return allstats;
    }

    String getTermText(NumberedTermEnum te, int termNum) throws IOException {
        TopTerm tt;
        if (this.bigTerms.size() > 0 && (tt = this.bigTerms.get(termNum)) != null) {
            return tt.term.text();
        }
        te.skipTo(termNum);
        return te.term().text();
    }

    public String toString() {
        return "{field=" + this.field + ",memSize=" + this.memSize() + ",tindexSize=" + this.ti.memSize() + ",time=" + this.total_time + ",phase1=" + this.phase1_time + ",nTerms=" + this.numTermsInField + ",bigTerms=" + this.bigTerms.size() + ",termInstances=" + this.termInstances + ",uses=" + this.use.get() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnInvertedField getUnInvertedField(String field, SolrIndexSearcher searcher) throws IOException {
        SolrCache cache = searcher.getFieldValueCache();
        if (cache == null) {
            return new UnInvertedField(field, searcher);
        }
        UnInvertedField uif = (UnInvertedField)cache.get(field);
        if (uif == null) {
            SolrCache solrCache = cache;
            synchronized (solrCache) {
                uif = (UnInvertedField)cache.get(field);
                if (uif == null) {
                    uif = new UnInvertedField(field, searcher);
                    cache.put(field, uif);
                }
            }
        }
        return uif;
    }

    static class TopTerm {
        Term term;
        int termNum;

        TopTerm() {
        }

        long memSize() {
            return 24 + (this.term.text().length() << 1) + 4;
        }
    }
}

