/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.info.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.IInfoService;
import org.wso2.carbon.registry.common.beans.CommentBean;
import org.wso2.carbon.registry.common.beans.RatingBean;
import org.wso2.carbon.registry.common.beans.utils.Comment;
import org.wso2.carbon.registry.common.beans.utils.EventType;
import org.wso2.carbon.registry.common.beans.utils.SubscriptionInstance;
import org.wso2.carbon.registry.common.beans.utils.Tag;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.registry.info.stub.InfoAdminServiceStub;
import org.wso2.carbon.registry.info.stub.beans.xsd.EventTypeBean;
import org.wso2.carbon.registry.info.stub.beans.xsd.SubscriptionBean;
import org.wso2.carbon.registry.info.stub.beans.xsd.TagBean;
import org.wso2.carbon.registry.info.ui.Utils;
import org.wso2.carbon.ui.CarbonUIUtil;

public class InfoServiceClient
implements IInfoService {
    private static final Log log = LogFactory.getLog(InfoServiceClient.class);
    private InfoAdminServiceStub stub;
    private IInfoService proxy;

    public InfoServiceClient(String cookie, ServletConfig config, HttpSession session) throws RegistryException {
        if (this.proxy == null) {
            String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
            ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
            String epr = backendServerURL + "InfoAdminService";
            try {
                this.stub = new InfoAdminServiceStub(configContext, epr);
                ServiceClient client = this.stub._getServiceClient();
                Options option = client.getOptions();
                option.setManageSession(true);
                option.setProperty("Cookie", (Object)cookie);
            }
            catch (AxisFault axisFault) {
                String msg = "Failed to initiate comment service client. " + axisFault.getMessage();
                log.error((Object)msg, (Throwable)axisFault);
                throw new RegistryException(msg, (Throwable)axisFault);
            }
            this.proxy = this;
        }
    }

    public void setSession(String sessionId, HttpSession session) {
    }

    public void removeSession(String sessionId) {
    }

    public CommentBean getComments(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        try {
            return (CommentBean)this.proxy.getComments(path, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to get comments from the comment service.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public void addComment(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        String comment = (String)Utils.getParameter(request, "comment");
        try {
            this.proxy.addComment(comment, path, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to get comments from the comment service.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public void removeComment(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String mountedPath = this.getMountedCommentPath(request);
        try {
            this.proxy.removeComment(mountedPath, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to remove the comment.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    private String getMountedCommentPath(HttpServletRequest request) {
        String commentPath = (String)Utils.getParameter(request, "commentpath");
        String path = (String)Utils.getParameter(request, "path");
        String[] commentParts = commentPath.split(";");
        return path + ";" + commentParts[1];
    }

    public org.wso2.carbon.registry.common.beans.TagBean getTags(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        try {
            return (org.wso2.carbon.registry.common.beans.TagBean)this.proxy.getTags(path, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to get comments from the comment service.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public void addTag(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        String tag = (String)Utils.getParameter(request, "tag");
        try {
            this.proxy.addTag(tag, path, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to add the tag.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public void removeTag(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        String tag = (String)Utils.getParameter(request, "tag");
        try {
            this.proxy.removeTag(tag, path, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to remove the tag.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public RatingBean getRatings(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        try {
            return (RatingBean)this.proxy.getRatings(path, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to get ratings.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public void rateResource(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        String rating = (String)Utils.getParameter(request, "rating");
        try {
            this.proxy.rateResource(rating, path, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to rate the resource.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public org.wso2.carbon.registry.common.beans.EventTypeBean getEventTypes(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        try {
            return (org.wso2.carbon.registry.common.beans.EventTypeBean)this.proxy.getEventTypes(path, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to get Event Types.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public org.wso2.carbon.registry.common.beans.SubscriptionBean getSubscriptions(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        try {
            return (org.wso2.carbon.registry.common.beans.SubscriptionBean)this.proxy.getSubscriptions(path, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to get Subscriptions.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public org.wso2.carbon.registry.common.beans.SubscriptionBean subscribe(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        String endpoint = (String)Utils.getParameter(request, "endpoint");
        String eventName = (String)Utils.getParameter(request, "eventName");
        String topicDelimiter = (String)Utils.getParameter(request, "delimiter");
        if (topicDelimiter.equals("#") || topicDelimiter.equals("*")) {
            path = path.endsWith("/") ? path + topicDelimiter : path + "/" + topicDelimiter;
        }
        try {
            return (org.wso2.carbon.registry.common.beans.SubscriptionBean)this.proxy.subscribe(path, endpoint, eventName, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to subscribe.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public org.wso2.carbon.registry.common.beans.SubscriptionBean subscribeREST(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        String endpoint = (String)Utils.getParameter(request, "endpoint");
        String eventName = (String)Utils.getParameter(request, "eventName");
        try {
            return (org.wso2.carbon.registry.common.beans.SubscriptionBean)this.proxy.subscribeREST(path, endpoint, eventName, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to subscribe.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public boolean unsubscribe(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        String id = (String)Utils.getParameter(request, "id");
        try {
            return this.proxy.unsubscribe(path, id, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to unsubscribe.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public boolean isResource(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        try {
            return this.proxy.isResource(path, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to get resource type.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public String getRemoteURL(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String path = (String)Utils.getParameter(request, "path");
        try {
            return this.proxy.getRemoteURL(path, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to get remote URL.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public String verifyEmail(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String data = (String)request.getSession().getAttribute("intermediate-data");
        try {
            return this.proxy.verifyEmail(data, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to verify e-mail address.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public boolean isUserValid(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String username = (String)Utils.getParameter(request, "username");
        try {
            return this.proxy.isUserValid(username, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to check existence of user.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public boolean isProfileExisting(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String username = (String)Utils.getParameter(request, "username");
        try {
            return this.proxy.isProfileExisting(username, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to check existence of user's profile.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public boolean isRoleValid(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String role = (String)Utils.getParameter(request, "role");
        try {
            return this.proxy.isRoleValid(role, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to check existence of role.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public boolean isRoleProfileExisting(HttpServletRequest request) throws Exception {
        String sessionId = UUIDGenerator.generateUUID();
        String role = (String)Utils.getParameter(request, "role");
        try {
            return this.proxy.isRoleProfileExisting(role, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to check existence of the profile for the role.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public CommentBean getComments(String path, String sessionId) throws RegistryException {
        CommentBean result = new CommentBean();
        try {
            org.wso2.carbon.registry.info.stub.beans.xsd.CommentBean bean = this.stub.getComments(path, sessionId);
            if (bean.getComments() == null) {
                bean.setComments(new org.wso2.carbon.registry.info.stub.beans.utils.xsd.Comment[0]);
            }
            org.wso2.carbon.registry.info.stub.beans.utils.xsd.Comment[] comments = bean.getComments();
            Comment[] resultComments = new Comment[comments.length];
            int i = 0;
            for (org.wso2.carbon.registry.info.stub.beans.utils.xsd.Comment comment : comments) {
                if (comment == null) continue;
                resultComments[i] = new Comment();
                resultComments[i].setAuthorUserName(comment.getAuthorUserName());
                resultComments[i].setCommentPath(comment.getCommentPath());
                resultComments[i].setContent((Object)comment.getContent());
                resultComments[i].setCreatedTime(comment.getCreatedTime());
                resultComments[i].setDescription(comment.getDescription());
                resultComments[i].setLastModified(comment.getLastModified());
                resultComments[i].setResourcePath(comment.getResourcePath());
                resultComments[i].setText(comment.getText());
                resultComments[i].setTime(comment.getTime());
                resultComments[i].setUser(comment.getUser());
                ++i;
            }
            result.setComments(resultComments);
            result.setErrorMessage(bean.getErrorMessage());
            result.setLoggedIn(bean.getLoggedIn());
            result.setPathWithVersion(bean.getPathWithVersion());
            result.setPutAllowed(bean.getPutAllowed());
            result.setVersionView(bean.getVersionView());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return result;
    }

    public void addComment(String comment, String path, String sessionId) throws RegistryException {
        try {
            this.stub.addComment(comment, path, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public void removeComment(String commentPath, String sessionId) throws RegistryException {
        try {
            this.stub.removeComment(commentPath, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public org.wso2.carbon.registry.common.beans.TagBean getTags(String path, String sessionId) throws RegistryException {
        org.wso2.carbon.registry.common.beans.TagBean result = new org.wso2.carbon.registry.common.beans.TagBean();
        try {
            TagBean bean = this.stub.getTags(path, sessionId);
            if (bean.getTags() == null) {
                bean.setTags(new org.wso2.carbon.registry.info.stub.beans.utils.xsd.Tag[0]);
            }
            org.wso2.carbon.registry.info.stub.beans.utils.xsd.Tag[] tags = bean.getTags();
            Tag[] resultTags = new Tag[tags.length];
            int i = 0;
            for (org.wso2.carbon.registry.info.stub.beans.utils.xsd.Tag tag : tags) {
                if (tag == null) continue;
                resultTags[i] = new Tag();
                resultTags[i].setCategory(tag.getCategory());
                resultTags[i].setTagCount(tag.getTagCount());
                resultTags[i].setTagName(tag.getTagName());
                ++i;
            }
            result.setTags(resultTags);
            result.setErrorMessage(bean.getErrorMessage());
            result.setLoggedIn(bean.getLoggedIn());
            result.setPathWithVersion(bean.getPathWithVersion());
            result.setPutAllowed(bean.getPutAllowed());
            result.setVersionView(bean.getVersionView());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return result;
    }

    public void addTag(String tag, String path, String sessionId) throws RegistryException {
        try {
            this.stub.addTag(tag, path, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public void removeTag(String tag, String path, String sessionId) throws RegistryException {
        try {
            this.stub.removeTag(tag, path, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public RatingBean getRatings(String path, String sessionId) throws RegistryException {
        RatingBean result = new RatingBean();
        try {
            org.wso2.carbon.registry.info.stub.beans.xsd.RatingBean bean = this.stub.getRatings(path, sessionId);
            result.setAverageRating(bean.getAverageRating());
            result.setAverageStars(bean.getAverageStars());
            result.setUserRating(bean.getUserRating());
            result.setUserStars(bean.getUserStars());
            result.setErrorMessage(bean.getErrorMessage());
            result.setLoggedIn(bean.getLoggedIn());
            result.setPathWithVersion(bean.getPathWithVersion());
            result.setPutAllowed(bean.getPutAllowed());
            result.setVersionView(bean.getVersionView());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return result;
    }

    public void rateResource(String rating, String path, String sessionId) throws RegistryException {
        try {
            this.stub.rateResource(rating, path, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public org.wso2.carbon.registry.common.beans.EventTypeBean getEventTypes(String path, String sessionId) throws RegistryException {
        org.wso2.carbon.registry.common.beans.EventTypeBean result = new org.wso2.carbon.registry.common.beans.EventTypeBean();
        try {
            EventTypeBean bean = this.stub.getEventTypes(path, sessionId);
            if (bean.getEventTypes() == null) {
                bean.setEventTypes(new org.wso2.carbon.registry.info.stub.beans.utils.xsd.EventType[0]);
            }
            org.wso2.carbon.registry.info.stub.beans.utils.xsd.EventType[] eventTypes = bean.getEventTypes();
            EventType[] resultEventTypes = new EventType[eventTypes.length];
            int i = 0;
            for (org.wso2.carbon.registry.info.stub.beans.utils.xsd.EventType eventType : eventTypes) {
                if (eventType == null) continue;
                resultEventTypes[i] = new EventType();
                resultEventTypes[i].setCollectionEvent(eventType.getCollectionEvent());
                resultEventTypes[i].setId(eventType.getId());
                resultEventTypes[i].setResourceEvent(eventType.getResourceEvent());
                ++i;
            }
            result.setEventTypes(resultEventTypes);
            result.setErrorMessage(bean.getErrorMessage());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return result;
    }

    public org.wso2.carbon.registry.common.beans.SubscriptionBean getSubscriptions(String path, String sessionId) throws RegistryException {
        org.wso2.carbon.registry.common.beans.SubscriptionBean result = new org.wso2.carbon.registry.common.beans.SubscriptionBean();
        try {
            SubscriptionBean bean = this.stub.getSubscriptions(path, sessionId);
            if (bean.getSubscriptionInstances() == null) {
                bean.setSubscriptionInstances(new org.wso2.carbon.registry.info.stub.beans.utils.xsd.SubscriptionInstance[0]);
            }
            org.wso2.carbon.registry.info.stub.beans.utils.xsd.SubscriptionInstance[] subscriptions = bean.getSubscriptionInstances();
            SubscriptionInstance[] resultSubscriptions = new SubscriptionInstance[subscriptions.length];
            int i = 0;
            for (org.wso2.carbon.registry.info.stub.beans.utils.xsd.SubscriptionInstance subscription : subscriptions) {
                if (subscription == null) continue;
                resultSubscriptions[i] = new SubscriptionInstance();
                resultSubscriptions[i].setAddress(subscription.getAddress());
                resultSubscriptions[i].setEventName(subscription.getEventName());
                resultSubscriptions[i].setId(subscription.getId());
                resultSubscriptions[i].setNotificationMethod(subscription.getNotificationMethod());
                resultSubscriptions[i].setSubManUrl(subscription.getSubManUrl());
                resultSubscriptions[i].setDigestType(subscription.getDigestType());
                resultSubscriptions[i].setTopic(subscription.getTopic());
                ++i;
            }
            result.setSubscriptionInstances(resultSubscriptions);
            result.setUserAccessLevel(bean.getUserAccessLevel());
            result.setRoleAccessLevel(bean.getRoleAccessLevel());
            result.setUserName(bean.getUserName());
            result.setRoles(bean.getRoles());
            result.setErrorMessage(bean.getErrorMessage());
            result.setLoggedIn(bean.getLoggedIn());
            result.setPathWithVersion(bean.getPathWithVersion());
            result.setVersionView(bean.getVersionView());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return result;
    }

    public org.wso2.carbon.registry.common.beans.SubscriptionBean subscribe(String path, String endpoint, String eventName, String sessionId) throws RegistryException {
        org.wso2.carbon.registry.common.beans.SubscriptionBean result = new org.wso2.carbon.registry.common.beans.SubscriptionBean();
        try {
            SubscriptionBean bean = this.stub.subscribe(path, endpoint, eventName, sessionId);
            if (bean == null) {
                bean = new SubscriptionBean();
            }
            if (bean.getSubscriptionInstances() == null) {
                bean.setSubscriptionInstances(new org.wso2.carbon.registry.info.stub.beans.utils.xsd.SubscriptionInstance[0]);
            }
            org.wso2.carbon.registry.info.stub.beans.utils.xsd.SubscriptionInstance[] subscriptions = bean.getSubscriptionInstances();
            SubscriptionInstance[] resultSubscriptions = new SubscriptionInstance[subscriptions.length];
            int i = 0;
            for (org.wso2.carbon.registry.info.stub.beans.utils.xsd.SubscriptionInstance subscription : subscriptions) {
                if (subscription == null) continue;
                resultSubscriptions[i] = new SubscriptionInstance();
                resultSubscriptions[i].setAddress(subscription.getAddress());
                resultSubscriptions[i].setEventName(subscription.getEventName());
                resultSubscriptions[i].setId(subscription.getId());
                resultSubscriptions[i].setNotificationMethod(subscription.getNotificationMethod());
                resultSubscriptions[i].setSubManUrl(subscription.getSubManUrl());
                resultSubscriptions[i].setDigestType(subscription.getDigestType());
                resultSubscriptions[i].setTopic(subscription.getTopic());
                ++i;
            }
            result.setSubscriptionInstances(resultSubscriptions);
            result.setUserAccessLevel(bean.getUserAccessLevel());
            result.setRoleAccessLevel(bean.getRoleAccessLevel());
            result.setUserName(bean.getUserName());
            result.setRoles(bean.getRoles());
            result.setErrorMessage(bean.getErrorMessage());
            result.setLoggedIn(bean.getLoggedIn());
            result.setPathWithVersion(bean.getPathWithVersion());
            result.setVersionView(bean.getVersionView());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return result;
    }

    public org.wso2.carbon.registry.common.beans.SubscriptionBean subscribeREST(String path, String endpoint, String eventName, String sessionId) throws RegistryException {
        org.wso2.carbon.registry.common.beans.SubscriptionBean result = new org.wso2.carbon.registry.common.beans.SubscriptionBean();
        try {
            SubscriptionBean bean = this.stub.subscribeREST(path, endpoint, eventName, sessionId);
            if (bean == null) {
                bean = new SubscriptionBean();
            }
            if (bean.getSubscriptionInstances() == null) {
                bean.setSubscriptionInstances(new org.wso2.carbon.registry.info.stub.beans.utils.xsd.SubscriptionInstance[0]);
            }
            org.wso2.carbon.registry.info.stub.beans.utils.xsd.SubscriptionInstance[] subscriptions = bean.getSubscriptionInstances();
            SubscriptionInstance[] resultSubscriptions = new SubscriptionInstance[subscriptions.length];
            int i = 0;
            for (org.wso2.carbon.registry.info.stub.beans.utils.xsd.SubscriptionInstance subscription : subscriptions) {
                if (subscription == null) continue;
                resultSubscriptions[i] = new SubscriptionInstance();
                resultSubscriptions[i].setAddress(subscription.getAddress());
                resultSubscriptions[i].setEventName(subscription.getEventName());
                resultSubscriptions[i].setId(subscription.getId());
                resultSubscriptions[i].setNotificationMethod(subscription.getNotificationMethod());
                resultSubscriptions[i].setSubManUrl(subscription.getSubManUrl());
                resultSubscriptions[i].setDigestType(subscription.getDigestType());
                resultSubscriptions[i].setTopic(subscription.getTopic());
                ++i;
            }
            result.setSubscriptionInstances(resultSubscriptions);
            result.setUserAccessLevel(bean.getUserAccessLevel());
            result.setRoleAccessLevel(bean.getRoleAccessLevel());
            result.setUserName(bean.getUserName());
            result.setRoles(bean.getRoles());
            result.setErrorMessage(bean.getErrorMessage());
            result.setLoggedIn(bean.getLoggedIn());
            result.setPathWithVersion(bean.getPathWithVersion());
            result.setVersionView(bean.getVersionView());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return result;
    }

    public boolean isResource(String path, String sessionId) throws RegistryException {
        try {
            return this.stub.isResource(path, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public String getRemoteURL(String path, String sessionId) throws RegistryException {
        try {
            return this.stub.getRemoteURL(path, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public String verifyEmail(String data, String sessionId) throws RegistryException {
        try {
            return this.stub.verifyEmail(data, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public boolean unsubscribe(String path, String id, String sessionId) throws RegistryException {
        try {
            return this.stub.unsubscribe(path, id, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public boolean isUserValid(String username, String sessionId) throws RegistryException {
        try {
            return this.stub.isUserValid(username, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public boolean isProfileExisting(String username, String sessionId) throws RegistryException {
        try {
            return this.stub.isProfileExisting(username, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public boolean isRoleValid(String role, String sessionId) throws RegistryException {
        try {
            return this.stub.isRoleValid(role, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public boolean isRoleProfileExisting(String role, String sessionId) throws RegistryException {
        try {
            return this.stub.isRoleProfileExisting(role, sessionId);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

