/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.info.services.utils;

import org.wso2.carbon.registry.common.beans.RatingBean;
import org.wso2.carbon.registry.common.utils.UserUtil;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RatingBeanPopulator {
    public static RatingBean populate(UserRegistry userRegistry, String path) {
        RatingBean ratingBean = new RatingBean();
        ResourcePath resourcePath = new ResourcePath(path);
        try {
            float averageRating = userRegistry.getAverageRating(resourcePath.getCompletePath());
            ratingBean.setAverageRating(averageRating);
            float tempRating = averageRating * 1000.0f;
            tempRating = Math.round(tempRating);
            averageRating = tempRating /= 1000.0f;
            int userRating = userRegistry.getRating(resourcePath.getCompletePath(), userRegistry.getUserName());
            ratingBean.setUserRating(userRating);
            String[] userStars = new String[5];
            for (int i = 0; i < 5; ++i) {
                if (userRating >= i + 1) {
                    userStars[i] = "04";
                    continue;
                }
                if (userRating > i) continue;
                userStars[i] = "00";
            }
            ratingBean.setUserStars(userStars);
            String[] averageStars = new String[5];
            for (int i = 0; i < 5; ++i) {
                float fraction;
                averageStars[i] = averageRating >= (float)(i + 1) ? "04" : (averageRating <= (float)i ? "00" : ((double)(fraction = averageRating - (float)i) <= 0.125 ? "00" : ((double)fraction > 0.125 && (double)fraction <= 0.375 ? "01" : ((double)fraction > 0.375 && (double)fraction <= 0.625 ? "02" : ((double)fraction > 0.625 && (double)fraction <= 0.875 ? "03" : "04")))));
            }
            ratingBean.setAverageStars(averageStars);
            ratingBean.setVersionView(!resourcePath.isCurrentVersion());
            ratingBean.setPathWithVersion(resourcePath.getPathWithVersion());
            ratingBean.setPutAllowed(UserUtil.isPutAllowed((String)userRegistry.getUserName(), (String)path, (UserRegistry)userRegistry));
            ratingBean.setLoggedIn(!"wso2.anonymous.user".equals(userRegistry.getUserName()));
        }
        catch (RegistryException e) {
            String msg = "Failed to get ratings information of the resource " + resourcePath + ". " + e.getMessage();
            ratingBean.setErrorMessage(msg);
        }
        return ratingBean;
    }
}

