/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.info.internal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.registry.admin.api.jmx.ISubscriptionsService;
import org.wso2.carbon.registry.common.beans.SubscriptionBean;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.eventing.services.EventingService;
import org.wso2.carbon.registry.eventing.services.SubscriptionEmailVerficationService;
import org.wso2.carbon.registry.extensions.jmx.Subscriptions;
import org.wso2.carbon.registry.info.Utils;
import org.wso2.carbon.registry.info.services.utils.SubscriptionBeanPopulator;

public class RegistryMgtUIInfoServiceComponent {
    private static Log log = LogFactory.getLog(RegistryMgtUIInfoServiceComponent.class);
    private ServiceRegistration infoServiceRegistration = null;

    protected void activate(ComponentContext context) {
        log.debug((Object)"******* Registry Info Management bundle is activated ******* ");
    }

    protected void deactivate(ComponentContext context) {
        if (this.infoServiceRegistration != null) {
            this.infoServiceRegistration.unregister();
            this.infoServiceRegistration = null;
        }
        log.debug((Object)"******* Registry Info UI Management bundle is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        Utils.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Utils.setRegistryService(null);
    }

    protected void setSubscriptions(Subscriptions eventing) {
        eventing.setImplBean(new ISubscriptionsService(){
            private String[] eventNames = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String subscribe(String endpoint, boolean isRestEndpoint, String path, String eventName) {
                SuperTenantCarbonContext.startTenantFlow();
                try {
                    SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
                    UserRegistry registry = Utils.getRegistryService().getRegistry("wso2.system.user");
                    if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
                        String string = null;
                        return string;
                    }
                    SubscriptionBean subscriptionBean = SubscriptionBeanPopulator.subscribeAndPopulate(registry, path, endpoint, eventName, isRestEndpoint);
                    if (subscriptionBean != null && subscriptionBean.getSubscriptionInstances() != null && subscriptionBean.getSubscriptionInstances().length > 0) {
                        String string = subscriptionBean.getSubscriptionInstances()[0].getId();
                        return string;
                    }
                }
                catch (RegistryException e) {
                    log.error((Object)"An error occurred while subscribing", (Throwable)e);
                }
                finally {
                    SuperTenantCarbonContext.endTenantFlow();
                }
                return "";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unsubscribe(String id) {
                SuperTenantCarbonContext.startTenantFlow();
                try {
                    SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
                    Utils.getRegistryEventingService().unsubscribe(id);
                }
                finally {
                    SuperTenantCarbonContext.endTenantFlow();
                }
            }

            public String[] getEventNames() {
                if (this.eventNames != null) {
                    return this.eventNames;
                }
                TreeSet<String> output = new TreeSet<String>();
                Collection values = Utils.getRegistryEventingService().getEventTypes().values();
                for (Object value : values) {
                    String[] types = (String[])value;
                    if (types[0] != null) {
                        output.add(types[0]);
                    }
                    if (types[1] == null) continue;
                    output.add(types[1]);
                }
                this.eventNames = output.toArray(new String[output.size()]);
                return this.eventNames;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] getList() {
                LinkedList<String> output = new LinkedList<String>();
                SuperTenantCarbonContext.startTenantFlow();
                try {
                    SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
                    List subscriptions = Utils.getRegistryEventingService().getAllSubscriptions();
                    for (Subscription subscription : subscriptions) {
                        output.add(subscription.getId() + ":" + subscription.getTopicName() + ":" + subscription.getEventSinkURL());
                    }
                }
                catch (EventBrokerException e) {
                    log.error((Object)"Unable to retrieve subscriptions", (Throwable)e);
                }
                finally {
                    SuperTenantCarbonContext.endTenantFlow();
                }
                return output.toArray(new String[output.size()]);
            }
        });
    }

    protected void unsetSubscriptions(Subscriptions eventing) {
        eventing.setImplBean(null);
    }

    protected void setRegistryEventingService(EventingService eventingService) {
        Utils.setRegistryEventingService(eventingService);
        log.debug((Object)"Successfully set registry eventing service");
    }

    protected void unsetRegistryEventingService(EventingService eventingService) {
        Utils.setRegistryEventingService(null);
    }

    protected void setSubscriptionEmailVerficationService(SubscriptionEmailVerficationService subscriptionEmailVerficationService) {
        Utils.setSubscriptionEmailVerficationService(subscriptionEmailVerficationService);
        log.debug((Object)"Successfully set subscription e-mail verification service");
    }

    protected void unsetSubscriptionEmailVerficationService(SubscriptionEmailVerficationService subscriptionEmailVerficationService) {
        Utils.setSubscriptionEmailVerficationService(null);
    }
}

