/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.eventing.events;

import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.registry.common.eventing.RegistryEvent;

public class DispatchEvent
extends Message {
    private String endpoint = null;
    private boolean doRest = false;
    private RegistryEvent event = null;

    public DispatchEvent(RegistryEvent event, String endpoint, boolean doRest) {
        this.event = event;
        this.setEndpoint(endpoint);
        this.setDoRest(doRest);
        this.setProperties(event.getParameters());
    }

    public OMElement getMessage() {
        if (this.event.getMessage() instanceof OMElement) {
            return (OMElement)this.event.getMessage();
        }
        if (this.event.getMessage() instanceof String) {
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMNamespace namespace = factory.createOMNamespace("http://wso2.org/ns/2011/01/eventing/registry/event", "ns");
            OMElement payload = factory.createOMElement("Event", namespace);
            factory.createOMElement("Message", namespace, (OMContainer)payload).setText((String)this.event.getMessage());
            factory.createOMElement("Timestamp", namespace, (OMContainer)payload).setText(this.event.getTimestamp());
            RegistryEvent.Context contextDetails = this.event.getContextDetails();
            RegistryEvent.Operation operationDetails = this.event.getOperationDetails();
            RegistryEvent.RegistrySession registrySessionDetails = this.event.getRegistrySessionDetails();
            RegistryEvent.Server serverDetails = RegistryEvent.getServerDetails();
            OMElement details = factory.createOMElement("Details", namespace, (OMContainer)payload);
            OMElement registrySession = factory.createOMElement("Session", namespace, (OMContainer)details);
            String chroot = registrySessionDetails.getChroot();
            if (chroot == null) {
                chroot = "undefined";
            }
            factory.createOMElement("Chroot", namespace, (OMContainer)registrySession).setText(chroot);
            String username = registrySessionDetails.getUsername();
            if (username == null && (username = contextDetails.getUsername()) == null) {
                username = "unknown";
            }
            factory.createOMElement("Username", namespace, (OMContainer)registrySession).setText(username);
            int tenantId = registrySessionDetails.getTenantId();
            if (tenantId == -1 && (tenantId = contextDetails.getTenantId()) == -1) {
                tenantId = this.event.getTenantId();
            }
            factory.createOMElement("TenantId", namespace, (OMContainer)registrySession).setText(Integer.toString(tenantId));
            OMElement operation = factory.createOMElement("Operation", namespace, (OMContainer)details);
            factory.createOMElement("Path", namespace, (OMContainer)operation).setText(operationDetails.getPath());
            factory.createOMElement("EventType", namespace, (OMContainer)operation).setText(operationDetails.getEventType());
            factory.createOMElement("ResourceType", namespace, (OMContainer)operation).setText(operationDetails.getResourceType());
            Map parameters = this.event.getParameters();
            for (Map.Entry e : parameters.entrySet()) {
                factory.createOMElement((String)e.getKey(), namespace, (OMContainer)operation).setText((String)e.getValue());
            }
            OMElement server = factory.createOMElement("Server", namespace, (OMContainer)details);
            factory.createOMElement("HostName", namespace, (OMContainer)server).setText(serverDetails.getHostIPAddress());
            OMElement product = factory.createOMElement("Product", namespace, (OMContainer)server);
            factory.createOMElement("Name", namespace, (OMContainer)product).setText(serverDetails.getProductName());
            factory.createOMElement("Version", namespace, (OMContainer)product).setText(serverDetails.getProductVersion());
            OMElement os = factory.createOMElement("OS", namespace, (OMContainer)server);
            factory.createOMElement("Name", namespace, (OMContainer)os).setText(serverDetails.getOSDetails().getOperatingSystemName());
            factory.createOMElement("Version", namespace, (OMContainer)os).setText(serverDetails.getOSDetails().getOperatingSystemVersion());
            factory.createOMElement("Architecture", namespace, (OMContainer)os).setText(serverDetails.getOSDetails().getOperatingSystemArchitecture());
            OMElement user = factory.createOMElement("User", namespace, (OMContainer)server);
            factory.createOMElement("Name", namespace, (OMContainer)user).setText(serverDetails.getOSUser().getUsername());
            factory.createOMElement("Country", namespace, (OMContainer)user).setText(serverDetails.getOSUser().getCountry());
            factory.createOMElement("Language", namespace, (OMContainer)user).setText(serverDetails.getOSUser().getLanguage());
            factory.createOMElement("TimeZone", namespace, (OMContainer)user).setText(serverDetails.getOSUser().getTimezone());
            OMElement java = factory.createOMElement("Java", namespace, (OMContainer)server);
            factory.createOMElement("Vendor", namespace, (OMContainer)java).setText(serverDetails.getJVMDetails().getJavaVendor());
            factory.createOMElement("Version", namespace, (OMContainer)java).setText(serverDetails.getJVMDetails().getJavaVersion());
            OMElement jvm = factory.createOMElement("JVM", namespace, (OMContainer)java);
            factory.createOMElement("Name", namespace, (OMContainer)jvm).setText(serverDetails.getJVMDetails().getJavaVMName());
            factory.createOMElement("Version", namespace, (OMContainer)jvm).setText(serverDetails.getJVMDetails().getJavaVMVersion());
            payload.build();
            return payload;
        }
        return null;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isDoRest() {
        return this.doRest;
    }

    public void setDoRest(boolean doRest) {
        this.doRest = doRest;
    }

    public int getTenantId() {
        return this.event.getTenantId();
    }

    public void setTenantId(int tenantId) {
        this.event.setTenantId(tenantId);
    }

    public String getTimestamp() {
        return this.event.getTimestamp();
    }

    public RegistryEvent.RegistrySession getRegistrySessionDetails() {
        return this.event.getRegistrySessionDetails();
    }

    public RegistryEvent.Context getContextDetails() {
        return this.event.getContextDetails();
    }

    public RegistryEvent.Operation getOperationDetails() {
        return this.event.getOperationDetails();
    }

    public String getTopic() {
        return this.event.getTopic();
    }

    public Map<String, String> getParameters() {
        return this.event.getParameters();
    }
}

