/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.email.verification.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.email.verification.internal.EmailVerificationServiceComponent;
import org.wso2.carbon.email.verification.util.EmailVerifierConfig;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class EmailSender
extends Thread {
    public static final String CONF_STRING = "confirmation";
    private static Log log = LogFactory.getLog(EmailSender.class);
    private EmailVerifierConfig config = null;
    private String emailAddr = null;
    private String secretKey = null;
    private String tenantDomain = null;
    private Map<String, String> userParameters = null;

    public EmailSender(EmailVerifierConfig config, String emailAddr, String secretKey) {
        this(config, emailAddr, secretKey, null);
    }

    public EmailSender(EmailVerifierConfig config, String emailAddr, String secretKey, String tenantDomain) {
        this(config, emailAddr, secretKey, tenantDomain, null);
    }

    public EmailSender(EmailVerifierConfig config, String emailAddr, String secretKey, String tenantDomain, Map<String, String> userParameters) {
        this.config = config;
        this.emailAddr = emailAddr;
        this.secretKey = secretKey;
        this.tenantDomain = tenantDomain;
        this.userParameters = userParameters;
    }

    public void sendEmail() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        HashMap<String, String> userParams = new HashMap<String, String>();
        userParams.put("admin-name", this.userParameters.get("admin"));
        userParams.put("user-name", this.userParameters.get("userName"));
        userParams.put("domain-name", this.userParameters.get("tenantDomain"));
        userParams.put("first-name", this.userParameters.get("first-name"));
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantDomain(this.tenantDomain, true);
            if (this.config.getSubject().length() == 0) {
                headerMap.put("Subject", "EmailVerification");
            } else {
                headerMap.put("Subject", EmailSender.replacePlaceHolders(this.config.getSubject(), userParams));
            }
            String requestMessage = EmailSender.replacePlaceHolders(this.getRequestMessage(), userParams);
            OMElement payload = OMAbstractFactory.getOMFactory().createOMElement(BaseConstants.DEFAULT_TEXT_WRAPPER, null);
            payload.setText(requestMessage);
            ConfigurationContext configContext = EmailVerificationServiceComponent.getConfigurationContext();
            ServiceClient serviceClient = configContext != null ? new ServiceClient(configContext, null) : new ServiceClient();
            Options options = new Options();
            options.setProperty("enableREST", (Object)"true");
            options.setProperty("TRANSPORT_HEADERS", headerMap);
            options.setProperty("transport.mail.Format", (Object)"Text");
            options.setTo(new EndpointReference("mailto:" + this.emailAddr));
            serviceClient.setOptions(options);
            serviceClient.fireAndForget(payload);
            log.debug((Object)("Sending confirmation mail to " + this.emailAddr));
            log.debug((Object)("Verification url : " + requestMessage));
            log.debug((Object)("Sending confirmation mail to " + this.emailAddr + "DONE"));
        }
        catch (AxisFault e) {
            log.error((Object)"Failed Sending Email", (Throwable)e);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    private String getRequestMessage() {
        String targetEpr = this.config.getTargetEpr();
        String tenantDomain = this.tenantDomain;
        if (tenantDomain == null) {
            SuperTenantCarbonContext.getCurrentContext().getTenantDomain(true);
        }
        if (tenantDomain != null && targetEpr.indexOf("/carbon") > 0 && MultitenantUtils.getTenantDomainFromRequestURL((String)targetEpr) == null && SuperTenantCarbonContext.getCurrentContext().getTenantId(true) != -1234) {
            targetEpr = targetEpr.replace("/carbon", "/t/" + tenantDomain + "/carbon");
        }
        String msg = this.config.getEmailBody().length() == 0 ? "Please point your browser to : \n" + targetEpr + "?" + CONF_STRING + "=" + this.secretKey + "\n" : this.config.getEmailBody() + "\n" + targetEpr + "?" + CONF_STRING + "=" + this.secretKey + "\n";
        if (this.config.getEmailFooter() != null) {
            msg = msg + "\n" + this.config.getEmailFooter();
        }
        return msg;
    }

    public static String replacePlaceHolders(String text, Map<String, String> userParameters) {
        if (userParameters != null) {
            for (Map.Entry<String, String> entry : userParameters.entrySet()) {
                String key = entry.getKey();
                text = text.replaceAll("\\{" + key + "\\}", entry.getValue());
            }
        }
        return text;
    }
}

