/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.info.services;

import java.util.Arrays;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.registry.common.IInfoService;
import org.wso2.carbon.registry.common.beans.CommentBean;
import org.wso2.carbon.registry.common.beans.EventTypeBean;
import org.wso2.carbon.registry.common.beans.RatingBean;
import org.wso2.carbon.registry.common.beans.SubscriptionBean;
import org.wso2.carbon.registry.common.beans.TagBean;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.info.Utils;
import org.wso2.carbon.registry.info.services.utils.CommentBeanPopulator;
import org.wso2.carbon.registry.info.services.utils.EventTypeBeanPopulator;
import org.wso2.carbon.registry.info.services.utils.RatingBeanPopulator;
import org.wso2.carbon.registry.info.services.utils.SubscriptionBeanPopulator;
import org.wso2.carbon.registry.info.services.utils.TagBeanPopulator;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class InfoService
extends RegistryAbstractAdmin
implements IInfoService {
    private static final Log log = LogFactory.getLog(InfoService.class);

    public void setSession(String sessionId, HttpSession session) {
    }

    public void removeSession(String sessionId) {
    }

    public CommentBean getComments(String path, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return CommentBeanPopulator.populate(registry, path);
    }

    public void addComment(String comment, String path, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        registry.addComment(path, new Comment(comment));
    }

    public void removeComment(String commentPath, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        registry.removeComment(commentPath);
    }

    public TagBean getTags(String path, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return TagBeanPopulator.populate(registry, path);
    }

    public void addTag(String tag, String path, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        registry.applyTag(path, tag);
    }

    public void removeTag(String tag, String path, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        registry.removeTag(path, tag);
    }

    public RatingBean getRatings(String path, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return RatingBeanPopulator.populate(registry, path);
    }

    public void rateResource(String rating, String path, String sessionId) throws RegistryException {
        int userRating = Integer.parseInt(rating);
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        registry.rateResource(path, userRating);
    }

    public EventTypeBean getEventTypes(String path, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        Resource resource = null;
        if (!path.startsWith("-R") && registry.resourceExists(path)) {
            resource = registry.get(path);
        }
        if (resource != null) {
            String isLink = resource.getProperty("registry.link");
            String mountPoint = resource.getProperty("registry.mountpoint");
            String targetPoint = resource.getProperty("registry.targetpoint");
            String actualPath = resource.getProperty("registry.actualpath");
            if (isLink != null && mountPoint != null && targetPoint != null) {
                path = actualPath;
            }
        }
        return EventTypeBeanPopulator.populate(registry, path);
    }

    public SubscriptionBean getSubscriptions(String path, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return SubscriptionBeanPopulator.populate(registry, path);
    }

    public SubscriptionBean subscribe(String path, String endpoint, String eventName, String sessionId) throws RegistryException {
        String tempPath = path.substring(0, path.lastIndexOf("/"));
        RegistryUtils.recordStatistics((Object[])new Object[]{tempPath, endpoint, eventName, sessionId});
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return null;
        }
        return SubscriptionBeanPopulator.subscribeAndPopulate(registry, path, endpoint, eventName);
    }

    public SubscriptionBean subscribeREST(String path, String endpoint, String eventName, String sessionId) throws RegistryException {
        RegistryUtils.recordStatistics((Object[])new Object[]{path, endpoint, eventName, sessionId});
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return null;
        }
        return SubscriptionBeanPopulator.subscribeAndPopulate(registry, path, endpoint, eventName, true);
    }

    public boolean isResource(String path, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (!registry.resourceExists(path)) {
            return true;
        }
        Resource resource = registry.get(path);
        if (resource != null) {
            String isLink = resource.getProperty("registry.link");
            String mountPoint = resource.getProperty("registry.mountpoint");
            String targetPoint = resource.getProperty("registry.targetpoint");
            String actualPath = resource.getProperty("registry.actualpath");
            if (isLink != null && mountPoint != null && targetPoint != null) {
                path = actualPath;
                resource = null;
            }
        }
        try {
            if (resource == null) {
                resource = registry.get(path);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (resource != null && resource instanceof Collection) {
            log.debug((Object)("Found Collection at path: " + path));
            return false;
        }
        if (resource == null) {
            log.error((Object)("No resource was found at path: " + path));
        } else {
            log.debug((Object)("Found Resource at path: " + path));
        }
        return true;
    }

    public boolean isProfileExisting(String username, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        try {
            if (registry != null && registry.getUserRealm() != null && registry.getUserRealm().getUserStoreManager() != null) {
                String[] userRoles;
                UserRealm realm = registry.getUserRealm();
                boolean isAdmin = false;
                for (String userRole : userRoles = realm.getUserStoreManager().getRoleListOfUser(registry.getUserName())) {
                    if (!userRole.equals(realm.getRealmConfiguration().getAdminRoleName())) continue;
                    isAdmin = true;
                    break;
                }
                if (!username.equals(registry.getUserName()) && !isAdmin) {
                    return false;
                }
                UserStoreManager reader = realm.getUserStoreManager();
                return reader.getUserClaimValue(username, "http://wso2.org/claims/emailaddress", "default") != null;
            }
        }
        catch (UserStoreException ignore) {
            return false;
        }
        return false;
    }

    public boolean isRoleProfileExisting(String role, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        try {
            if (registry != null && registry.getUserRealm() != null && registry.getUserRealm().getUserStoreManager() != null) {
                String[] userRoles;
                UserRealm realm = registry.getUserRealm();
                boolean isAdmin = false;
                for (String userRole : userRoles = realm.getUserStoreManager().getRoleListOfUser(registry.getUserName())) {
                    if (!userRole.equals(realm.getRealmConfiguration().getAdminRoleName())) continue;
                    isAdmin = true;
                    break;
                }
                return Arrays.asList(userRoles).contains(role) || isAdmin;
            }
        }
        catch (UserStoreException ignore) {
            return false;
        }
        return false;
    }

    public String getRemoteURL(String path, String sessionId) throws RegistryException {
        Resource resource;
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (registry.resourceExists(path) && (resource = registry.get(path)) != null) {
            String isLink = resource.getProperty("registry.link");
            String realPath = resource.getProperty("registry.realpath");
            String userName = resource.getProperty("registry.user");
            if (isLink != null && realPath != null && userName != null) {
                log.debug((Object)("Found mounted resource at: " + realPath));
                if (!realPath.contains("/registry/resourceContent?")) {
                    return null;
                }
                return realPath.replace("/registry/resourceContent?", "/carbon/resources/resource.jsp?region=region3&item=resource_browser_menu&viewType=std&");
            }
        }
        return null;
    }

    public String verifyEmail(String data, String sessionId) throws RegistryException {
        if (Utils.getSubscriptionEmailVerficationService() == null) {
            return null;
        }
        return Utils.getSubscriptionEmailVerficationService().verifyEmail(data);
    }

    public boolean unsubscribe(String path, String id, String sessionId) throws RegistryException {
        Resource resource;
        RegistryUtils.recordStatistics((Object[])new Object[]{path, id, sessionId});
        log.debug((Object)("Got unsubscribe request at path: " + path + " with id: " + id));
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        String url = null;
        String userName = null;
        if (registry.resourceExists(path) && (resource = registry.get(path)) != null) {
            String isLink = resource.getProperty("registry.link");
            String mountPoint = resource.getProperty("registry.mountpoint");
            String targetPoint = resource.getProperty("registry.targetpoint");
            String realPath = resource.getProperty("registry.realpath");
            String actualPath = resource.getProperty("registry.actualpath");
            userName = resource.getProperty("registry.user");
            if (isLink != null && mountPoint != null && targetPoint != null) {
                path = actualPath;
            } else if (isLink != null && realPath != null && userName != null) {
                log.debug((Object)("Found mounted resource at: " + realPath));
                if (!realPath.contains("/registry/resourceContent?")) {
                    path = realPath;
                } else {
                    url = realPath.substring(0, realPath.indexOf("/resourceContent?path="));
                }
            }
        }
        log.debug((Object)("got path: " + path));
        if ("wso2.anonymous.user".equals(registry.getUserName())) {
            log.warn((Object)"User is anonymous, can't unsubscribe");
            return false;
        }
        if (Utils.getRegistryEventingService() == null) {
            log.warn((Object)"No event source found, can't unsubscribe");
            return false;
        }
        try {
            Subscription subscription = null;
            subscription = url == null || userName == null ? Utils.getRegistryEventingService().getSubscription(id) : Utils.getRegistryEventingService().getSubscription(id, userName, url);
            if (subscription == null) {
                log.warn((Object)"Subscription not found, can't unsubscribe");
                return false;
            }
            if (subscription.getTenantId() != registry.getCallerTenantId()) {
                log.warn((Object)"TenantId for subscription doesn't match with the logged-in tenant");
                return false;
            }
            String username = subscription.getOwner();
            if (username.indexOf("@") > 0) {
                username = username.split("@")[0];
            }
            if (username == null || !username.equals(registry.getUserName())) {
                if (!SubscriptionBeanPopulator.isAuthorized(registry, path, "authorize")) {
                    log.warn((Object)"User doesn't have AUTHORIZE priviledges, can't unsubscribe");
                    return false;
                }
            } else if (!SubscriptionBeanPopulator.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get")) {
                return false;
            }
            if (url == null || userName == null) {
                return Utils.getRegistryEventingService().unsubscribe(id);
            }
            return Utils.getRegistryEventingService().unsubscribe(id, userName, url);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isUserValid(String username, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        try {
            return registry.getUserRealm().getUserStoreManager().isExistingUser(username);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isRoleValid(String role, String sessionId) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        try {
            return registry.getUserRealm().getUserStoreManager().isExistingRole(role);
        }
        catch (Exception e) {
            return false;
        }
    }
}

