/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.common.ui.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class TreeNodeBuilderUtil {
    private static String[] wsdlPrefixes = new String[]{"wsdl", "http://schemas.xmlsoap.org/wsdl/", "wsdl2", "http://www.w3.org/ns/wsdl", "xsd", "http://www.w3.org/2001/XMLSchema", "soap", "http://schemas.xmlsoap.org/wsdl/soap/", "soap12", "http://schemas.xmlsoap.org/wsdl/soap12/", "http", "http://schemas.xmlsoap.org/wsdl/http/"};

    public static String calculateAbsolutePath(String wsdlPath, String targetPath) {
        if (targetPath.startsWith("/") && targetPath.startsWith("http://") && targetPath.startsWith("https://")) {
            return targetPath;
        }
        if (targetPath.startsWith("..") || targetPath.startsWith("./")) {
            int i;
            if (targetPath.startsWith("./")) {
                targetPath = targetPath.replaceFirst("./", "/");
            }
            String wsdlCollection = RegistryUtils.getParentPath((String)wsdlPath);
            String targetCollection = RegistryUtils.getParentPath((String)targetPath);
            String[] targetPathParts = targetCollection.split("/");
            String[] currentPathParts = wsdlCollection.split("/");
            int countGoUpwardParts = 0;
            for (int i2 = 0; i2 < targetPathParts.length && targetPathParts[i2].equals(".."); ++i2) {
                ++countGoUpwardParts;
            }
            if (currentPathParts.length < countGoUpwardParts) {
                return null;
            }
            StringBuffer absolutePath = new StringBuffer();
            for (i = 0; i < currentPathParts.length - countGoUpwardParts; ++i) {
                absolutePath.append(currentPathParts[i]).append("/");
            }
            for (i = countGoUpwardParts; i < targetPathParts.length; ++i) {
                absolutePath.append(targetPathParts[i]).append("/");
            }
            targetPath = absolutePath.toString() + RegistryUtils.getResourceName((String)targetPath);
            return targetPath.replaceAll("//", "/");
        }
        return targetPath;
    }

    public static String convertQNameToString(String name, String namespaceURI) {
        if (namespaceURI == null) {
            return name;
        }
        return name + " [" + namespaceURI + "]";
    }

    public static String getNamespaceURI(String name, OMElement currentElement) {
        String prefix = TreeNodeBuilderUtil.getPrefix(name);
        OMNamespace namespace = null;
        namespace = prefix != null ? currentElement.findNamespace(null, prefix) : currentElement.getDefaultNamespace();
        if (namespace == null) {
            return null;
        }
        return namespace.getNamespaceURI();
    }

    public static String getLocalName(String name) {
        int colonIndex = name.indexOf(":");
        if (colonIndex == -1) {
            return name;
        }
        if (colonIndex == name.length() - 1) {
            return "";
        }
        return name.substring(colonIndex + 1);
    }

    public static String getPrefix(String name) {
        int colonIndex = name.indexOf(":");
        if (colonIndex == -1) {
            return null;
        }
        return name.substring(0, colonIndex);
    }

    public static String generateKeyName(String type, String name) {
        return name == null || name.equals("") ? type : type + "<em>: " + name + "</em>";
    }

    public static List<OMElement> evaluateXPathToElements(String expression, OMElement root) throws Exception {
        String[] nsPrefixes = wsdlPrefixes;
        AXIOMXPath xpathExpression = new AXIOMXPath(expression);
        for (int j = 0; j < nsPrefixes.length; ++j) {
            xpathExpression.addNamespace(nsPrefixes[j++], nsPrefixes[j]);
        }
        List omElements = xpathExpression.selectNodes((Object)root);
        if (omElements == null) {
            return Collections.emptyList();
        }
        return omElements;
    }

    public static List<OMAttribute> evaluateXPathToAttributes(String expression, OMElement root) throws Exception {
        String[] nsPrefixes = wsdlPrefixes;
        AXIOMXPath xpathExpression = new AXIOMXPath(expression);
        for (int j = 0; j < nsPrefixes.length; ++j) {
            xpathExpression.addNamespace(nsPrefixes[j++], nsPrefixes[j]);
        }
        List omElements = xpathExpression.selectNodes((Object)root);
        if (omElements == null) {
            return Collections.emptyList();
        }
        return omElements;
    }

    public static OMElement evaluateXPathToElement(String expression, OMElement root) throws Exception {
        List<OMElement> nodes = TreeNodeBuilderUtil.evaluateXPathToElements(expression, root);
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        return nodes.get(0);
    }

    public static List<String> evaluateXPathToValues(String expression, OMElement root) throws Exception {
        String[] nsPrefixes = wsdlPrefixes;
        AXIOMXPath xpathExpression = new AXIOMXPath(expression);
        for (int j = 0; j < nsPrefixes.length; ++j) {
            xpathExpression.addNamespace(nsPrefixes[j++], nsPrefixes[j]);
        }
        List nodeList = xpathExpression.selectNodes((Object)root);
        ArrayList<String> values = new ArrayList<String>();
        if (nodeList != null) {
            for (Object nodeObj : nodeList) {
                String value = ((OMAttribute)nodeObj).getAttributeValue();
                values.add(value);
            }
        }
        return values;
    }

    public static String evaluateXPathToValue(String expression, OMElement root) throws Exception {
        List<String> values = TreeNodeBuilderUtil.evaluateXPathToValues(expression, root);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }
}

