/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.activities.services.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.beans.ActivityBean;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;

public class ActivityBeanPopulator {
    private static final Log log = LogFactory.getLog(ActivityBeanPopulator.class);

    public static ActivityBean populate(UserRegistry userRegistry, String userName, String resourcePath, String fromDate, String toDate, String filter, String pageStr) throws Exception {
        UserRealm realm = userRegistry.getUserRealm();
        UserStoreManager reader = realm.getUserStoreManager();
        String[] roles = reader.getRoleListOfUser(userRegistry.getUserName());
        List<String> list = Arrays.asList(roles);
        ActivityBean activityBean = new ActivityBean();
        if (resourcePath != null && resourcePath.equals("")) {
            resourcePath = null;
        }
        if (userName != null && userName.equals("")) {
            userName = null;
        }
        if (fromDate != null && fromDate.equals("")) {
            fromDate = null;
        }
        if (toDate != null && toDate.equals("")) {
            toDate = null;
        }
        if (filter == null) {
            filter = "1";
        }
        LinkedList<Integer> filterValues = new LinkedList<Integer>();
        if (filter.equals("resourceAdd")) {
            filterValues.add(0);
        } else if (filter.equals("resourceUpdate")) {
            filterValues.add(1);
        } else if (filter.equals("commentings")) {
            filterValues.add(2);
            filterValues.add(3);
        } else if (filter.equals("taggings")) {
            filterValues.add(4);
            filterValues.add(5);
        } else if (filter.equals("ratings")) {
            filterValues.add(6);
        } else if (filter.equals("restore")) {
            filterValues.add(8);
        } else if (filter.equals("delete")) {
            filterValues.add(7);
        } else if (filter.equals("addAssociation")) {
            filterValues.add(15);
        } else if (filter.equals("removeAssociation")) {
            filterValues.add(16);
        } else if (filter.equals("createSymbolicLink")) {
            filterValues.add(13);
        } else if (filter.equals("createRemoteLink")) {
            filterValues.add(12);
        } else if (filter.equals("removeLink")) {
            filterValues.add(14);
        } else if (filter.equals("associateAspect")) {
            filterValues.add(17);
        } else {
            filterValues.add(-1);
        }
        try {
            LinkedList<LogEntry> logList = new LinkedList<LogEntry>();
            for (Integer filterValue : filterValues) {
                logList.addAll(Arrays.asList(userRegistry.getLogs(resourcePath, filterValue.intValue(), userName, ActivityBeanPopulator.computeDate(fromDate), ActivityBeanPopulator.computeDate(toDate), true)));
            }
            LogEntry[] logs = logList.toArray(new LogEntry[logList.size()]);
            Arrays.sort(logs, new Comparator<LogEntry>(){

                @Override
                public int compare(LogEntry o1, LogEntry o2) {
                    return o2.getDate().compareTo(o1.getDate());
                }
            });
            if (list.contains(userRegistry.getUserRealm().getRealmConfiguration().getAdminRoleName())) {
                activityBean.setActivity(ActivityBeanPopulator.constructActivityStatements((Registry)userRegistry, logs));
            } else {
                activityBean.setActivity(ActivityBeanPopulator.constructActivityStatementsfornormaluser((Registry)userRegistry, logs, userRegistry.getUserName()));
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to get activities for generating activity search results " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            activityBean.setErrorMessage(msg);
        }
        return activityBean;
    }

    private static String[] constructActivityStatements(Registry registry, LogEntry[] logs) {
        String[] activity = new String[logs.length];
        for (int i = 0; i < logs.length; ++i) {
            String entry;
            String[] actionData;
            String entry2;
            LogEntry logEntry = logs[i];
            if (logEntry.getAction() == 0) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has added the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 1) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has updated the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 7) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has deleted the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 2) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has commented on resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + " with the following comment." + "|" + logEntry.getActionData();
                continue;
            }
            if (logEntry.getAction() == 3) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has deleted the comment '" + logEntry.getActionData() + "' on the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 4) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has tagged the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " with tag '" + logEntry.getActionData() + "'  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 5) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has removed the tag '" + logEntry.getActionData() + "' on the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 6) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has rated the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " with rating " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 15) {
                actionData = logEntry.getActionData().split(";");
                if (actionData == null || actionData.length < 2) continue;
                activity[i] = entry = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has added an association of type " + actionData[0] + " from the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the resource " + actionData[1] + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 16) {
                actionData = logEntry.getActionData().split(";");
                if (actionData == null || actionData.length < 2) continue;
                activity[i] = entry = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has removed an association of type " + actionData[0] + " from the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the resource " + actionData[1] + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 8) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has restored the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + (logEntry.getActionData() != null ? " to the version " + logEntry.getActionData() : "") + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 17) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has associated the aspect " + logEntry.getActionData() + " to the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 11) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has copied the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the Location " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 9) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has renamed the resource to " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " from old Name: " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 10) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has moved the resource to " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " from the Location " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 13) {
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has created a symbolic link " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the Location " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() == 12) {
                if (logEntry.getActionData().contains(";")) {
                    actionData = logEntry.getActionData().split(";");
                    if (actionData == null || actionData.length < 2) continue;
                    activity[i] = entry = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has created a remote link " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the instance " + actionData[0] + " at path " + actionData[1] + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                    continue;
                }
                activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has created a remote link " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the Location " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                continue;
            }
            if (logEntry.getAction() != 14) continue;
            activity[i] = entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has removed link " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
        }
        return activity;
    }

    private static Boolean resourceExists(Registry registry, LogEntry entry) {
        try {
            return registry != null && entry != null && entry.getResourcePath() != null && registry.resourceExists(entry.getResourcePath());
        }
        catch (RegistryException ignore) {
            return false;
        }
    }

    private static String[] constructActivityStatementsfornormaluser(Registry registry, LogEntry[] logs, String Username) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < logs.length; ++i) {
            String entry;
            String[] actionData;
            String entry2;
            LogEntry logEntry = logs[i];
            if (!logEntry.getUserName().equals(Username)) continue;
            if (logEntry.getAction() == 0) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has added the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 1) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has updated the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 7) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has deleted the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 2) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has commented on resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + " with the following comment." + "|" + logEntry.getActionData();
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 3) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has deleted the comment '" + logEntry.getActionData() + "' on the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 4) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has tagged the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " with tag '" + logEntry.getActionData() + "'  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 5) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has removed the tag '" + logEntry.getActionData() + "' on the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 6) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has rated the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " with rating " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 15) {
                actionData = logEntry.getActionData().split(";");
                if (actionData == null || actionData.length < 2) continue;
                entry = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has added an association of type " + actionData[0] + " from the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the resource " + actionData[1] + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry);
                continue;
            }
            if (logEntry.getAction() == 16) {
                actionData = logEntry.getActionData().split(";");
                if (actionData == null || actionData.length < 2) continue;
                entry = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has removed an association of type " + actionData[0] + " from the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the resource " + actionData[1] + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry);
                continue;
            }
            if (logEntry.getAction() == 8) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has restored the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + (logEntry.getActionData() != null ? " to the version " + logEntry.getActionData() : "") + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 17) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has associated the aspect " + logEntry.getActionData() + " to the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 11) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has copied the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the Location " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 9) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has renamed the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to new Name: " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 10) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has moved the resource " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the Location " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 13) {
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has created a symbolic link " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the Location " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() == 12) {
                if (logEntry.getActionData().contains(";")) {
                    actionData = logEntry.getActionData().split(";");
                    if (actionData == null || actionData.length < 2) continue;
                    entry = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has created a remote link " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the instance " + actionData[0] + " at path " + actionData[1] + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                    list.add(entry);
                    continue;
                }
                entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has created a remote link " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + " to the Location " + logEntry.getActionData() + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
                list.add(entry2);
                continue;
            }
            if (logEntry.getAction() != 14) continue;
            entry2 = Boolean.toString(ActivityBeanPopulator.resourceExists(registry, logEntry)) + "|" + logEntry.getUserName() + "|" + logEntry.getUserName() + "|" + " has removed link " + "|" + logEntry.getResourcePath() + "|" + logEntry.getResourcePath() + "|" + "  " + CommonUtil.formatDate((Date)logEntry.getDate()) + ".";
            list.add(entry2);
        }
        String[] activity = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            activity[i] = (String)list.get(i);
        }
        return activity;
    }

    private static Date computeDate(String dateString) throws RegistryException {
        if (dateString == null || dateString.length() == 0) {
            return null;
        }
        DateFormat formatter = DateFormat.getDateInstance(3);
        try {
            return formatter.parse(dateString);
        }
        catch (ParseException e) {
            String msg = "Date format is invalid: " + dateString;
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

