/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.activities.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.activities.stub.ActivityAdminServiceStub;
import org.wso2.carbon.registry.activities.stub.beans.xsd.ActivityBean;
import org.wso2.carbon.registry.common.IActivityService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ActivityServiceClient
implements IActivityService {
    private static final Log log = LogFactory.getLog(ActivityServiceClient.class);
    private ActivityAdminServiceStub stub;
    private IActivityService proxy = null;

    public ActivityServiceClient(String cookie, ServletConfig config, HttpSession session) throws RegistryException {
        if (this.proxy == null) {
            String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
            ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
            String epr = backendServerURL + "ActivityAdminService";
            try {
                this.stub = new ActivityAdminServiceStub(configContext, epr);
                ServiceClient client = this.stub._getServiceClient();
                Options option = client.getOptions();
                option.setManageSession(true);
                option.setProperty("Cookie", (Object)cookie);
            }
            catch (AxisFault axisFault) {
                String msg = "Failed to initiate comment service client. " + axisFault.getMessage();
                log.error((Object)msg, (Throwable)axisFault);
                throw new RegistryException(msg, (Throwable)axisFault);
            }
            this.proxy = this;
        }
    }

    public void setSession(String sessionId, HttpSession session) {
    }

    public void removeSession(String sessionId) {
    }

    public org.wso2.carbon.registry.common.beans.ActivityBean getActivities(HttpServletRequest request) {
        String sessionId = UUIDGenerator.generateUUID();
        String userName = request.getParameter("userName");
        String resourcePath = request.getParameter("path");
        String fromDate = request.getParameter("fromDate");
        String toDate = request.getParameter("toDate");
        String filter = request.getParameter("filter");
        String pageStr = request.getParameter("page");
        try {
            return (org.wso2.carbon.registry.common.beans.ActivityBean)this.proxy.getActivities(userName, resourcePath, fromDate, toDate, filter, pageStr, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to get activities from the activity service.";
            log.error((Object)msg, (Throwable)e);
            return null;
        }
    }

    public org.wso2.carbon.registry.common.beans.ActivityBean getRecentActivitiesForLoginUser(HttpServletRequest request) {
        String sessionId = UUIDGenerator.generateUUID();
        String LOGGED_USER = "logged-user";
        String userName = (String)request.getSession().getAttribute(LOGGED_USER);
        String resourcePath = null;
        String fromDate = null;
        String toDate = null;
        String filter = "all";
        String pageStr = "1";
        try {
            return (org.wso2.carbon.registry.common.beans.ActivityBean)this.proxy.getActivities(userName, resourcePath, fromDate, toDate, filter, pageStr, sessionId);
        }
        catch (Exception e) {
            String msg = "Failed to get activities from the activity service.";
            log.error((Object)msg, (Throwable)e);
            return null;
        }
    }

    public org.wso2.carbon.registry.common.beans.ActivityBean getActivities(String userName, String resourcePath, String fromDate, String toDate, String filter, String pageStr, String sessionId) throws RegistryException {
        org.wso2.carbon.registry.common.beans.ActivityBean result = new org.wso2.carbon.registry.common.beans.ActivityBean();
        try {
            ActivityBean bean = this.stub.getActivities(userName, resourcePath, fromDate, toDate, filter, pageStr, sessionId);
            if (bean.getActivity() == null) {
                bean.setActivity(new String[0]);
            }
            result.setErrorMessage(bean.getErrorMessage());
            result.setActivity(bean.getActivity());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return result;
    }
}

