/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.register.ui.utils;

import java.io.StringReader;
import java.util.Calendar;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.register.ui.clients.TenantSelfRegistrationClient;
import org.wso2.carbon.registry.common.ui.UIException;
import org.wso2.carbon.tenant.register.stub.beans.xsd.CaptchaInfoBean;
import org.wso2.carbon.tenant.register.stub.beans.xsd.TenantInfoBean;

public class TenantConfigUtil {
    private static final Log log = LogFactory.getLog(TenantConfigUtil.class);

    public static String registerTenantConfigBean(HttpServletRequest request, ServletConfig config, HttpSession session) throws UIException {
        TenantInfoBean tenantInfoBean = new TenantInfoBean();
        CaptchaInfoBean captchaInfoBean = new CaptchaInfoBean();
        try {
            tenantInfoBean.setFirstname(request.getParameter("admin-firstname"));
            tenantInfoBean.setLastname(request.getParameter("admin-lastname"));
            tenantInfoBean.setAdmin(request.getParameter("admin"));
            tenantInfoBean.setAdminPassword(request.getParameter("admin-password"));
            tenantInfoBean.setTenantDomain(TenantConfigUtil.resolveDomainName(request.getParameter("domain")));
            tenantInfoBean.setEmail(request.getParameter("admin-email"));
            tenantInfoBean.setSuccessKey((String)session.getAttribute("validate-domain-success-key"));
            tenantInfoBean.setUsagePlan(request.getParameter("usage-plan-name"));
            tenantInfoBean.setOriginatedService(TenantConfigUtil.base64Decode((String)session.getAttribute("originatedService")));
            tenantInfoBean.setCreatedDate(Calendar.getInstance());
            captchaInfoBean.setSecretKey(request.getParameter("captcha-secret-key"));
            captchaInfoBean.setUserAnswer(request.getParameter("captcha-user-answer"));
            TenantSelfRegistrationClient selfRegistrationClient = new TenantSelfRegistrationClient(config, session);
            String returnText = selfRegistrationClient.registerTenant(tenantInfoBean, captchaInfoBean);
            return returnText;
        }
        catch (Exception e) {
            AxisFault fault = new AxisFault(e.getMessage());
            String msg = fault.getReason() + " Failed to add tenant config. tenant-domain: " + tenantInfoBean.getTenantDomain() + ", " + "tenant-admin: " + tenantInfoBean.getAdmin() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(e.getMessage(), (Throwable)e);
        }
    }

    public static void setSubmissionValuesForSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.setAttribute("submit-domain", (Object)TenantConfigUtil.resolveDomainName(request.getParameter("domain")));
        session.setAttribute("submit-admin", (Object)request.getParameter("admin"));
        session.setAttribute("submit-admin-firstname", (Object)request.getParameter("admin-firstname"));
        session.setAttribute("submit-admin-lastname", (Object)request.getParameter("admin-lastname"));
        session.setAttribute("submit-admin-email", (Object)request.getParameter("admin-email"));
    }

    public static boolean checkDomainAvailability(HttpServletRequest request, ServletConfig config, HttpSession session) throws UIException {
        String tenantDomain = null;
        try {
            tenantDomain = TenantConfigUtil.resolveDomainName(request.getParameter("domain"));
            TenantSelfRegistrationClient selfRegistrationClient = new TenantSelfRegistrationClient(config, session);
            return selfRegistrationClient.checkDomainAvailability(tenantDomain);
        }
        catch (Exception e) {
            String msg = "Failed to check the domain availability:" + tenantDomain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static String validateOrSuggestDomain(ServletConfig config, HttpSession session) throws UIException {
        String tempDomainToRegister = TenantConfigUtil.resolveDomainName((String)session.getAttribute("temp-domain-to-register"));
        String successKey = (String)session.getAttribute("validate-domain-success-key");
        try {
            TenantSelfRegistrationClient selfRegistrationClient = new TenantSelfRegistrationClient(config, session);
            return selfRegistrationClient.validateOrSuggestDomain(tempDomainToRegister, successKey);
        }
        catch (Exception e) {
            String msg = "Failed to validate or suggest a domain related to :" + tempDomainToRegister + ".";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static CaptchaInfoBean generateRandomCaptcha(ServletConfig config, HttpSession session) throws UIException {
        try {
            TenantSelfRegistrationClient selfRegistrationClient = new TenantSelfRegistrationClient(config, session);
            return selfRegistrationClient.generateRandomCaptcha();
        }
        catch (Exception e) {
            String msg = "Error in generating the captcha image.";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static HttpServletRequest readIntermediateData(HttpServletRequest request, String data) {
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(data));
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement documentElement = builder.getDocumentElement();
            Iterator it = documentElement.getChildElements();
            while (it.hasNext()) {
                OMElement element = (OMElement)it.next();
                if ("admin".equals(element.getLocalName())) {
                    request.setAttribute("admin", (Object)element.getText());
                    continue;
                }
                if ("firstname".equals(element.getText())) {
                    request.setAttribute("firstname", (Object)element.getText());
                    continue;
                }
                if ("lastname".equals(element.getText())) {
                    request.setAttribute("lastname", (Object)element.getText());
                    continue;
                }
                if ("email".equals(element.getLocalName())) {
                    request.setAttribute("email", (Object)element.getText());
                    continue;
                }
                if ("tenantDomain".equals(element.getLocalName())) {
                    request.setAttribute("tenantDomain", (Object)element.getText());
                    continue;
                }
                if (!"confirmationKey".equals(element.getLocalName())) continue;
                request.setAttribute("confirmationKey", (Object)element.getText());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error parsing xml", (Throwable)e);
        }
        return request;
    }

    public static String resolveDomainName(String domainNameUserInput) {
        if (domainNameUserInput == null) {
            String msg = "Provided domain name is null";
            log.error((Object)msg);
            return "";
        }
        String domainName = domainNameUserInput.trim();
        if (domainName.startsWith("www.")) {
            domainName = domainName.substring(4);
        }
        return domainName;
    }

    private static String base64Decode(String encodedStr) {
        String decodedStr = null;
        if (encodedStr != null && !"null".equals(encodedStr)) {
            decodedStr = new String(Base64.decode((String)encodedStr));
        }
        return decodedStr;
    }
}

