/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.register.ui.clients;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.stratos.common.packages.stub.PackageInfo;
import org.wso2.carbon.stratos.common.packages.stub.PackageInfoServiceStub;

public class PackageInfoServiceClient {
    private static Log log = LogFactory.getLog(PackageInfoServiceClient.class);
    private PackageInfoServiceStub stub;
    private String epr;

    public PackageInfoServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws Exception {
        this.epr = backendServerURL + "PackageInfoService";
        try {
            this.stub = new PackageInfoServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate PackageInfoService client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public PackageInfo[] getBillingPackages() throws Exception {
        try {
            return this.stub.getPackageInfos();
        }
        catch (Exception e) {
            String msg = "Failed to get package information: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public JSONArray getBillingPackagesJsonArray() throws Exception {
        try {
            PackageInfo[] packageInfoArray = this.stub.getPackageInfos();
            JSONArray jsonPackageInfoArray = new JSONArray();
            for (PackageInfo packageInfo : packageInfoArray) {
                JSONObject packageInfoObj = new JSONObject();
                packageInfoObj.put("name", (Object)packageInfo.getName());
                packageInfoObj.put("subscriptionCharge", packageInfo.getSubscriptionCharge());
                jsonPackageInfoArray.put((Object)packageInfoObj);
            }
            return jsonPackageInfoArray;
        }
        catch (Exception e) {
            String msg = "Failed to get package information: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }
}

